/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.pipeline.context;

import me.jellysquid.mods.sodium.client.model.light.LightPipelineProvider;
import me.jellysquid.mods.sodium.client.model.light.cache.ArrayLightDataCache;
import me.jellysquid.mods.sodium.client.model.quad.blender.BiomeColorBlender;
import me.jellysquid.mods.sodium.client.render.pipeline.BlockRenderer;
import me.jellysquid.mods.sodium.client.render.pipeline.ChunkRenderCache;
import me.jellysquid.mods.sodium.client.render.pipeline.FluidRenderer;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.World;
import org.embeddedt.embeddium.render.EmbeddiumRenderLayerCache;
import org.embeddedt.embeddium.render.world.WorldSliceLocalGenerator;

public class ChunkRenderCacheLocal
extends ChunkRenderCache {
    private final ArrayLightDataCache lightDataCache;
    private final BlockRenderer blockRenderer;
    private final FluidRenderer fluidRenderer;
    private final BlockModelShapes blockModels;
    private final WorldSlice worldSlice;
    private IBlockDisplayReader localSlice;
    private final EmbeddiumRenderLayerCache renderLayerCache;

    public ChunkRenderCacheLocal(Minecraft client, World world) {
        this.worldSlice = new WorldSlice(world);
        this.lightDataCache = new ArrayLightDataCache(this.worldSlice);
        LightPipelineProvider lightPipelineProvider = new LightPipelineProvider(this.lightDataCache);
        BiomeColorBlender biomeColorBlender = this.createBiomeColorBlender();
        this.blockRenderer = new BlockRenderer(client, lightPipelineProvider, biomeColorBlender);
        this.fluidRenderer = new FluidRenderer(client, lightPipelineProvider, biomeColorBlender);
        this.blockModels = client.func_209506_al().func_174954_c();
        this.renderLayerCache = new EmbeddiumRenderLayerCache();
    }

    public BlockModelShapes getBlockModels() {
        return this.blockModels;
    }

    public BlockRenderer getBlockRenderer() {
        return this.blockRenderer;
    }

    public FluidRenderer getFluidRenderer() {
        return this.fluidRenderer;
    }

    public EmbeddiumRenderLayerCache getRenderLayerCache() {
        return this.renderLayerCache;
    }

    public void init(ChunkRenderContext context) {
        this.lightDataCache.reset(context.getOrigin());
        this.worldSlice.copyData(context);
        this.localSlice = WorldSliceLocalGenerator.generate(this.worldSlice);
    }

    public WorldSlice getWorldSlice() {
        return this.worldSlice;
    }

    public IBlockDisplayReader getLocalSlice() {
        return this.localSlice;
    }
}

