/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.util;

import me.jellysquid.mods.sodium.client.model.quad.ModelQuadView;
import me.jellysquid.mods.sodium.client.model.quad.properties.ModelQuadFacing;
import me.jellysquid.mods.sodium.client.util.Norm3b;
import me.jellysquid.mods.sodium.client.util.color.ColorABGR;
import me.jellysquid.mods.sodium.common.util.DirectionUtil;
import net.minecraft.util.Direction;
import net.minecraft.util.math.MathHelper;

public class ModelQuadUtil {
    public static final int POSITION_INDEX = 0;
    public static final int COLOR_INDEX = 3;
    public static final int TEXTURE_INDEX = 4;
    public static final int LIGHT_INDEX = 6;
    public static final int NORMAL_INDEX = 7;
    public static final int VERTEX_SIZE = 8;
    public static final int VERTEX_SIZE_BYTES = 32;
    static final int[] NORMALS = new int[DirectionUtil.ALL_DIRECTIONS.length];

    public static int getFacingNormal(Direction facing) {
        return NORMALS[facing.ordinal()];
    }

    public static int getFacingNormal(Direction facing, int bakedNormal) {
        if (!ModelQuadUtil.hasNormal(bakedNormal)) {
            return NORMALS[facing.ordinal()];
        }
        return bakedNormal;
    }

    public static boolean hasNormal(int n) {
        return (n & 0xFFFFFF) != 0;
    }

    public static int vertexOffset(int vertexIndex) {
        return vertexIndex * 8;
    }

    public static int mergeBakedLight(int packedLight, int calcLight) {
        if (packedLight == 0) {
            return calcLight;
        }
        int psl = packedLight >> 16 & 0xFF;
        int csl = calcLight >> 16 & 0xFF;
        int pbl = packedLight & 0xFF;
        int cbl = calcLight & 0xFF;
        int bl = Math.max(pbl, cbl);
        int sl = Math.max(psl, csl);
        return sl << 16 | bl;
    }

    public static int mixABGRColors(int colorA, int colorB) {
        if (colorA == -1) {
            return colorB;
        }
        if (colorB == -1) {
            return colorA;
        }
        int a = (int)((float)ColorABGR.unpackAlpha(colorA) / 255.0f * ((float)ColorABGR.unpackAlpha(colorB) / 255.0f) * 255.0f);
        int b = (int)((float)ColorABGR.unpackBlue(colorA) / 255.0f * ((float)ColorABGR.unpackBlue(colorB) / 255.0f) * 255.0f);
        int g = (int)((float)ColorABGR.unpackGreen(colorA) / 255.0f * ((float)ColorABGR.unpackGreen(colorB) / 255.0f) * 255.0f);
        int r = (int)((float)ColorABGR.unpackRed(colorA) / 255.0f * ((float)ColorABGR.unpackRed(colorB) / 255.0f) * 255.0f);
        return ColorABGR.pack(r, g, b, a);
    }

    public static ModelQuadFacing findNormalFace(float x, float y, float z) {
        if (!(Float.isFinite(x) && Float.isFinite(y) && Float.isFinite(z))) {
            return ModelQuadFacing.UNASSIGNED;
        }
        float maxDot = 0.0f;
        Direction closestFace = null;
        for (Direction face : DirectionUtil.ALL_DIRECTIONS) {
            float dot = x * (float)face.func_82601_c() + y * (float)face.func_96559_d() + z * (float)face.func_82599_e();
            if (!(dot > maxDot)) continue;
            maxDot = dot;
            closestFace = face;
        }
        if (closestFace != null && MathHelper.func_180185_a((float)maxDot, (float)1.0f)) {
            return ModelQuadFacing.fromDirection(closestFace);
        }
        return ModelQuadFacing.UNASSIGNED;
    }

    public static ModelQuadFacing findNormalFace(int normal) {
        return ModelQuadUtil.findNormalFace(Norm3b.unpackX(normal), Norm3b.unpackY(normal), Norm3b.unpackZ(normal));
    }

    public static int calculateNormal(ModelQuadView quad) {
        float normZ;
        float dx0;
        float dx1;
        float normY;
        float dy1;
        float dz0;
        float x0 = quad.getX(0);
        float y0 = quad.getY(0);
        float z0 = quad.getZ(0);
        float x1 = quad.getX(1);
        float y1 = quad.getY(1);
        float z1 = quad.getZ(1);
        float x2 = quad.getX(2);
        float y2 = quad.getY(2);
        float z2 = quad.getZ(2);
        float x3 = quad.getX(3);
        float y3 = quad.getY(3);
        float dy0 = y2 - y0;
        float z3 = quad.getZ(3);
        float dz1 = z3 - z1;
        float normX = dy0 * dz1 - (dz0 = z2 - z0) * (dy1 = y3 - y1);
        float l = (float)Math.sqrt(normX * normX + (normY = dz0 * (dx1 = x3 - x1) - (dx0 = x2 - x0) * dz1) * normY + (normZ = dx0 * dy1 - dy0 * dx1) * normZ);
        if (l != 0.0f) {
            normX /= l;
            normY /= l;
            normZ /= l;
        }
        return Norm3b.pack(normX, normY, normZ);
    }

    static {
        for (int i = 0; i < NORMALS.length; ++i) {
            ModelQuadUtil.NORMALS[i] = Norm3b.pack(DirectionUtil.ALL_DIRECTIONS[i].func_176730_m());
        }
    }
}

