/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world.biome;

import me.jellysquid.mods.sodium.client.world.ClientWorldExtended;
import me.jellysquid.mods.sodium.client.world.WorldSlice;
import me.jellysquid.mods.sodium.client.world.biome.QuartPos;
import me.jellysquid.mods.sodium.client.world.cloned.ChunkRenderContext;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSection;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.FastRandom;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;

public class BiomeSlice {
    private static final int SIZE = 12;
    private final Biome[] biomes = new Biome[1728];
    private final boolean[] uniform = new boolean[1728];
    private final BiasMap bias = new BiasMap();
    private long biomeSeed;
    private int worldX;
    private int worldY;
    private int worldZ;
    private final boolean is3D;

    public BiomeSlice() {
        this(true);
    }

    public BiomeSlice(boolean is3D) {
        this.is3D = is3D;
    }

    public void update(ClientWorld world, ChunkRenderContext context) {
        this.worldX = context.getOrigin().func_218161_d() - 16;
        this.worldY = (this.is3D ? context.getOrigin().func_218151_e() : 0) - 16;
        this.worldZ = context.getOrigin().func_218164_f() - 16;
        this.biomeSeed = ((ClientWorldExtended)world).getBiomeSeed();
        this.copyBiomeData((World)world, context);
        this.calculateBias();
        this.calculateUniform();
    }

    private void copyBiomeData(World world, ChunkRenderContext context) {
        for (int sectionX = 0; sectionX < 3; ++sectionX) {
            for (int sectionY = 0; sectionY < 3; ++sectionY) {
                for (int sectionZ = 0; sectionZ < 3; ++sectionZ) {
                    this.copySectionBiomeData(context, sectionX, sectionY, sectionZ);
                }
            }
        }
    }

    private void copySectionBiomeData(ChunkRenderContext context, int sectionX, int sectionY, int sectionZ) {
        ClonedChunkSection section = context.getSections()[WorldSlice.getLocalSectionIndex(sectionX, sectionY, sectionZ)];
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                int z = 0;
                while (z < 4) {
                    int biomeX = sectionX * 4 + x;
                    int biomeY = sectionY * 4 + y;
                    int biomeZ = sectionZ * 4 + z;
                    int idx = BiomeSlice.dataArrayIndex(biomeX, biomeY, biomeZ);
                    int chunkX = x;
                    int chunkY = y + sectionY * 4 + this.worldY / 4;
                    int chunkZ = z++;
                    this.biomes[idx] = section.getBiomeForNoiseGen(chunkX, chunkY, chunkZ);
                }
            }
        }
    }

    private void calculateUniform() {
        for (int x = 2; x < 10; ++x) {
            for (int y = 2; y < 10; ++y) {
                for (int z = 2; z < 10; ++z) {
                    this.uniform[BiomeSlice.dataArrayIndex((int)x, (int)y, (int)z)] = this.hasUniformNeighbors(x, y, z);
                }
            }
        }
    }

    private void calculateBias() {
        int offsetX = this.worldX >> 2;
        int offsetY = this.worldY >> 2;
        int offsetZ = this.worldZ >> 2;
        long seed = this.biomeSeed;
        for (int cellX = 1; cellX < 11; ++cellX) {
            int worldCellX = offsetX + cellX;
            long seedX = FastRandom.func_226162_a_((long)seed, (long)worldCellX);
            for (int cellY = 1; cellY < 11; ++cellY) {
                int worldCellY = offsetY + cellY;
                long seedXY = FastRandom.func_226162_a_((long)seedX, (long)worldCellY);
                for (int cellZ = 1; cellZ < 11; ++cellZ) {
                    int worldCellZ = offsetZ + cellZ;
                    long seedXYZ = FastRandom.func_226162_a_((long)seedXY, (long)worldCellZ);
                    this.calculateBias(BiomeSlice.dataArrayIndex(cellX, cellY, cellZ), worldCellX, worldCellY, worldCellZ, seedXYZ);
                }
            }
        }
    }

    private void calculateBias(int index, int x, int y, int z, long seed) {
        seed = FastRandom.func_226162_a_((long)seed, (long)x);
        seed = FastRandom.func_226162_a_((long)seed, (long)y);
        seed = FastRandom.func_226162_a_((long)seed, (long)z);
        int gradX = BiomeSlice.getBias(seed);
        seed = FastRandom.func_226162_a_((long)seed, (long)this.biomeSeed);
        int gradY = BiomeSlice.getBias(seed);
        seed = FastRandom.func_226162_a_((long)seed, (long)this.biomeSeed);
        int gradZ = BiomeSlice.getBias(seed);
        this.bias.set(index, gradX, gradY, gradZ);
    }

    private boolean hasUniformNeighbors(int x, int y, int z) {
        Biome biome = this.biomes[BiomeSlice.dataArrayIndex(x, y, z)];
        int minX = x - 1;
        int maxX = x + 1;
        int minY = y - 1;
        int maxY = y + 1;
        int minZ = z - 1;
        int maxZ = z + 1;
        for (int adjX = minX; adjX <= maxX; ++adjX) {
            for (int adjY = minY; adjY <= maxY; ++adjY) {
                for (int adjZ = minZ; adjZ <= maxZ; ++adjZ) {
                    if (this.biomes[BiomeSlice.dataArrayIndex(adjX, adjY, adjZ)] == biome) continue;
                    return false;
                }
            }
        }
        return true;
    }

    public Biome getBiome(int x, int y, int z) {
        if (!this.is3D) {
            y = 0;
        }
        int relX = x - this.worldX;
        int relY = y - this.worldY;
        int relZ = z - this.worldZ;
        int centerIndex = BiomeSlice.dataArrayIndex(QuartPos.fromBlock(relX - 2), QuartPos.fromBlock(relY - 2), QuartPos.fromBlock(relZ - 2));
        if (this.uniform[centerIndex]) {
            return this.biomes[centerIndex];
        }
        return this.getBiomeUsingVoronoi(relX, relY, relZ);
    }

    private Biome getBiomeUsingVoronoi(int worldX, int worldY, int worldZ) {
        int x = worldX - 2;
        int y = worldY - 2;
        int z = worldZ - 2;
        int intX = QuartPos.fromBlock(x);
        int intY = QuartPos.fromBlock(y);
        int intZ = QuartPos.fromBlock(z);
        float fracX = (float)QuartPos.quartLocal(x) * 0.25f;
        float fracY = (float)QuartPos.quartLocal(y) * 0.25f;
        float fracZ = (float)QuartPos.quartLocal(z) * 0.25f;
        float closestDistance = Float.POSITIVE_INFINITY;
        int closestArrayIndex = 0;
        for (int index = 0; index < 8; ++index) {
            float distanceZ;
            float distanceY;
            boolean dirX = (index & 4) != 0;
            boolean dirY = (index & 2) != 0;
            boolean dirZ = (index & 1) != 0;
            int adjIntX = intX + (dirX ? 1 : 0);
            int adjIntY = intY + (dirY ? 1 : 0);
            int adjIntZ = intZ + (dirZ ? 1 : 0);
            float adjFracX = fracX - (dirX ? 1.0f : 0.0f);
            float adjFracY = fracY - (dirY ? 1.0f : 0.0f);
            float adjFracZ = fracZ - (dirZ ? 1.0f : 0.0f);
            int biasIndex = BiomeSlice.dataArrayIndex(adjIntX, adjIntY, adjIntZ);
            float biasX = BiomeSlice.biasToVector(this.bias.getX(biasIndex));
            float biasY = BiomeSlice.biasToVector(this.bias.getY(biasIndex));
            float biasZ = BiomeSlice.biasToVector(this.bias.getZ(biasIndex));
            float distanceX = MathHelper.func_233022_k_((float)(adjFracX + biasX));
            float distance = distanceX + (distanceY = MathHelper.func_233022_k_((float)(adjFracY + biasY))) + (distanceZ = MathHelper.func_233022_k_((float)(adjFracZ + biasZ)));
            if (!(closestDistance > distance)) continue;
            closestArrayIndex = biasIndex;
            closestDistance = distance;
        }
        return this.biomes[closestArrayIndex];
    }

    private static int dataArrayIndex(int x, int y, int z) {
        return x * 12 * 12 + y * 12 + z;
    }

    private static float biasToVector(int bias) {
        return (float)bias * 9.765625E-4f * 0.9f;
    }

    private static int getBias(long l) {
        return (int)((l >> 24 & 0x3FFL) - 512L);
    }

    public static class BiasMap {
        private final short[] data = new short[5184];

        public void set(int index, int x, int y, int z) {
            this.data[index * 3 + 0] = (short)x;
            this.data[index * 3 + 1] = (short)y;
            this.data[index * 3 + 2] = (short)z;
        }

        public int getX(int index) {
            return this.data[index * 3 + 0];
        }

        public int getY(int index) {
            return this.data[index * 3 + 1];
        }

        public int getZ(int index) {
            return this.data[index * 3 + 2];
        }
    }
}

