/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.world.cloned;

import it.unimi.dsi.fastutil.longs.Long2ReferenceLinkedOpenHashMap;
import java.util.concurrent.TimeUnit;
import me.jellysquid.mods.sodium.client.world.cloned.ClonedChunkSection;
import net.minecraft.util.math.SectionPos;
import net.minecraft.world.World;

public class ClonedChunkSectionCache {
    private static final int MAX_CACHE_SIZE = 512;
    private static final long MAX_CACHE_DURATION = TimeUnit.SECONDS.toNanos(5L);
    private final World world;
    private final Long2ReferenceLinkedOpenHashMap<ClonedChunkSection> byPosition = new Long2ReferenceLinkedOpenHashMap();
    private long time;

    public ClonedChunkSectionCache(World world) {
        this.world = world;
        this.time = ClonedChunkSectionCache.getMonotonicTimeSource();
    }

    public synchronized void cleanup() {
        this.time = ClonedChunkSectionCache.getMonotonicTimeSource();
        this.byPosition.values().removeIf(entry -> this.time > entry.getLastUsedTimestamp() + MAX_CACHE_DURATION);
    }

    public synchronized ClonedChunkSection acquire(int x, int y, int z) {
        long key = SectionPos.func_218166_b((int)x, (int)y, (int)z);
        ClonedChunkSection section = (ClonedChunkSection)this.byPosition.get(key);
        if (section == null) {
            while (this.byPosition.size() >= 512) {
                this.byPosition.removeFirst();
            }
            section = this.createSection(x, y, z);
        }
        section.setLastUsedTimestamp(this.time);
        return section;
    }

    private ClonedChunkSection createSection(int x, int y, int z) {
        ClonedChunkSection section = this.allocate();
        SectionPos pos = SectionPos.func_218154_a((int)x, (int)y, (int)z);
        section.init(pos);
        this.byPosition.putAndMoveToLast(pos.func_218146_v(), (Object)section);
        return section;
    }

    public synchronized void invalidate(int x, int y, int z) {
        this.byPosition.remove(SectionPos.func_218166_b((int)x, (int)y, (int)z));
    }

    public void release(ClonedChunkSection section) {
    }

    private ClonedChunkSection allocate() {
        return new ClonedChunkSection(this, this.world);
    }

    private static long getMonotonicTimeSource() {
        return System.nanoTime();
    }
}

