/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.mixin.features.gui;

import com.google.common.base.Strings;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldVertexBufferUploader;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.gui.ForgeIngameGui;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={ForgeIngameGui.class})
public abstract class MixinDebugHud
extends IngameGui {
    @Shadow(remap=false)
    private FontRenderer fontrenderer;

    @Shadow
    protected abstract void post(RenderGameOverlayEvent.ElementType var1, MatrixStack var2);

    public MixinDebugHud(Minecraft p_93005_) {
        super(p_93005_);
    }

    @Inject(method={"renderHUDText"}, at={@At(value="INVOKE", target="Ljava/util/ArrayList;iterator()Ljava/util/Iterator;", ordinal=0)}, locals=LocalCapture.CAPTURE_FAILHARD, cancellable=true, remap=false)
    private void embeddium$renderTextFast(int width, int height, MatrixStack poseStack, CallbackInfo ci, ArrayList<String> listL, ArrayList<String> listR, RenderGameOverlayEvent.Text event) {
        ci.cancel();
        this.renderForgeList(poseStack, listL, false);
        this.renderForgeList(poseStack, listR, true);
        this.field_73839_d.func_213239_aq().func_76319_b();
        this.post(RenderGameOverlayEvent.ElementType.TEXT, poseStack);
    }

    private void renderForgeList(MatrixStack matrixStack, List<String> list, boolean right) {
        this.renderBackdrop(matrixStack, list, right);
        this.renderStrings(matrixStack, list, right);
    }

    private void renderStrings(MatrixStack matrixStack, List<String> list, boolean right) {
        IRenderTypeBuffer.Impl immediate = IRenderTypeBuffer.func_228455_a_((BufferBuilder)Tessellator.func_178181_a().func_178180_c());
        Matrix4f modelMatrix = matrixStack.func_227866_c_().func_227870_a_();
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (Strings.isNullOrEmpty((String)string)) continue;
            int height = 9;
            int width = this.fontrenderer.func_78256_a(string);
            float x1 = right ? (float)(this.field_73839_d.func_228018_at_().func_198107_o() - 2 - width) : 2.0f;
            float y1 = 2 + height * i;
            this.fontrenderer.func_238411_a_(string, x1, y1, 0xE0E0E0, false, modelMatrix, (IRenderTypeBuffer)immediate, false, 0, 0xF000F0, this.fontrenderer.func_78260_a());
        }
        immediate.func_228461_a_();
    }

    private void renderBackdrop(MatrixStack matrixStack, List<String> list, boolean right) {
        RenderSystem.enableBlend();
        RenderSystem.disableTexture();
        RenderSystem.defaultBlendFunc();
        int color = -1873784752;
        float f = (float)(color >> 24 & 0xFF) / 255.0f;
        float g = (float)(color >> 16 & 0xFF) / 255.0f;
        float h = (float)(color >> 8 & 0xFF) / 255.0f;
        float k = (float)(color & 0xFF) / 255.0f;
        BufferBuilder bufferBuilder = Tessellator.func_178181_a().func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        Matrix4f matrix = matrixStack.func_227866_c_().func_227870_a_();
        for (int i = 0; i < list.size(); ++i) {
            String string = list.get(i);
            if (Strings.isNullOrEmpty((String)string)) continue;
            int height = 9;
            int width = this.fontrenderer.func_78256_a(string);
            int x = right ? this.field_73839_d.func_228018_at_().func_198107_o() - 2 - width : 2;
            int y = 2 + height * i;
            float x1 = x - 1;
            float y1 = y - 1;
            float x2 = x + width + 1;
            float y2 = y + height - 1;
            bufferBuilder.func_227888_a_(matrix, x1, y2, 0.0f).func_227885_a_(g, h, k, f).func_181675_d();
            bufferBuilder.func_227888_a_(matrix, x2, y2, 0.0f).func_227885_a_(g, h, k, f).func_181675_d();
            bufferBuilder.func_227888_a_(matrix, x2, y1, 0.0f).func_227885_a_(g, h, k, f).func_181675_d();
            bufferBuilder.func_227888_a_(matrix, x1, y1, 0.0f).func_227885_a_(g, h, k, f).func_181675_d();
        }
        bufferBuilder.func_178977_d();
        WorldVertexBufferUploader.func_181679_a((BufferBuilder)bufferBuilder);
        RenderSystem.enableTexture();
        RenderSystem.disableBlend();
    }
}

