/*
 * Decompiled with CFR 0.152.
 */
package org.embeddedt.embeddium.api;

import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.List;
import java.util.Random;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraftforge.client.model.data.IModelData;

public class BlockRendererRegistry {
    private static final BlockRendererRegistry instance = new BlockRendererRegistry();
    private final List<RenderPopulator> renderPopulators = new CopyOnWriteArrayList<RenderPopulator>();

    private BlockRendererRegistry() {
    }

    public static BlockRendererRegistry instance() {
        return instance;
    }

    public void registerRenderPopulator(RenderPopulator populator) {
        this.renderPopulators.add(populator);
    }

    public void fillCustomRenderers(List<Renderer> resultList, BlockState state, BlockPos pos, IBlockDisplayReader world) {
        if (this.renderPopulators.isEmpty()) {
            return;
        }
        for (RenderPopulator populator : this.renderPopulators) {
            populator.fillCustomRenderers(resultList, state, pos, world);
        }
    }

    public static interface RenderPopulator {
        public void fillCustomRenderers(List<Renderer> var1, BlockState var2, BlockPos var3, IBlockDisplayReader var4);

        public static RenderPopulator forRenderer(Renderer renderer) {
            return (resultList, state, pos, world) -> resultList.add(renderer);
        }
    }

    public static interface Renderer {
        public RenderResult renderBlock(BlockState var1, BlockPos var2, IBlockDisplayReader var3, IVertexBuilder var4, Random var5, IModelData var6);
    }

    public static enum RenderResult {
        OVERRIDE,
        PASS;

    }
}

