/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.api.reactor;

import net.minecraft.util.math.MathHelper;

public class FuelProperties {
    public static final FuelProperties DEFAULT = new FuelProperties(1.5f, 0.5f, 1.0f, 0.01f, 7.0E-4f);
    public static final FuelProperties INVALID = new FuelProperties(1.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    private float _fuelModerationFactor;
    private float _fuelAbsorptionCoefficient;
    private float _fuelHardnessDivisor;
    private float _fissionEventsPerFuelUnit;
    private float _fuelUnitsPerFissionEvent;

    FuelProperties(float moderationFactor, float absorptionCoefficient, float hardnessDivisor, float fissionEventsPerFuelUnit, float fuelUnitsPerFissionEvent) {
        this.setModerationFactor(moderationFactor);
        this.setAbsorptionCoefficient(absorptionCoefficient);
        this.setHardnessDivisor(hardnessDivisor);
        this.setFissionEventsPerFuelUnit(fissionEventsPerFuelUnit);
        this.setFuelUnitsPerFissionEvent(fuelUnitsPerFissionEvent);
    }

    public float getModerationFactor() {
        return this._fuelModerationFactor;
    }

    public void setModerationFactor(float value) {
        this._fuelModerationFactor = Math.max(1.0f, value);
    }

    public float getAbsorptionCoefficient() {
        return this._fuelAbsorptionCoefficient;
    }

    public void setAbsorptionCoefficient(float value) {
        this._fuelAbsorptionCoefficient = MathHelper.func_76131_a((float)value, (float)0.0f, (float)1.0f);
    }

    public float getHardnessDivisor() {
        return this._fuelHardnessDivisor;
    }

    public void setHardnessDivisor(float value) {
        this._fuelHardnessDivisor = Math.max(1.0f, value);
    }

    public float getFissionEventsPerFuelUnit() {
        return this._fissionEventsPerFuelUnit;
    }

    public void setFissionEventsPerFuelUnit(float value) {
        this._fissionEventsPerFuelUnit = Math.max(0.0f, value);
    }

    public float getFuelUnitsPerFissionEvent() {
        return this._fuelUnitsPerFissionEvent;
    }

    public void setFuelUnitsPerFissionEvent(float value) {
        this._fuelUnitsPerFissionEvent = Math.max(0.0f, value);
    }
}

