/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.api.reactor;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.Maps;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import it.unimi.dsi.fastutil.objects.ObjectLists;
import it.zerono.mods.extremereactors.Log;
import it.zerono.mods.extremereactors.api.ExtremeReactorsAPI;
import it.zerono.mods.extremereactors.api.internal.InternalDispatcher;
import it.zerono.mods.extremereactors.api.internal.modpack.wrapper.ApiWrapper;
import it.zerono.mods.extremereactors.api.reactor.FuelProperties;
import it.zerono.mods.extremereactors.api.reactor.Reactant;
import it.zerono.mods.extremereactors.api.reactor.ReactantType;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.logging.log4j.Marker;
import org.apache.logging.log4j.MarkerManager;

public final class ReactantsRegistry {
    private static final Map<String, Reactant> s_reactants = Maps.newHashMap();
    private static final Marker MARKER = MarkerManager.getMarker((String)"API/ReactantsRegistry").addParents(new Marker[]{ExtremeReactorsAPI.MARKER});
    private static final Marker WRAPPER = MarkerManager.getMarker((String)"ModPack API Wrapper").addParents(new Marker[]{MARKER});

    public static boolean contains(String name) {
        return s_reactants.containsKey(name);
    }

    public static Optional<Reactant> get(String name) {
        return Optional.ofNullable(s_reactants.get(name));
    }

    public static void register(String name, ReactantType type, int rgbColour, String translationKey) {
        Preconditions.checkNotNull((Object)((Object)type));
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        InternalDispatcher.dispatch("reactant-register", () -> {
            if (s_reactants.containsKey(name)) {
                ExtremeReactorsAPI.LOGGER.warn(MARKER, "Overwriting data for reactant {}", (Object)name);
            }
            s_reactants.put(name, new Reactant(name, type, rgbColour, translationKey, FuelProperties.DEFAULT));
        });
    }

    public static void registerFuel(String name, int rgbColour, float moderationFactor, float absorptionCoefficient, float hardnessDivisor, String translationKey) {
        ReactantsRegistry.registerFuel(name, rgbColour, moderationFactor, absorptionCoefficient, hardnessDivisor, FuelProperties.DEFAULT.getFissionEventsPerFuelUnit(), FuelProperties.DEFAULT.getFuelUnitsPerFissionEvent(), translationKey);
    }

    public static void registerFuel(String name, int rgbColour, float moderationFactor, float absorptionCoefficient, float hardnessDivisor, float fissionEventsPerFuelUnit, float fuelUnitsPerFissionEvent, String translationKey) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        InternalDispatcher.dispatch("reactant-register", () -> {
            if (s_reactants.containsKey(name)) {
                ExtremeReactorsAPI.LOGGER.warn(MARKER, "Overwriting data for fuel reactant {}", (Object)name);
            }
            s_reactants.put(name, new Reactant(name, ReactantType.Fuel, rgbColour, translationKey, new FuelProperties(moderationFactor, absorptionCoefficient, hardnessDivisor, fissionEventsPerFuelUnit, fuelUnitsPerFissionEvent)));
        });
    }

    public static void remove(String name) {
        Preconditions.checkArgument((!Strings.isNullOrEmpty((String)name) ? 1 : 0) != 0);
        InternalDispatcher.dispatch("reactant-remove", () -> s_reactants.remove(name));
    }

    public static void processWrapper(ApiWrapper wrapper) {
        if (!wrapper.Enabled) {
            return;
        }
        if (wrapper.ReactorReactants.WipeExistingValuesBeforeAdding) {
            Log.LOGGER.info(WRAPPER, "Wiping all existing Reactor reactants");
            s_reactants.clear();
        } else {
            Arrays.stream(wrapper.ReactorReactants.Remove).filter(name -> !Strings.isNullOrEmpty((String)name)).forEach(ReactantsRegistry::remove);
        }
        Arrays.stream(wrapper.ReactorReactants.Add).filter(Objects::nonNull).forEach(w -> {
            if (w.IsFuel) {
                ReactantsRegistry.registerFuel(w.Name, w.RgbColour, w.FuelProperties.ModerationFactor, w.FuelProperties.AbsorptionCoefficient, w.FuelProperties.HardnessDivisor, w.TranslationKey);
            } else {
                ReactantsRegistry.register(w.Name, ReactantType.Waste, w.RgbColour, w.TranslationKey);
            }
        });
    }

    public static List<Reactant> getReactants() {
        return ObjectLists.unmodifiable((ObjectList)new ObjectArrayList(s_reactants.values()));
    }

    private ReactantsRegistry() {
    }
}

