/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.config;

import net.minecraftforge.common.ForgeConfigSpec;

public class Worldgen {
    public final ForgeConfigSpec.BooleanValue enableWorldGen;
    public final ForgeConfigSpec.BooleanValue enableWorldRegeneration;
    public final ForgeConfigSpec.IntValue userWorldGenVersion;
    public final ForgeConfigSpec.BooleanValue yelloriteOreEnableWorldGen;
    public final ForgeConfigSpec.IntValue yelloriteOreMaxClustersPerChunk;
    public final ForgeConfigSpec.IntValue yelloriteOrePerCluster;
    public final ForgeConfigSpec.IntValue yelloriteOreMaxY;
    public final ForgeConfigSpec.BooleanValue anglesiteOreEnableWorldGen;
    public final ForgeConfigSpec.IntValue anglesiteOreMaxClustersPerChunk;
    public final ForgeConfigSpec.IntValue anglesiteOrePerCluster;
    public final ForgeConfigSpec.BooleanValue benitoiteOreEnableWorldGen;
    public final ForgeConfigSpec.IntValue benitoiteOreMaxClustersPerChunk;
    public final ForgeConfigSpec.IntValue benitoiteOrePerCluster;

    Worldgen(ForgeConfigSpec.Builder builder) {
        builder.comment("Define how ores generates in the world").push("worldgen");
        this.enableWorldGen = builder.comment(new String[]{"If false, disables all world gen from Extreme Reactors;", "all other worldgen settings are automatically ignored."}).translation("config.bigreactors.worldgen.enableworldgen").worldRestart().define("enableWorldGen", true);
        this.enableWorldRegeneration = builder.comment(new String[]{"Re-run world gen in chunks that have already been generated (once they have been loaded), ", "but have not been modified by Extreme Reactors before."}).translation("config.bigreactors.worldgen.enableworldregeneration").worldRestart().define("enableWorldRegeneration", false);
        this.userWorldGenVersion = builder.comment(new String[]{"User-set world generation version.", "Increase this by one if you want Extreme Reactors to re-run world generation in already modified chunks."}).translation("config.bigreactors.worldgen.userworldgenversion").worldRestart().defineInRange("userWorldGenVersion", 1, 0, Integer.MAX_VALUE);
        this.yelloriteOreEnableWorldGen = builder.comment("Enable generation of Yellorite Ore.").translation("config.bigreactors.worldgen.yelloriteoreenableworldgen").worldRestart().define("yelloriteOreEnableWorldGen", true);
        this.yelloriteOreMaxClustersPerChunk = builder.comment("Maximum number of Yellorite Ore clusters per chunk.").translation("config.bigreactors.worldgen.yelloriteoremaxclustersperchunk").worldRestart().defineInRange("yelloriteOreMaxClustersPerChunk", 3, 1, 25);
        this.yelloriteOrePerCluster = builder.comment("Maximum number of Yellorite Ores to generate in each cluster.").translation("config.bigreactors.worldgen.yelloriteorepercluster").worldRestart().defineInRange("yelloriteOrePerCluster", 5, 1, 16);
        this.yelloriteOreMaxY = builder.comment("Maximum height (Y coordinate) in the world to generate Yellorite Ore.").translation("config.bigreactors.worldgen.yelloriteoremaxy").worldRestart().defineInRange("yelloriteOreMaxY", 32, 1, 256);
        this.anglesiteOreEnableWorldGen = builder.comment("Enable generation of Anglesite Ore.").translation("config.bigreactors.worldgen.anglesiteoreenableworldgen").worldRestart().define("anglesiteOreEnableWorldGen", true);
        this.anglesiteOreMaxClustersPerChunk = builder.comment("Maximum number of Anglesite Ore clusters per chunk.").translation("config.bigreactors.worldgen.anglesiteoremaxclustersperchunk").worldRestart().defineInRange("anglesiteOreMaxClustersPerChunk", 2, 1, 16);
        this.anglesiteOrePerCluster = builder.comment("Maximum number of Anglesite Ores to generate in each cluster.").translation("config.bigreactors.worldgen.anglesiteorepercluster").worldRestart().defineInRange("anglesiteOrePerCluster", 5, 1, 16);
        this.benitoiteOreEnableWorldGen = builder.comment("Enable generation of Benitoite Ore.").translation("config.bigreactors.worldgen.benitoiteoreenableworldgen").worldRestart().define("benitoiteOreEnableWorldGen", true);
        this.benitoiteOreMaxClustersPerChunk = builder.comment("Maximum number of Benitoite Ore clusters per chunk.").translation("config.bigreactors.worldgen.benitoiteoremaxclustersperchunk").worldRestart().defineInRange("benitoiteOreMaxClustersPerChunk", 2, 1, 16);
        this.benitoiteOrePerCluster = builder.comment("Maximum number of Benitoite Ores to generate in each cluster.").translation("config.bigreactors.worldgen.benitoiteorepercluster").worldRestart().defineInRange("benitoiteOrePerCluster", 5, 1, 16);
        builder.pop();
    }
}

