/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.datagen.recipes;

import com.google.common.collect.ImmutableSet;
import it.zerono.mods.extremereactors.ExtremeReactors;
import it.zerono.mods.extremereactors.config.conditions.ConfigCondition;
import it.zerono.mods.extremereactors.gamecontent.ContentTags;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.variant.IMultiblockGeneratorVariant;
import it.zerono.mods.zerocore.lib.datagen.provider.recipe.BaseRecipeProvider;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.ShapelessRecipeBuilder;
import net.minecraft.item.Item;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.common.util.NonNullFunction;

public abstract class AbstractRecipeGenerator
extends BaseRecipeProvider {
    protected static final String GROUP_GENERAL = "bigreactors:general";
    protected static final String GROUP_REACTOR = "bigreactors:reactor";
    protected static final String GROUP_TURBINE = "bigreactors:turbine";
    protected static final Tags.IOptionalNamedTag<Item> TAG_INGOTS_STEEL = ItemTags.createOptional((ResourceLocation)new ResourceLocation("forge", "ingots/steel"));
    protected static final Tags.IOptionalNamedTag<Item> TAG_INGOTS_URANIUM = ItemTags.createOptional((ResourceLocation)new ResourceLocation("forge", "ingots/uranium"));
    protected static final Set<ITag.INamedTag<Item>> TAGS_YELLORIUM_INGOTS = ImmutableSet.of(ContentTags.Items.INGOTS_YELLORIUM, TAG_INGOTS_URANIUM);

    protected AbstractRecipeGenerator(DataGenerator generator) {
        super(generator);
    }

    protected void blastingAndSmelting(Consumer<IFinishedRecipe> consumer, String name, Supplier<? extends IItemProvider> result, Supplier<? extends IItemProvider> source, float xp, int smeltingTime) {
        this.blasting(consumer, name, ExtremeReactors::newID, result, source, xp, smeltingTime / 2);
        this.smelting(consumer, name, ExtremeReactors::newID, result, source, xp, smeltingTime);
    }

    protected void blastingAndSmelting(Consumer<IFinishedRecipe> consumer, String name, Supplier<? extends IItemProvider> result, Supplier<? extends IItemProvider> source, float xp, int smeltingTime, ICondition ... conditions) {
        this.blasting(consumer, name, ExtremeReactors::newID, result, source, xp, smeltingTime / 2, conditions);
        this.smelting(consumer, name, ExtremeReactors::newID, result, source, xp, smeltingTime, conditions);
    }

    protected void blastingAndSmelting(Consumer<IFinishedRecipe> consumer, String name, Supplier<? extends IItemProvider> result, Supplier<? extends IItemProvider> source) {
        this.blasting(consumer, name, ExtremeReactors::newID, result, source);
        this.smelting(consumer, name, ExtremeReactors::newID, result, source);
    }

    protected void blastingAndSmelting(Consumer<IFinishedRecipe> consumer, String name, Supplier<? extends IItemProvider> result, Supplier<? extends IItemProvider> source, ICondition ... conditions) {
        this.blasting(consumer, name, ExtremeReactors::newID, result, source, conditions);
        this.smelting(consumer, name, ExtremeReactors::newID, result, source, conditions);
    }

    protected void storageBlock3x3(Consumer<IFinishedRecipe> consumer, String name, Supplier<? extends IItemProvider> component, Supplier<? extends IItemProvider> storage) {
        this.storageBlock3x3(consumer, name, ExtremeReactors::newID, GROUP_GENERAL, component, storage);
    }

    protected void nugget(Consumer<IFinishedRecipe> consumer, String name, Supplier<? extends IItemProvider> ingot, Supplier<? extends IItemProvider> nugget) {
        this.nugget(consumer, name, (NonNullFunction<String, ResourceLocation>)((NonNullFunction)ExtremeReactors::newID), GROUP_GENERAL, ingot, nugget);
    }

    protected void nugget(Consumer<IFinishedRecipe> consumer, String name, NonNullFunction<String, ResourceLocation> nameToIdConverter, String group, Supplier<? extends IItemProvider> ingot, Supplier<? extends IItemProvider> nugget) {
        ShapelessRecipeBuilder.func_200486_a((IItemProvider)ingot.get()).func_200491_b(nugget.get(), 9).func_200490_a(group).func_200483_a(name + "_has_ingot", (ICriterionInstance)AbstractRecipeGenerator.func_200403_a((IItemProvider)ingot.get())).func_200485_a(consumer, (ResourceLocation)nameToIdConverter.apply((Object)(name + "_ingot_to_nugget")));
        ShapelessRecipeBuilder.func_200488_a((IItemProvider)nugget.get(), (int)9).func_200487_b(ingot.get()).func_200490_a(group).func_200483_a("has_item", (ICriterionInstance)AbstractRecipeGenerator.func_200403_a((IItemProvider)nugget.get())).func_200485_a(consumer, (ResourceLocation)nameToIdConverter.apply((Object)("crafting/" + name + "_nugget_to_ingot")));
    }

    protected <V extends IMultiblockGeneratorVariant> void generatorChargingPort(Consumer<IFinishedRecipe> c, V variant, String name, String group, BiFunction<V, String, ResourceLocation> nameProvider, Supplier<? extends IItemProvider> result, Supplier<? extends IItemProvider> powerTap, IItemProvider item1, IItemProvider item2) {
        ShapedRecipeBuilder.func_200470_a((IItemProvider)result.get()).func_200462_a(Character.valueOf('T'), powerTap.get()).func_200469_a(Character.valueOf('G'), (ITag)Tags.Items.GLASS).func_200462_a(Character.valueOf('1'), item1).func_200462_a(Character.valueOf('2'), item2).func_200472_a("212").func_200472_a("GTG").func_200472_a("212").func_200473_b(group).func_200465_a("has_item", (ICriterionInstance)AbstractRecipeGenerator.func_200403_a((IItemProvider)powerTap.get())).func_200467_a(c, nameProvider.apply(variant, name));
    }

    protected ICondition configCondition(String configName) {
        return new ConfigCondition(configName);
    }
}

