/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.common;

import it.zerono.mods.extremereactors.gamecontent.multiblock.common.variant.IMultiblockGeneratorVariant;
import it.zerono.mods.zerocore.base.multiblock.AbstractMultiblockController;
import it.zerono.mods.zerocore.base.multiblock.part.io.IIOPortHandler;
import it.zerono.mods.zerocore.base.multiblock.part.io.fluid.IFluidPort;
import it.zerono.mods.zerocore.base.multiblock.part.io.power.IPowerPort;
import it.zerono.mods.zerocore.base.multiblock.part.io.power.IPowerPortHandler;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.data.WideAmount;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.data.stack.OperationMode;
import it.zerono.mods.zerocore.lib.energy.EnergySystem;
import it.zerono.mods.zerocore.lib.energy.IWideEnergyStorage2;
import it.zerono.mods.zerocore.lib.energy.WideEnergyBuffer;
import java.util.Collection;
import java.util.Optional;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public abstract class AbstractGeneratorMultiblockController<Controller extends AbstractGeneratorMultiblockController<Controller, V>, V extends IMultiblockGeneratorVariant>
extends AbstractMultiblockController<Controller, V>
implements IWideEnergyStorage2 {
    protected static final EnergySystem INTERNAL_ENERGY_SYSTEM = EnergySystem.ForgeEnergy;
    private final WideEnergyBuffer _energyBuffer = new WideEnergyBuffer(INTERNAL_ENERGY_SYSTEM, WideAmount.ZERO);
    private EnergySystem _outputEnergySystem = INTERNAL_ENERGY_SYSTEM;

    public AbstractGeneratorMultiblockController(World world) {
        super(world);
        this.setInteriorInvisible(false);
    }

    protected WideEnergyBuffer getEnergyBuffer() {
        return this._energyBuffer;
    }

    public EnergySystem getOutputEnergySystem() {
        return this._outputEnergySystem;
    }

    protected void setOutputEnergySystem(EnergySystem system) {
        this._outputEnergySystem = system;
    }

    public double getEnergyStoredPercentage() {
        return this.getEnergyStored(INTERNAL_ENERGY_SYSTEM).percentage(this.getCapacity(INTERNAL_ENERGY_SYSTEM));
    }

    protected static WideAmount distributeEnergyEqually(WideAmount energyAmount, Collection<? extends IPowerPort> powerTaps) {
        if (energyAmount.isZero() || powerTaps.isEmpty()) {
            return WideAmount.ZERO;
        }
        energyAmount = energyAmount.divide((long)powerTaps.size()).toImmutable();
        WideAmount amountDistributed = WideAmount.ZERO;
        for (IPowerPort iPowerPort : powerTaps) {
            IPowerPortHandler handler = iPowerPort.getPowerPortHandler();
            if (!handler.isActive() || !handler.isConnected()) continue;
            amountDistributed = amountDistributed.add(handler.outputEnergy(energyAmount));
        }
        return amountDistributed;
    }

    public abstract Optional<IFluidHandler> getLiquidHandler();

    public abstract Optional<IFluidHandler> getGasHandler();

    public abstract Optional<IFluidHandler> getFluidHandler(IoDirection var1);

    protected static int distributeFluidEqually(FluidStack availableFluid, Collection<? extends IFluidPort> coolantPorts) {
        if (availableFluid.isEmpty() || coolantPorts.isEmpty()) {
            return 0;
        }
        int fluidPerPort = availableFluid.getAmount() / coolantPorts.size();
        return coolantPorts.stream().filter(p -> p.getIoDirection().isOutput()).map(IFluidPort::getFluidPortHandler).filter(IIOPortHandler::isActive).filter(IIOPortHandler::isConnected).mapToInt(handler -> handler.outputFluid(new FluidStack(availableFluid, fluidPerPort))).sum();
    }

    protected static int acquireFluidEqually(IFluidHandler destination, int maxAmount, Collection<? extends IFluidPort> coolantPorts) {
        if (maxAmount <= 0 || coolantPorts.isEmpty()) {
            return 0;
        }
        int fluidPerPort = maxAmount / coolantPorts.size();
        return coolantPorts.stream().filter(p -> p.getIoDirection().isInput()).map(IFluidPort::getFluidPortHandler).filter(IIOPortHandler::isActive).filter(IIOPortHandler::isConnected).mapToInt(handler -> handler.inputFluid(destination, fluidPerPort)).sum();
    }

    public WideAmount insertEnergy(EnergySystem system, WideAmount maxAmount, OperationMode mode) {
        return this.getEnergyBuffer().insertEnergy(system, maxAmount, mode);
    }

    public WideAmount extractEnergy(EnergySystem system, WideAmount maxAmount, OperationMode mode) {
        return this.getEnergyBuffer().extractEnergy(system, maxAmount, mode);
    }

    public WideAmount getEnergyStored(EnergySystem system) {
        return this.getEnergyBuffer().getEnergyStored(system);
    }

    public WideAmount getCapacity(EnergySystem system) {
        return this.getEnergyBuffer().getCapacity(system);
    }

    public EnergySystem getEnergySystem() {
        return this.getEnergyBuffer().getEnergySystem();
    }

    public void syncDataFrom(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        this.syncChildDataEntityFrom((ISyncableEntity)this.getEnergyBuffer(), "buffer", data, syncReason);
        if (syncReason.isNetworkUpdate()) {
            this.setOutputEnergySystem(EnergySystem.read((CompoundNBT)data, (String)"energySystem", (EnergySystem)EnergySystem.REFERENCE));
        }
        super.syncDataFrom(data, syncReason);
    }

    public CompoundNBT syncDataTo(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        this.syncChildDataEntityTo((ISyncableEntity)this.getEnergyBuffer(), "buffer", data, syncReason);
        if (syncReason.isNetworkUpdate()) {
            EnergySystem.write((CompoundNBT)data, (String)"energySystem", (EnergySystem)this.getOutputEnergySystem());
        }
        return data;
    }
}

