/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe;

import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.fluidizer.recipe.IFluidizerRecipe;
import it.zerono.mods.zerocore.lib.data.stack.OperationMode;
import it.zerono.mods.zerocore.lib.datagen.provider.recipe.TwoToOneRecipeBuilder;
import it.zerono.mods.zerocore.lib.recipe.AbstractTwoToOneRecipe;
import it.zerono.mods.zerocore.lib.recipe.ModRecipe;
import it.zerono.mods.zerocore.lib.recipe.holder.AbstractHeldRecipe;
import it.zerono.mods.zerocore.lib.recipe.holder.IRecipeHolder;
import it.zerono.mods.zerocore.lib.recipe.ingredient.FluidStackRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredient;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredientSource;
import it.zerono.mods.zerocore.lib.recipe.result.FluidStackRecipeResult;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResult;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResultTarget;
import it.zerono.mods.zerocore.lib.recipe.serializer.TwoToOneRecipeSerializer;
import java.util.function.IntFunction;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;

public class FluidizerFluidMixingRecipe
extends AbstractTwoToOneRecipe<FluidStack, FluidStack, FluidStack, FluidStackRecipeIngredient, FluidStackRecipeIngredient, FluidStackRecipeResult>
implements IFluidizerRecipe {
    private static final String[] LABELS = new String[]{"ingredient1", "ingredient2"};
    private static final IntFunction<String> JSON_LABELS_SUPPLIER = n -> LABELS[n];
    private static long s_maxResultAmount = 0L;

    protected FluidizerFluidMixingRecipe(ResourceLocation id, FluidStackRecipeIngredient ingredient1, FluidStackRecipeIngredient ingredient2, FluidStackRecipeResult result) {
        super(id, (IRecipeIngredient)ingredient1, (IRecipeIngredient)ingredient2, (IRecipeResult)result, JSON_LABELS_SUPPLIER);
        s_maxResultAmount = Math.max(s_maxResultAmount, result.getAmount());
    }

    public static boolean lookup(ModRecipe recipe, IRecipeIngredientSource<FluidStack> source1, IRecipeIngredientSource<FluidStack> source2) {
        return recipe instanceof FluidizerFluidMixingRecipe && ((FluidizerFluidMixingRecipe)recipe).test(source1.getIngredient(), source2.getIngredient());
    }

    public static long getMaxResultAmount() {
        return s_maxResultAmount;
    }

    @Override
    public IFluidizerRecipe.Type getRecipeType() {
        return IFluidizerRecipe.Type.FluidMixing;
    }

    public boolean match(FluidStack stack) {
        return ((FluidStackRecipeIngredient)this.getIngredient1()).test((Object)stack) || ((FluidStackRecipeIngredient)this.getIngredient2()).test((Object)stack);
    }

    public boolean match(FluidStack stack1, FluidStack stack2) {
        FluidStackRecipeIngredient ingredient1 = (FluidStackRecipeIngredient)this.getIngredient1();
        FluidStackRecipeIngredient ingredient2 = (FluidStackRecipeIngredient)this.getIngredient2();
        return ingredient1.test((Object)stack1) && ingredient2.test((Object)stack2);
    }

    public boolean matchIgnoreAmount(FluidStack stack) {
        return ((FluidStackRecipeIngredient)this.getIngredient1()).testIgnoreAmount((Object)stack) || ((FluidStackRecipeIngredient)this.getIngredient2()).testIgnoreAmount((Object)stack);
    }

    public static IRecipeSerializer<FluidizerFluidMixingRecipe> serializer() {
        return new TwoToOneRecipeSerializer(FluidizerFluidMixingRecipe::new, FluidStackRecipeIngredient::from, FluidStackRecipeIngredient::from, FluidStackRecipeIngredient::from, FluidStackRecipeIngredient::from, FluidStackRecipeResult::from, FluidStackRecipeResult::from, JSON_LABELS_SUPPLIER);
    }

    public static TwoToOneRecipeBuilder<FluidStack, FluidStack, FluidStack> builder(IRecipeIngredient<FluidStack> ingredient1, IRecipeIngredient<FluidStack> ingredient2, IRecipeResult<FluidStack> result) {
        return new TwoToOneRecipeBuilder(IFluidizerRecipe.Type.FluidMixing.getRecipeId(), ingredient1, ingredient2, result, JSON_LABELS_SUPPLIER);
    }

    @Override
    public int getEnergyUsageMultiplier() {
        return this.getEnergyUsageMultiplier(((FluidStackRecipeResult)this.getResult()).getResult());
    }

    public IRecipeSerializer<FluidizerFluidMixingRecipe> func_199559_b() {
        return (IRecipeSerializer)Content.Recipes.FLUIDIZER_FLUIDMIXING_RECIPE_SERIALIZER.get();
    }

    public IRecipeType<?> func_222127_g() {
        return Content.Recipes.FLUIDIZER_RECIPE_TYPE;
    }

    public static class HeldRecipe
    extends AbstractHeldRecipe<FluidizerFluidMixingRecipe>
    implements IFluidizerRecipe.Held<FluidizerFluidMixingRecipe> {
        private final IRecipeIngredientSource<FluidStack> _fluid1Source;
        private final IRecipeIngredientSource<FluidStack> _fluid2Source;
        private final IRecipeResultTarget<FluidStackRecipeResult> _outputTarget;

        public <Holder extends IRecipeHolder<FluidizerFluidMixingRecipe>> HeldRecipe(FluidizerFluidMixingRecipe recipe, Holder holder, IRecipeIngredientSource<FluidStack> fluid1Source, IRecipeIngredientSource<FluidStack> fluid2Source, IRecipeResultTarget<FluidStackRecipeResult> outputTarget) {
            super((ModRecipe)recipe, holder);
            this._fluid1Source = fluid1Source;
            this._fluid2Source = fluid2Source;
            this._outputTarget = outputTarget;
        }

        public void onRecipeProcessed() {
            FluidizerFluidMixingRecipe recipe = (FluidizerFluidMixingRecipe)this.getRecipe();
            FluidStack fluid1 = (FluidStack)this._fluid1Source.getMatchFrom(recipe.getIngredient1());
            FluidStack fluid2 = (FluidStack)this._fluid2Source.getMatchFrom(recipe.getIngredient2());
            if (!fluid1.isEmpty() && !fluid2.isEmpty()) {
                this._fluid1Source.consumeIngredient((Object)fluid1);
                this._fluid2Source.consumeIngredient((Object)fluid2);
                this._outputTarget.setResult(recipe.getResult(), OperationMode.Execute);
            }
        }
    }
}

