/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part;

import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.common.part.fluidport.FluidPortType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.MultiblockReactor;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.ReactorPartType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.part.AbstractReactorEntity;
import it.zerono.mods.zerocore.base.multiblock.part.io.fluid.IFluidPort;
import it.zerono.mods.zerocore.base.multiblock.part.io.fluid.IFluidPortHandler;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.block.INeighborChangeListener;
import it.zerono.mods.zerocore.lib.block.TileCommandDispatcher;
import it.zerono.mods.zerocore.lib.data.IoDirection;
import it.zerono.mods.zerocore.lib.data.IoMode;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModTileContainer;
import it.zerono.mods.zerocore.lib.multiblock.IMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;

public class ReactorFluidPortEntity
extends AbstractReactorEntity
implements IFluidPort,
INeighborChangeListener,
INamedContainerProvider {
    private final IFluidPortHandler _handler;
    private IoDirection _direction;

    public ReactorFluidPortEntity(FluidPortType type, IoMode mode, TileEntityType<?> entityType) {
        super(entityType);
        this._handler = FluidPortType.create(type, mode, this);
        this.setIoDirection(IoDirection.Input);
        this.setCommandDispatcher(TileCommandDispatcher.builder().addServerHandler(CommonConstants.COMMAND_SET_INPUT, tile -> tile.setIoDirection(IoDirection.Input)).addServerHandler(CommonConstants.COMMAND_SET_OUTPUT, tile -> tile.setIoDirection(IoDirection.Output)).build((AbstractModBlockEntity)this));
    }

    public IFluidPortHandler getFluidPortHandler() {
        return this._handler;
    }

    public void onNeighborBlockChanged(BlockState state, BlockPos neighborPosition, boolean isMoving) {
        if (this.isConnected()) {
            this.getFluidPortHandler().checkConnections(this.func_145831_w(), this.getWorldPosition());
        }
        this.requestClientRenderUpdate();
    }

    public void onNeighborTileChanged(BlockState state, BlockPos neighborPosition) {
        if (this.isConnected()) {
            this.getFluidPortHandler().checkConnections(this.func_145831_w(), this.getWorldPosition());
        }
        this.requestClientRenderUpdate();
    }

    public IoDirection getIoDirection() {
        return this._direction;
    }

    public void setIoDirection(IoDirection direction) {
        if (this.getIoDirection() == direction) {
            return;
        }
        this._direction = direction;
        this.getFluidPortHandler().update(this::getUpdatedHandler);
        this.executeOnController(MultiblockReactor::onFluidPortChanged);
        this.notifyBlockUpdate();
        this.callOnLogicalSide(() -> {
            this.notifyOutwardNeighborsOfStateChange();
            this.func_70296_d();
        }, () -> ((ReactorFluidPortEntity)this).markForRenderUpdate());
    }

    public void syncDataFrom(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        this.setIoDirection(IoDirection.read((CompoundNBT)data, (String)"iodir", (IoDirection)IoDirection.Input));
    }

    public CompoundNBT syncDataTo(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        IoDirection.write((CompoundNBT)data, (String)"iodir", (IoDirection)this.getIoDirection());
        return data;
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity player) {
        return ModTileContainer.empty((ContainerType)((ContainerType)Content.ContainerTypes.REACTOR_FLUIDPORT.get()), (int)windowId, (AbstractModBlockEntity)this);
    }

    public ITextComponent func_145748_c_() {
        return super.getPartDisplayName();
    }

    @Override
    protected int getUpdatedModelVariantIndex() {
        int connectedOffset = this.isMachineAssembled() && this.getFluidPortHandler().isConnected() ? 1 : 0;
        return this.getIoDirection().isInput() ? connectedOffset : 2 + connectedOffset;
    }

    public boolean canOpenGui(World world, BlockPos position, BlockState state) {
        ReactorPartType partType = (ReactorPartType)this.getPartTypeOrDefault(ReactorPartType.Casing);
        return (ReactorPartType.ActiveFluidPortForge == partType || ReactorPartType.PassiveFluidPortForge == partType) && this.isMachineAssembled();
    }

    public void onPostMachineAssembled(MultiblockReactor controller) {
        super.onPostMachineAssembled((AbstractCuboidMultiblockController)controller);
        this.getFluidPortHandler().update(this::getUpdatedHandler);
        this.notifyOutwardNeighborsOfStateChange();
    }

    public void onPostMachineBroken() {
        super.onPostMachineBroken();
        this.getFluidPortHandler().update(this::getUpdatedHandler);
        this.notifyOutwardNeighborsOfStateChange();
    }

    public void onAttached(MultiblockReactor newController) {
        super.onAttached((IMultiblockController)newController);
        this.getFluidPortHandler().update(this::getUpdatedHandler);
    }

    public void onAssimilated(MultiblockReactor newController) {
        super.onAssimilated((IMultiblockController)newController);
        this.getFluidPortHandler().update(this::getUpdatedHandler);
    }

    public void onDetached(MultiblockReactor oldController) {
        super.onDetached((IMultiblockController)oldController);
        this.getFluidPortHandler().update(this::getUpdatedHandler);
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction side) {
        LazyOptional cap = this.getFluidPortHandler().getCapability(capability, side);
        return null != cap ? cap : super.getCapability(capability, side);
    }

    public void func_145843_s() {
        super.func_145843_s();
        this.getFluidPortHandler().invalidate();
    }

    private IFluidHandler getUpdatedHandler(IoDirection direction) {
        return (IFluidHandler)this.getMultiblockController().flatMap(c -> c.getFluidHandler(direction)).orElse(EmptyFluidHandler.INSTANCE);
    }
}

