/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.recipe;

import it.zerono.mods.extremereactors.gamecontent.multiblock.reprocessor.recipe.ReprocessorRecipe;
import it.zerono.mods.zerocore.lib.data.stack.OperationMode;
import it.zerono.mods.zerocore.lib.recipe.ModRecipe;
import it.zerono.mods.zerocore.lib.recipe.holder.AbstractHeldRecipe;
import it.zerono.mods.zerocore.lib.recipe.holder.IRecipeHolder;
import it.zerono.mods.zerocore.lib.recipe.ingredient.IRecipeIngredientSource;
import it.zerono.mods.zerocore.lib.recipe.result.IRecipeResultTarget;
import it.zerono.mods.zerocore.lib.recipe.result.ItemStackRecipeResult;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;

public class ReprocessorHeldRecipe
extends AbstractHeldRecipe<ReprocessorRecipe> {
    private final IRecipeIngredientSource<ItemStack> _wasteIngredientSource;
    private final IRecipeIngredientSource<FluidStack> _fluidIngredientSource;
    private final IRecipeResultTarget<ItemStackRecipeResult> _outputTarget;

    public <Holder extends IRecipeHolder<ReprocessorRecipe>> ReprocessorHeldRecipe(ReprocessorRecipe recipe, Holder holder, IRecipeIngredientSource<ItemStack> wasteSource, IRecipeIngredientSource<FluidStack> fluidSource, IRecipeResultTarget<ItemStackRecipeResult> outputTarget) {
        super((ModRecipe)recipe, holder);
        this._outputTarget = outputTarget;
        this._wasteIngredientSource = wasteSource;
        this._fluidIngredientSource = fluidSource;
    }

    public void onRecipeProcessed() {
        ReprocessorRecipe recipe = (ReprocessorRecipe)this.getRecipe();
        ItemStack waste = (ItemStack)this._wasteIngredientSource.getMatchFrom(recipe.getIngredient1());
        FluidStack fluid = (FluidStack)this._fluidIngredientSource.getMatchFrom(recipe.getIngredient2());
        if (!waste.func_190926_b() && !fluid.isEmpty()) {
            this._wasteIngredientSource.consumeIngredient((Object)waste);
            this._fluidIngredientSource.consumeIngredient((Object)fluid);
            this._outputTarget.setResult(recipe.getResult(), OperationMode.Execute);
        }
    }
}

