/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part;

import it.zerono.mods.extremereactors.gamecontent.multiblock.reactor.variant.ReactorVariant;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.MultiblockTurbine;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.TurbinePartType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.variant.IMultiblockTurbineVariant;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.variant.TurbineVariant;
import it.zerono.mods.zerocore.base.multiblock.part.AbstractMultiblockEntity;
import it.zerono.mods.zerocore.lib.CodeHelper;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockPartType2;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockPartTypeProvider;
import it.zerono.mods.zerocore.lib.block.multiblock.IMultiblockVariantProvider;
import it.zerono.mods.zerocore.lib.client.model.data.multiblock.CuboidPartVariantsModelData;
import it.zerono.mods.zerocore.lib.client.model.data.multiblock.CuboidPartVariantsModelDataCache;
import it.zerono.mods.zerocore.lib.multiblock.AbstractMultiblockController;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.PartPosition;
import it.zerono.mods.zerocore.lib.multiblock.validation.IMultiblockValidator;
import it.zerono.mods.zerocore.lib.multiblock.variant.IMultiblockVariant;
import java.util.Optional;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.client.model.data.EmptyModelData;
import net.minecraftforge.client.model.data.IModelData;

public class AbstractTurbineEntity
extends AbstractMultiblockEntity<MultiblockTurbine>
implements IMultiblockPartTypeProvider<MultiblockTurbine, TurbinePartType>,
IMultiblockVariantProvider<IMultiblockTurbineVariant> {
    private static CuboidPartVariantsModelDataCache[] s_modelDataCaches;

    public AbstractTurbineEntity(TileEntityType<?> type) {
        super(type);
    }

    protected boolean isTurbineActive() {
        return this.getMultiblockController().filter(AbstractMultiblockController::isAssembled).map(MultiblockTurbine::isMachineActive).orElse(false);
    }

    protected void setTurbineActive(boolean active) {
        this.getMultiblockController().filter(AbstractMultiblockController::isAssembled).ifPresent(c -> c.setMachineActive(active));
    }

    public ITextComponent getPartDisplayName() {
        return new TranslationTextComponent("gui.bigreactors.multiblock_variant_part_format.title", new Object[]{new TranslationTextComponent(this.getMultiblockVariant().map(IMultiblockVariant::getTranslationKey).orElse("unknown")), new TranslationTextComponent(this.getPartType().map(IMultiblockPartType2::getTranslationKey).orElse("unknown"))});
    }

    protected IModelData getUpdatedModelData() {
        return (IModelData)CodeHelper.optionalMap((Optional)this.getMultiblockVariant(), (Optional)this.getPartType(), this::getUpdatedModelData).orElse(EmptyModelData.INSTANCE);
    }

    protected int getUpdatedModelVariantIndex() {
        return 0;
    }

    public boolean isGoodForPosition(PartPosition position, IMultiblockValidator validatorCallback) {
        BlockPos coordinates = this.getWorldPosition();
        if (position.isFrame()) {
            validatorCallback.setLastError(coordinates, "multiblock.validation.reactor.invalid_frame_block", new Object[0]);
            return false;
        }
        if (PartPosition.Interior == position) {
            validatorCallback.setLastError(coordinates, "multiblock.validation.reactor.invalid_part_for_interior", new Object[0]);
            return false;
        }
        return true;
    }

    public MultiblockTurbine createController() {
        World myWorld = this.func_145831_w();
        if (null == myWorld) {
            throw new RuntimeException("Trying to create a Controller from a Part without a World");
        }
        return new MultiblockTurbine(this.func_145831_w(), this.getMultiblockVariant().orElse(TurbineVariant.Basic));
    }

    public Class<MultiblockTurbine> getControllerType() {
        return MultiblockTurbine.class;
    }

    public void onMachineActivated() {
    }

    public void onMachineDeactivated() {
    }

    protected IModelData getUpdatedModelData(IMultiblockTurbineVariant variant, TurbinePartType partType) {
        return AbstractTurbineEntity.getVariantModelDataCache(variant).computeIfAbsent(partType.ordinal(), this.getUpdatedModelVariantIndex(), this.getOutwardFacings(), () -> new CuboidPartVariantsModelData(partType.ordinal(), this.getUpdatedModelVariantIndex(), this.getOutwardFacings()));
    }

    private static CuboidPartVariantsModelDataCache getVariantModelDataCache(IMultiblockTurbineVariant variant) {
        if (null == s_modelDataCaches) {
            s_modelDataCaches = new CuboidPartVariantsModelDataCache[ReactorVariant.values().length];
        }
        if (null == s_modelDataCaches[variant.getId()]) {
            AbstractTurbineEntity.s_modelDataCaches[variant.getId()] = new CuboidPartVariantsModelDataCache();
        }
        return s_modelDataCaches[variant.getId()];
    }
}

