/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part;

import it.zerono.mods.extremereactors.config.Config;
import it.zerono.mods.extremereactors.gamecontent.CommonConstants;
import it.zerono.mods.extremereactors.gamecontent.Content;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.ITurbineWriter;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.MultiblockTurbine;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.AbstractTurbineEntity;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.sensor.TurbineSensorSetting;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.sensor.TurbineSensorType;
import it.zerono.mods.zerocore.lib.block.AbstractModBlockEntity;
import it.zerono.mods.zerocore.lib.block.INeighborChangeListener;
import it.zerono.mods.zerocore.lib.block.TileCommandDispatcher;
import it.zerono.mods.zerocore.lib.data.nbt.ISyncableEntity;
import it.zerono.mods.zerocore.lib.item.inventory.container.ModTileContainer;
import it.zerono.mods.zerocore.lib.multiblock.ITickableMultiblockPart;
import it.zerono.mods.zerocore.lib.multiblock.cuboid.AbstractCuboidMultiblockController;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;

public class TurbineRedstonePortEntity
extends AbstractTurbineEntity
implements INeighborChangeListener,
ITickableMultiblockPart,
INamedContainerProvider {
    private TurbineSensorSetting _setting = TurbineSensorSetting.DISABLED;
    private int _ticksSinceLastUpdate = 0;
    private boolean _isLit = false;
    private boolean _isExternallyPowered = false;
    private int _externalPowerLevel = 0;

    public TurbineRedstonePortEntity() {
        super((TileEntityType)Content.TileEntityTypes.TURBINE_REDSTONEPORT.get());
        this.setCommandDispatcher(TileCommandDispatcher.builder().addServerHandler(CommonConstants.COMMAND_SET_REDSTONE_SENSOR, TurbineRedstonePortEntity::setNewSensorFromGUI).addServerHandler(CommonConstants.COMMAND_DISABLE_REDSTONE_SENSOR, TurbineRedstonePortEntity::disableSensorFromGUI).build((AbstractModBlockEntity)this));
    }

    public TurbineSensorSetting getSettings() {
        return this._setting;
    }

    public int getOutputSignalPower() {
        return ((TurbineSensorType)this.getSettings().Sensor).isOutput() && this.isRedstoneActive() ? 15 : 0;
    }

    public boolean isLit() {
        return this._isLit;
    }

    public void onNeighborBlockChanged(BlockState state, BlockPos neighborPosition, boolean isMoving) {
        if (!this.isConnected()) {
            return;
        }
        if (((TurbineSensorType)this.getSettings().Sensor).isInput()) {
            this.getOutwardDirection().map(direction -> this.getRedstonePowerLevelFrom(this.getWorldPosition().func_177972_a(direction), (Direction)direction)).ifPresent(powerLevel -> {
                boolean nowPowered;
                boolean bl = nowPowered = powerLevel > 0;
                if (this._isExternallyPowered != nowPowered || this._externalPowerLevel != powerLevel) {
                    this._isExternallyPowered = nowPowered;
                    this._externalPowerLevel = powerLevel;
                    this.onRedstoneInputUpdated();
                    this.func_70296_d();
                    this.updateRedstoneStateAndNotify();
                }
            });
        } else {
            this._isExternallyPowered = false;
            this._externalPowerLevel = 0;
        }
    }

    public void onMultiblockServerTick() {
        if (!this.isConnected() || this._ticksSinceLastUpdate++ < (Integer)Config.COMMON.general.ticksPerRedstoneUpdate.get()) {
            return;
        }
        this.updateRedstoneStateAndNotify();
        this._ticksSinceLastUpdate = 0;
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity player) {
        return ModTileContainer.empty((ContainerType)((ContainerType)Content.ContainerTypes.TURBINE_REDSTONEPORT.get()), (int)windowId, (AbstractModBlockEntity)this, (ServerPlayerEntity)((ServerPlayerEntity)player));
    }

    public ITextComponent func_145748_c_() {
        return super.getPartDisplayName();
    }

    public void syncDataFrom(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataFrom(data, syncReason);
        if (data.func_74764_b("setting")) {
            this._setting = TurbineSensorSetting.syncDataFrom(data.func_74775_l("setting"));
        }
        if (data.func_74764_b("lit")) {
            this._isLit = data.func_74767_n("lit");
        }
        if (syncReason.isFullSync()) {
            this.updateRedstoneStateAndNotify();
        } else {
            this.markForRenderUpdate();
        }
    }

    public CompoundNBT syncDataTo(CompoundNBT data, ISyncableEntity.SyncReason syncReason) {
        super.syncDataTo(data, syncReason);
        data.func_218657_a("setting", (INBT)this.getSettings().syncDataTo(new CompoundNBT()));
        data.func_74757_a("lit", this._isLit);
        return data;
    }

    @Override
    protected int getUpdatedModelVariantIndex() {
        return this._isLit ? 1 : 0;
    }

    public void onPostMachineAssembled(MultiblockTurbine controller) {
        super.onPostMachineAssembled((AbstractCuboidMultiblockController)controller);
        this.callOnLogicalServer(this::updateRedstoneStateAndNotify);
    }

    public void onPostMachineBroken() {
        super.onPostMachineBroken();
        this.callOnLogicalServer(this::updateRedstoneStateAndNotify);
    }

    @Override
    public void onMachineActivated() {
        super.onMachineActivated();
        this.callOnLogicalServer(this::updateRedstoneStateAndNotify);
    }

    @Override
    public void onMachineDeactivated() {
        super.onMachineDeactivated();
        this.callOnLogicalServer(this::updateRedstoneStateAndNotify);
    }

    public boolean canOpenGui(World world, BlockPos position, BlockState state) {
        return this.isMachineAssembled();
    }

    protected boolean isRedstoneActive() {
        TurbineSensorSetting settings = this.getSettings();
        return ((TurbineSensorType)settings.Sensor).isOutput() ? this.getMultiblockController().map(settings::test).orElse(false) : this._isExternallyPowered && this.isConnected();
    }

    private void onRedstoneInputUpdated() {
        this.getMultiblockController().ifPresent(c -> this.getSettings().inputAction((ITurbineWriter)c, (Boolean)this._isExternallyPowered, this._externalPowerLevel));
    }

    private void updateRedstoneStateAndNotify() {
        this.callOnLogicalServer(world -> {
            boolean oldLitState = this._isLit;
            if (oldLitState != this.updateLitState()) {
                world.func_195593_d(this.getWorldPosition(), this.getBlockType());
            }
            this.notifyTileEntityUpdate();
        });
    }

    private void setNewSensorFromGUI(CompoundNBT data) {
        this._setting = TurbineSensorSetting.syncDataFrom(data);
        this.getOutwardDirection().ifPresent(outward -> {
            BlockPos position = this.getWorldPosition();
            if (((TurbineSensorType)this._setting.Sensor).isInput()) {
                this._externalPowerLevel = this.getRedstonePowerLevelFrom(position.func_177972_a(outward), (Direction)outward);
                boolean bl = this._isExternallyPowered = this._externalPowerLevel > 0;
                if (!this._setting.Behavior.onPulse()) {
                    this.onRedstoneInputUpdated();
                }
            } else {
                this._isExternallyPowered = false;
                this._externalPowerLevel = 0;
            }
        });
        this.updateRedstoneStateAndNotify();
    }

    private void disableSensorFromGUI() {
        this._setting = TurbineSensorSetting.DISABLED;
        this.updateRedstoneStateAndNotify();
    }

    private boolean isReceivingRedstonePowerFrom(BlockPos position, Direction direction) {
        return (Boolean)this.mapPartWorld(w -> w.func_175687_A(position) > 0 || w.func_175651_c(position, direction) > 0, false);
    }

    private int getRedstonePowerLevelFrom(BlockPos position, Direction direction) {
        return (Integer)this.mapPartWorld(w -> MathHelper.func_76125_a((int)w.func_175651_c(position, direction), (int)0, (int)15), 0);
    }

    protected boolean updateLitState() {
        this._isLit = ((TurbineSensorType)this.getSettings().Sensor).isOutput() && this.isRedstoneActive() || this._isExternallyPowered;
        return this._isLit;
    }
}

