/*
 * Decompiled with CFR 0.152.
 */
package it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part;

import it.zerono.mods.extremereactors.config.Config;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.MultiblockTurbine;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.TurbinePartType;
import it.zerono.mods.extremereactors.gamecontent.multiblock.turbine.part.TurbineRotorBearingEntity;
import it.zerono.mods.zerocore.base.multiblock.part.GenericDeviceBlock;
import it.zerono.mods.zerocore.lib.block.multiblock.MultiblockPartBlock;
import it.zerono.mods.zerocore.lib.world.WorldHelper;
import java.util.Optional;
import java.util.Random;
import net.minecraft.block.BlockState;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class TurbineRotorBearingBlock
extends GenericDeviceBlock<MultiblockTurbine, TurbinePartType> {
    public TurbineRotorBearingBlock(MultiblockPartBlock.MultiblockPartProperties<TurbinePartType> properties) {
        super(properties);
    }

    public boolean func_200122_a(BlockState state, BlockState adjacentBlockState, Direction side) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos position, Random random) {
        if (((Boolean)Config.CLIENT.disableTurbineParticles.get()).booleanValue()) {
            return;
        }
        TurbineRotorBearingBlock.getTile((IBlockReader)world, position).ifPresent(bearing -> this.animateTick((TurbineRotorBearingEntity)((Object)bearing), world, position, random));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void animateTick(TurbineRotorBearingEntity bearing, World world, BlockPos pos, Random random) {
        bearing.getMultiblockController().filter(turbine -> !turbine.isInteriorInvisible()).filter(MultiblockTurbine::isAssembledAndActive).ifPresent(turbine -> turbine.forBoundingBoxCoordinates((min, max) -> {
            int numParticles = Math.min(20, Math.max(1, turbine.getFluidConsumedLastTick() / 40));
            BlockPos minCoord = min.func_177982_a(1, 1, 1);
            BlockPos maxCoord = max.func_177982_a(-1, -1, -1);
            Direction inwardsDir = bearing.getOutwardDirection().map(Direction::func_176734_d).orElse(Direction.UP);
            int offsetX = inwardsDir.func_82601_c();
            int offsetY = inwardsDir.func_96559_d();
            int offsetZ = inwardsDir.func_82599_e();
            BasicParticleType particle = ParticleTypes.field_197613_f;
            int minX = minCoord.func_177958_n();
            int minY = minCoord.func_177956_o();
            int minZ = minCoord.func_177952_p();
            int maxX = maxCoord.func_177958_n();
            int maxY = maxCoord.func_177956_o();
            int maxZ = maxCoord.func_177952_p();
            if (offsetX != 0) {
                minX = maxX = pos.func_177958_n() + offsetX;
            } else if (offsetY != 0) {
                minY = maxY = pos.func_177956_o() + offsetY;
            } else {
                minZ = maxZ = pos.func_177952_p() + offsetZ;
            }
            for (int i = 0; i < numParticles; ++i) {
                int particleX = minX + (int)(random.nextFloat() * (float)(maxX - minX + 1));
                int particleY = minY + (int)(random.nextFloat() * (float)(maxY - minY + 1));
                int particleZ = minZ + (int)(random.nextFloat() * (float)(maxZ - minZ + 1));
                WorldHelper.spawnVanillaParticles((World)world, (IParticleData)particle, (int)1, (int)numParticles, (int)particleX, (int)particleY, (int)particleZ, (int)0, (int)0, (int)0);
            }
        }));
    }

    private static Optional<TurbineRotorBearingEntity> getTile(IBlockReader world, BlockPos position) {
        return WorldHelper.getTile((IBlockReader)world, (BlockPos)position).filter(te -> te instanceof TurbineRotorBearingEntity).map(te -> (TurbineRotorBearingEntity)((Object)te));
    }
}

