/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.commands.client;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import de.keksuccino.fancymenu.commands.client.ClientExecutor;
import de.keksuccino.fancymenu.commands.client.CommandUtils;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.fancy.guicreator.CustomGuiLoader;
import de.keksuccino.fancymenu.menu.guiconstruction.GuiConstructor;
import de.keksuccino.konkrete.localization.Locals;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.CreateWorldScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class OpenGuiScreenCommand {
    public static void register(CommandDispatcher<CommandSource> d) {
        d.register((LiteralArgumentBuilder)Commands.func_197057_a((String)"openguiscreen").then((ArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"menu_identifier", (ArgumentType)StringArgumentType.string()).executes(stack -> OpenGuiScreenCommand.openGui((CommandSource)stack.getSource(), StringArgumentType.getString((CommandContext)stack, (String)"menu_identifier")))).suggests((context, provider) -> CommandUtils.getStringSuggestions(provider, "<menu_identifier>"))));
    }

    private static int openGui(CommandSource stack, String menuIdentifierOrCustomGuiName) {
        try {
            if (menuIdentifierOrCustomGuiName.equalsIgnoreCase(CreateWorldScreen.class.getName())) {
                Minecraft.func_71410_x().func_147108_a((Screen)CreateWorldScreen.func_243425_a((Screen)Minecraft.func_71410_x().field_71462_r));
                return 1;
            }
            if (CustomGuiLoader.guiExists(menuIdentifierOrCustomGuiName)) {
                ClientExecutor.execute(() -> Minecraft.func_71410_x().func_147108_a((Screen)CustomGuiLoader.getGui(menuIdentifierOrCustomGuiName, Minecraft.func_71410_x().field_71462_r, null)));
            } else {
                Screen s = GuiConstructor.tryToConstruct(MenuCustomization.getValidMenuIdentifierFor(menuIdentifierOrCustomGuiName));
                if (s != null) {
                    ClientExecutor.execute(() -> Minecraft.func_71410_x().func_147108_a(s));
                } else {
                    stack.func_197021_a((ITextComponent)new StringTextComponent(Locals.localize((String)"fancymenu.commands.openguiscreen.cannotopen", (String[])new String[0])));
                }
            }
        }
        catch (Exception e) {
            stack.func_197021_a((ITextComponent)new StringTextComponent(Locals.localize((String)"fancymenu.commands.openguiscreen.error", (String[])new String[0])));
            e.printStackTrace();
        }
        return 1;
    }
}

