/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.button;

import de.keksuccino.fancymenu.menu.button.ButtonCache;
import de.keksuccino.fancymenu.menu.button.ButtonData;
import de.keksuccino.fancymenu.menu.button.identification.ButtonIdentificator;
import de.keksuccino.fancymenu.menu.fancy.MenuCustomization;
import de.keksuccino.fancymenu.menu.guiconstruction.GuiConstructor;
import de.keksuccino.konkrete.math.MathUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ButtonMimeHandler {
    private static Logger LOGGER = LogManager.getLogger((String)"fancymenu/ButtonMimeHandler");
    protected static Map<String, ButtonPackage> cachedButtons = new HashMap<String, ButtonPackage>();

    public static boolean tryCache(String menuIdentifier, boolean overrideCache) {
        if (!cachedButtons.containsKey(menuIdentifier) || overrideCache) {
            try {
                ButtonPackage p;
                Screen s = GuiConstructor.tryToConstruct(menuIdentifier);
                if (s != null && (p = new ButtonPackage()).init(s)) {
                    cachedButtons.put(menuIdentifier, p);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (cachedButtons.containsKey(menuIdentifier)) {
            return true;
        }
        LOGGER.warn("tryCache: Failed to cache buttons of screen!");
        return false;
    }

    public static boolean cacheFromInstance(Screen screen, boolean overrideCache) {
        String menuIdentifier = screen.getClass().getName();
        if (!cachedButtons.containsKey(menuIdentifier) || overrideCache) {
            try {
                ButtonPackage p = new ButtonPackage();
                if (p.init(screen)) {
                    cachedButtons.put(menuIdentifier, p);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (cachedButtons.containsKey(menuIdentifier)) {
            return true;
        }
        LOGGER.warn("cacheFromInstance: Failed to cache buttons of screen!");
        return false;
    }

    public static ButtonData getButton(String buttonLocator) {
        if (buttonLocator.contains(":")) {
            String menuIdentifier = buttonLocator.split("[:]", 2)[0];
            menuIdentifier = MenuCustomization.getValidMenuIdentifierFor(menuIdentifier);
            String buttonId = buttonLocator.split("[:]", 2)[1];
            if (MathUtils.isLong((String)buttonId) || buttonId.startsWith("button_compatibility_id:")) {
                Screen current = Minecraft.func_71410_x().field_71462_r;
                if (current != null && menuIdentifier.equals(current.getClass().getName())) {
                    if (cachedButtons.containsKey(menuIdentifier)) {
                        ButtonPackage pack = cachedButtons.get(menuIdentifier);
                        ButtonData d = pack.getButton(buttonId);
                        if (d != null && d.getScreen() != current) {
                            ButtonMimeHandler.cacheFromInstance(current, true);
                            Minecraft.func_71410_x().func_147108_a(current);
                        }
                    } else {
                        ButtonMimeHandler.cacheFromInstance(current, true);
                        Minecraft.func_71410_x().func_147108_a(current);
                    }
                } else if (!cachedButtons.containsKey(menuIdentifier)) {
                    ButtonMimeHandler.tryCache(menuIdentifier, false);
                }
                ButtonPackage p = cachedButtons.get(menuIdentifier);
                if (p != null) {
                    return p.getButton(buttonId);
                }
            }
        }
        return null;
    }

    public static boolean executeButtonAction(String buttonLocator) {
        try {
            Widget b;
            ButtonData d = ButtonMimeHandler.getButton(buttonLocator);
            if (d != null && (b = d.getButton()) != null) {
                b.func_230982_a_((double)(b.field_230690_l_ + 1), (double)(b.field_230691_m_ + 1));
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        LOGGER.warn("Failed to execute button click action!");
        return false;
    }

    public static void clearCache() {
        cachedButtons.clear();
    }

    public static class ButtonPackage {
        protected Map<Long, ButtonData> buttons = new HashMap<Long, ButtonData>();

        public boolean init(Screen screenToGetButtonsFrom) {
            if (screenToGetButtonsFrom != null) {
                ArrayList<String> compIds = new ArrayList<String>();
                for (ButtonData d : ButtonCache.cacheButtons(screenToGetButtonsFrom, 1000, 1000)) {
                    ButtonIdentificator.setCompatibilityIdentifierToData(d);
                    if (compIds.contains(d.compatibilityId)) {
                        d.compatibilityId = null;
                    } else {
                        compIds.add(d.compatibilityId);
                    }
                    this.buttons.put(d.getId(), d);
                }
                return true;
            }
            LOGGER.error("Failed to set up ButtonPackage instance! Screen is null!");
            return false;
        }

        public Map<Long, ButtonData> getButtons() {
            return this.buttons;
        }

        public ButtonData getButton(String id) {
            if (MathUtils.isLong((String)id)) {
                return this.buttons.get(Long.parseLong(id));
            }
            if (id.startsWith("button_compatibility_id:")) {
                for (ButtonData d : this.buttons.values()) {
                    if (d.getCompatibilityId() == null || !d.getCompatibilityId().equals(id)) continue;
                    return d;
                }
            }
            return null;
        }
    }
}

