/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.guicreator;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.menu.fancy.guicreator.CustomGuiBase;
import de.keksuccino.konkrete.file.FileUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.gui.screen.Screen;

public class CustomGuiLoader {
    private static Map<String, PropertiesSection> screens = new HashMap<String, PropertiesSection>();

    public static void loadCustomGuis() {
        screens.clear();
        for (String s : FileUtils.getFiles((String)FancyMenu.getCustomGuiPath().getPath())) {
            File f = new File(s);
            String identifier = null;
            String title = null;
            boolean allowesc = false;
            for (String s2 : FileUtils.getFileLines((File)f)) {
                if (!s2.contains("=")) continue;
                String variable = s2.replace(" ", "").split("[=]", 2)[0].toLowerCase();
                String value = "";
                String rawvalue = s2.split("[=]", 2)[1];
                for (int i = 0; i < rawvalue.length(); ++i) {
                    if (rawvalue.charAt(i) == " ".charAt(0)) continue;
                    value = rawvalue.substring(i);
                    break;
                }
                if (variable.equals("identifier")) {
                    identifier = value;
                }
                if (variable.equals("title")) {
                    title = value;
                }
                if (!variable.equals("allowesc") || !value.equalsIgnoreCase("true")) continue;
                allowesc = true;
            }
            if (identifier == null) continue;
            PropertiesSection sec = new PropertiesSection("customgui");
            sec.addEntry("identifier", identifier);
            sec.addEntry("title", title);
            sec.addEntry("allowesc", "" + allowesc);
            screens.put(identifier, sec);
        }
    }

    public static boolean guiExists(String identifier) {
        return screens.containsKey(identifier);
    }

    public static CustomGuiBase getGui(String identifier, Screen parent, Screen overrides) {
        if (CustomGuiLoader.guiExists(identifier)) {
            PropertiesSection sec = screens.get(identifier);
            boolean esc = true;
            if (sec.getEntryValue("allowesc").equalsIgnoreCase("false")) {
                esc = false;
            }
            return new CustomGuiBase(sec.getEntryValue("title"), identifier, esc, parent, overrides);
        }
        return null;
    }

    public static CustomGuiBase getGui(String identifier, Screen parent, Screen overrides, final Consumer<CustomGuiBase> onClose) {
        if (CustomGuiLoader.guiExists(identifier)) {
            PropertiesSection sec = screens.get(identifier);
            boolean esc = true;
            if (sec.getEntryValue("allowesc").equalsIgnoreCase("false")) {
                esc = false;
            }
            return new CustomGuiBase(sec.getEntryValue("title"), identifier, esc, parent, overrides){

                public void func_231164_f_() {
                    onClose.accept(this);
                }
            };
        }
        return null;
    }

    public static List<String> getCustomGuis() {
        ArrayList<String> l = new ArrayList<String>();
        l.addAll(screens.keySet());
        return l;
    }
}

