/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollarea.entry;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollarea.ScrollArea;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollarea.entry.ScrollAreaEntry;
import java.awt.Color;
import java.util.function.Consumer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;

public class TextListScrollAreaEntry
extends ScrollAreaEntry {
    public Color listDotColor;
    protected ITextComponent text;
    protected int textWidth;
    public FontRenderer font;
    protected Consumer<TextListScrollAreaEntry> onClickCallback;

    public TextListScrollAreaEntry(ScrollArea parent, ITextComponent text, Color listDotColor, Consumer<TextListScrollAreaEntry> onClick) {
        super(parent, 0, 16);
        this.font = Minecraft.func_71410_x().field_71466_p;
        this.listDotColor = listDotColor;
        this.onClickCallback = onClick;
        this.setText(text);
    }

    @Override
    public void render(MatrixStack matrix, int mouseX, int mouseY, float partial) {
        super.render(matrix, mouseX, mouseY, partial);
        int centerY = this.getY() + this.getHeight() / 2;
        TextListScrollAreaEntry.renderListingDot(matrix, this.getX() + 5, centerY - 2, this.listDotColor);
        float f = this.getX() + 5 + 4 + 3;
        this.font.getClass();
        this.font.func_243248_b(matrix, this.text, f, (float)(centerY - 9 / 2), -1);
    }

    @Override
    public void onClick(ScrollAreaEntry entry) {
        this.onClickCallback.accept((TextListScrollAreaEntry)entry);
    }

    public void setText(ITextComponent text) {
        this.text = text;
        this.textWidth = this.font.func_238414_a_((ITextProperties)this.text);
        this.setWidth(12 + this.textWidth + 5);
    }

    public ITextComponent getText() {
        return this.text;
    }

    public int getTextWidth() {
        return this.textWidth;
    }
}

