/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.helper.ui.texteditor;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.FMContextMenu;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.UIBase;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.scroll.scrollbar.ScrollBar;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.texteditor.TextEditorFormattingRule;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.texteditor.TextEditorLine;
import de.keksuccino.fancymenu.menu.fancy.helper.ui.texteditor.formattingrules.TextEditorFormattingRules;
import de.keksuccino.fancymenu.menu.placeholder.v2.Placeholder;
import de.keksuccino.fancymenu.menu.placeholder.v2.PlaceholderRegistry;
import de.keksuccino.fancymenu.mixin.client.IMixinTextFieldWidget;
import de.keksuccino.konkrete.gui.content.AdvancedButton;
import de.keksuccino.konkrete.input.CharacterFilter;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import java.awt.Color;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.minecraft.client.MainWindow;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class TextEditorScreen
extends Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    public Screen parentScreen;
    public CharacterFilter characterFilter;
    public Consumer<String> callback;
    public List<TextEditorLine> textFieldLines = new ArrayList<TextEditorLine>();
    public ScrollBar verticalScrollBar = new ScrollBar(ScrollBar.ScrollBarDirection.VERTICAL, 5, 40, 0, 0, 0, 0, (Color)null, null);
    public ScrollBar horizontalScrollBar = new ScrollBar(ScrollBar.ScrollBarDirection.HORIZONTAL, 40, 5, 0, 0, 0, 0, (Color)null, null);
    public ScrollBar verticalScrollBarPlaceholderMenu = new ScrollBar(ScrollBar.ScrollBarDirection.VERTICAL, 5, 40, 0, 0, 0, 0, (Color)null, null);
    public ScrollBar horizontalScrollBarPlaceholderMenu = new ScrollBar(ScrollBar.ScrollBarDirection.HORIZONTAL, 40, 5, 0, 0, 0, 0, (Color)null, null);
    public FMContextMenu rightClickContextMenu;
    public AdvancedButton cancelButton;
    public AdvancedButton doneButton;
    public AdvancedButton placeholderButton;
    public int lastCursorPosSetByUser = 0;
    public boolean justSwitchedLineByWordDeletion = false;
    public boolean triggeredFocusedLineWasTooHighInCursorPosMethod = false;
    public int headerHeight = 50;
    public int footerHeight = 50;
    public int borderLeft = 40;
    public int borderRight = 20;
    public int lineHeight = 14;
    public Color screenBackgroundColor = UIBase.SCREEN_BACKGROUND_COLOR;
    public Color editorAreaBorderColor = UIBase.ELEMENT_BORDER_COLOR_IDLE;
    public Color editorAreaBackgroundColor = UIBase.AREA_BACKGROUND_COLOR;
    public Color textColor = UIBase.TEXT_COLOR_GRAY_1;
    public Color focusedLineColor = UIBase.ENTRY_COLOR_FOCUSED;
    public Color scrollGrabberIdleColor = UIBase.SCROLL_GRABBER_IDLE_COLOR;
    public Color scrollGrabberHoverColor = UIBase.SCROLL_GRABBER_HOVER_COLOR;
    public Color sideBarColor = UIBase.SIDE_BAR_COLOR;
    public Color lineNumberTextColorNormal = UIBase.TEXT_COLOR_GREY_2;
    public Color lineNumberTextColorFocused = UIBase.TEXT_COLOR_GREY_3;
    public Color multilineNotSupportedNotificationColor = UIBase.TEXT_COLOR_RED_1;
    public Color placeholderEntryBackgroundColorIdle = UIBase.AREA_BACKGROUND_COLOR;
    public Color placeholderEntryBackgroundColorHover = UIBase.ENTRY_COLOR_FOCUSED;
    public Color placeholderEntryDotColorPlaceholder = UIBase.LISTING_DOT_BLUE;
    public Color placeholderEntryDotColorCategory = UIBase.LISTING_DOT_RED;
    public Color placeholderEntryLabelColor = UIBase.TEXT_COLOR_GRAY_1;
    public Color placeholderEntryBackToCategoriesLabelColor = UIBase.TEXT_COLOR_ORANGE_1;
    public int currentLineWidth;
    public int lastTickFocusedLineIndex = -1;
    public TextEditorLine startHighlightLine = null;
    public int startHighlightLineIndex = -1;
    public int endHighlightLineIndex = -1;
    public int overriddenTotalScrollHeight = -1;
    public List<Runnable> lineNumberRenderQueue = new ArrayList<Runnable>();
    public List<TextEditorFormattingRule> formattingRules = new ArrayList<TextEditorFormattingRule>();
    public int currentRenderCharacterIndexTotal = 0;
    public static boolean showPlaceholderMenu = false;
    public int placeholderMenuWidth = 120;
    public int placeholderMenuEntryHeight = 16;
    public List<PlaceholderMenuEntry> placeholderMenuEntries = new ArrayList<PlaceholderMenuEntry>();
    public boolean multilineMode = true;
    public long multilineNotSupportedNotificationDisplayStart = -1L;
    public boolean boldTitle = true;

    public TextEditorScreen(Screen parent, CharacterFilter characterFilter, Consumer<String> callback) {
        this(null, parent, characterFilter, callback);
    }

    public TextEditorScreen(ITextComponent title, Screen parent, CharacterFilter characterFilter, Consumer<String> callback) {
        super((ITextComponent)(title != null ? title : new StringTextComponent("")));
        this.field_230706_i_ = Minecraft.func_71410_x();
        this.field_230712_o_ = Minecraft.func_71410_x().field_71466_p;
        this.parentScreen = parent;
        this.characterFilter = characterFilter;
        this.callback = callback;
        this.addLine();
        this.getLine(0).func_146195_b(true);
        this.verticalScrollBar.setScrollWheelAllowed(true);
        this.verticalScrollBarPlaceholderMenu.setScrollWheelAllowed(true);
        this.updateRightClickContextMenu();
        this.formattingRules.addAll(TextEditorFormattingRules.getRules());
        this.updatePlaceholderEntries(null, true, true);
        this.updateCurrentLineWidth();
    }

    public void func_231160_c_() {
        Minecraft.func_71410_x().func_228018_at_().func_216525_a((double)Minecraft.func_71410_x().func_228018_at_().func_216521_a(Minecraft.func_71410_x().field_71474_y.field_74335_Z, Minecraft.func_71410_x().func_211821_e()));
        this.field_230709_l_ = Minecraft.func_71410_x().func_228018_at_().func_198087_p();
        this.field_230708_k_ = Minecraft.func_71410_x().func_228018_at_().func_198107_o();
        super.func_231160_c_();
        this.verticalScrollBar.scrollAreaStartX = this.getEditorAreaX() + 1;
        this.verticalScrollBar.scrollAreaStartY = this.getEditorAreaY() + 1;
        this.verticalScrollBar.scrollAreaEndX = this.getEditorAreaX() + this.getEditorAreaWidth() - 2;
        this.verticalScrollBar.scrollAreaEndY = this.getEditorAreaY() + this.getEditorAreaHeight() - this.horizontalScrollBar.grabberHeight - 2;
        this.horizontalScrollBar.scrollAreaStartX = this.getEditorAreaX() + 1;
        this.horizontalScrollBar.scrollAreaStartY = this.getEditorAreaY() + 1;
        this.horizontalScrollBar.scrollAreaEndX = this.getEditorAreaX() + this.getEditorAreaWidth() - this.verticalScrollBar.grabberWidth - 2;
        this.horizontalScrollBar.scrollAreaEndY = this.getEditorAreaY() + this.getEditorAreaHeight() - 1;
        int placeholderAreaX = this.field_230708_k_ - this.borderRight - this.placeholderMenuWidth;
        int placeholderAreaY = this.getEditorAreaY();
        this.verticalScrollBarPlaceholderMenu.scrollAreaStartX = placeholderAreaX + 1;
        this.verticalScrollBarPlaceholderMenu.scrollAreaStartY = placeholderAreaY + 1;
        this.verticalScrollBarPlaceholderMenu.scrollAreaEndX = placeholderAreaX + this.placeholderMenuWidth - 2;
        this.verticalScrollBarPlaceholderMenu.scrollAreaEndY = placeholderAreaY + this.getEditorAreaHeight() - this.horizontalScrollBarPlaceholderMenu.grabberHeight - 2;
        this.horizontalScrollBarPlaceholderMenu.scrollAreaStartX = placeholderAreaX + 1;
        this.horizontalScrollBarPlaceholderMenu.scrollAreaStartY = placeholderAreaY + 1;
        this.horizontalScrollBarPlaceholderMenu.scrollAreaEndX = placeholderAreaX + this.placeholderMenuWidth - this.verticalScrollBarPlaceholderMenu.grabberWidth - 2;
        this.horizontalScrollBarPlaceholderMenu.scrollAreaEndY = placeholderAreaY + this.getEditorAreaHeight() - 1;
        this.verticalScrollBar.idleBarColor = this.scrollGrabberIdleColor;
        this.verticalScrollBar.hoverBarColor = this.scrollGrabberHoverColor;
        this.horizontalScrollBar.idleBarColor = this.scrollGrabberIdleColor;
        this.horizontalScrollBar.hoverBarColor = this.scrollGrabberHoverColor;
        this.verticalScrollBarPlaceholderMenu.idleBarColor = this.scrollGrabberIdleColor;
        this.verticalScrollBarPlaceholderMenu.hoverBarColor = this.scrollGrabberHoverColor;
        this.horizontalScrollBarPlaceholderMenu.idleBarColor = this.scrollGrabberIdleColor;
        this.horizontalScrollBarPlaceholderMenu.hoverBarColor = this.scrollGrabberHoverColor;
        this.cancelButton = new AdvancedButton(this.field_230708_k_ - this.borderRight - 100 - 5 - 100, this.field_230709_l_ - 35, 100, 20, Locals.localize((String)"fancymenu.guicomponents.cancel", (String[])new String[0]), true, button -> this.func_231175_as__());
        UIBase.applyDefaultButtonSkinTo(this.cancelButton);
        this.doneButton = new AdvancedButton(this.field_230708_k_ - this.borderRight - 100, this.field_230709_l_ - 35, 100, 20, Locals.localize((String)"fancymenu.guicomponents.done", (String[])new String[0]), true, button -> {
            Minecraft.func_71410_x().func_147108_a(this.parentScreen);
            if (this.callback != null) {
                this.callback.accept(this.getText());
            }
        });
        UIBase.applyDefaultButtonSkinTo(this.doneButton);
        this.placeholderButton = new AdvancedButton(this.field_230708_k_ - this.borderRight - 100, this.headerHeight / 2 - 10, 100, 20, Locals.localize((String)"fancymenu.ui.text_editor.placeholders", (String[])new String[0]), true, button -> {
            showPlaceholderMenu = !showPlaceholderMenu;
            this.func_231160_c_();
        });
        this.placeholderButton.setDescription(StringUtils.splitLines((String)Locals.localize((String)"helper.ui.dynamicvariabletextfield.variables.desc", (String[])new String[0]), (String)"%n%"));
        UIBase.applyDefaultButtonSkinTo(this.placeholderButton);
        if (showPlaceholderMenu) {
            this.placeholderButton.setBackgroundColor(UIBase.getButtonIdleColor(), UIBase.getButtonHoverColor(), this.editorAreaBorderColor, this.editorAreaBorderColor, 1);
            this.placeholderButton.setHeight(this.getEditorAreaY() - (this.headerHeight / 2 - 10));
        }
    }

    public void updateRightClickContextMenu() {
        TextEditorLine hoveredLine = this.getHoveredLine();
        if (this.rightClickContextMenu != null) {
            this.rightClickContextMenu.closeMenu();
        }
        this.rightClickContextMenu = new FMContextMenu();
        AdvancedButton cutButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"fancymenu.ui.text_editor.cut", (String[])new String[0]), true, press -> {
            Minecraft.func_71410_x().field_195559_v.func_197960_a(this.cutHighlightedText());
            this.rightClickContextMenu.closeMenu();
        });
        this.rightClickContextMenu.addContent(cutButton);
        if (hoveredLine == null || !hoveredLine.isHighlightedHovered()) {
            cutButton.field_230693_o_ = false;
        }
        AdvancedButton copyButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"fancymenu.ui.text_editor.copy", (String[])new String[0]), true, press -> {
            Minecraft.func_71410_x().field_195559_v.func_197960_a(this.getHighlightedText());
            this.rightClickContextMenu.closeMenu();
        });
        this.rightClickContextMenu.addContent(copyButton);
        if (hoveredLine == null || !hoveredLine.isHighlightedHovered()) {
            copyButton.field_230693_o_ = false;
        }
        AdvancedButton pasteButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"fancymenu.ui.text_editor.paste", (String[])new String[0]), true, press -> {
            this.pasteText(Minecraft.func_71410_x().field_195559_v.func_197965_a());
            this.rightClickContextMenu.closeMenu();
        });
        this.rightClickContextMenu.addContent(pasteButton);
        this.rightClickContextMenu.addSeparator();
        AdvancedButton selectAllButton = new AdvancedButton(0, 0, 0, 0, Locals.localize((String)"fancymenu.ui.text_editor.select_all", (String[])new String[0]), true, press -> {
            for (TextEditorLine t : this.textFieldLines) {
                t.func_146199_i(0);
                t.func_212422_f(t.func_146179_b().length());
            }
            this.setFocusedLine(this.getLineCount() - 1);
            this.startHighlightLineIndex = 0;
            this.endHighlightLineIndex = this.getLineCount() - 1;
            this.rightClickContextMenu.closeMenu();
        });
        this.rightClickContextMenu.addContent(selectAllButton);
    }

    public void func_230430_a_(MatrixStack matrix, int mouseX, int mouseY, float partial) {
        if (this.currentLineWidth <= this.getEditorAreaWidth()) {
            this.horizontalScrollBar.setScroll(0.0f);
        }
        if (this.getTotalLineHeight() <= this.getEditorAreaHeight()) {
            this.verticalScrollBar.setScroll(0.0f);
        }
        this.justSwitchedLineByWordDeletion = false;
        this.updateCurrentLineWidth();
        this.verticalScrollBar.setWheelScrollSpeed(1.0f / ((float)this.getTotalScrollHeight() / 500.0f));
        this.renderScreenBackground(matrix);
        this.renderEditorAreaBackground(matrix);
        MainWindow win = Minecraft.func_71410_x().func_228018_at_();
        double scale = win.func_198100_s();
        int sciBottom = this.field_230709_l_ - this.footerHeight;
        RenderSystem.enableScissor((int)((int)((double)this.borderLeft * scale)), (int)((int)((double)win.func_198091_l() - (double)sciBottom * scale)), (int)((int)((double)this.getEditorAreaWidth() * scale)), (int)((int)((double)this.getEditorAreaHeight() * scale)));
        this.formattingRules.forEach(rule -> rule.resetRule(this));
        this.currentRenderCharacterIndexTotal = 0;
        this.lineNumberRenderQueue.clear();
        this.updateLines(line -> {
            if (line.isInEditorArea()) {
                this.lineNumberRenderQueue.add(() -> this.renderLineNumber(matrix, (TextEditorLine)((Object)line)));
            }
            line.func_230430_a_(matrix, mouseX, mouseY, partial);
        });
        RenderSystem.disableScissor();
        this.renderLineNumberBackground(matrix, this.borderLeft);
        RenderSystem.enableScissor((int)0, (int)((int)((double)win.func_198091_l() - (double)sciBottom * scale)), (int)((int)((double)this.borderLeft * scale)), (int)((int)((double)this.getEditorAreaHeight() * scale)));
        for (Runnable r : this.lineNumberRenderQueue) {
            r.run();
        }
        RenderSystem.disableScissor();
        this.lastTickFocusedLineIndex = this.getFocusedLineIndex();
        this.triggeredFocusedLineWasTooHighInCursorPosMethod = false;
        UIBase.renderBorder(matrix, this.borderLeft - 1, this.headerHeight - 1, this.getEditorAreaX() + this.getEditorAreaWidth(), this.field_230709_l_ - this.footerHeight + 1, 1, this.editorAreaBorderColor, true, true, true, true);
        this.verticalScrollBar.render(matrix);
        this.horizontalScrollBar.render(matrix);
        this.renderPlaceholderMenu(matrix, mouseX, mouseY, partial);
        this.cancelButton.func_230430_a_(matrix, mouseX, mouseY, partial);
        this.doneButton.func_230430_a_(matrix, mouseX, mouseY, partial);
        this.renderMultilineNotSupportedNotification(matrix, mouseX, mouseY, partial);
        UIBase.renderScaledContextMenu(matrix, this.rightClickContextMenu);
        this.tickMouseHighlighting();
        IFormattableTextComponent t = this.field_230704_d_.func_230532_e_();
        t.func_230530_a_(t.func_150256_b().func_240713_a_(Boolean.valueOf(this.boldTitle)));
        float f = this.borderLeft;
        int n = this.headerHeight / 2;
        this.field_230712_o_.getClass();
        this.field_230712_o_.func_243248_b(matrix, (ITextComponent)t, f, (float)(n - 9 / 2), -1);
    }

    protected void renderMultilineNotSupportedNotification(MatrixStack matrix, int mouseX, int mouseY, float partial) {
        long now = System.currentTimeMillis();
        if (!this.multilineMode && this.multilineNotSupportedNotificationDisplayStart + 3000L >= now) {
            int a = 255;
            int diff = (int)(this.multilineNotSupportedNotificationDisplayStart + 3000L - now);
            if (diff <= 1000) {
                float f = (float)diff / 1000.0f;
                a = Math.max(10, (int)(255.0f * f));
            }
            Color c = new Color(this.multilineNotSupportedNotificationColor.getRed(), this.multilineNotSupportedNotificationColor.getGreen(), this.multilineNotSupportedNotificationColor.getBlue(), a);
            String string = Locals.localize((String)"fancymenu.ui.text_editor.error.multiline_support", (String[])new String[0]);
            float f = this.borderLeft;
            this.field_230712_o_.getClass();
            this.field_230712_o_.func_238421_b_(matrix, string, f, (float)(this.headerHeight - 9 - 5), c.getRGB());
        }
    }

    protected void renderPlaceholderMenu(MatrixStack matrix, int mouseX, int mouseY, float partial) {
        if (showPlaceholderMenu) {
            if (this.getTotalPlaceholderEntriesWidth() <= this.placeholderMenuWidth) {
                this.horizontalScrollBarPlaceholderMenu.setScroll(0.0f);
            }
            if (this.getTotalPlaceholderEntriesHeight() <= this.getEditorAreaHeight()) {
                this.verticalScrollBarPlaceholderMenu.setScroll(0.0f);
            }
            TextEditorScreen.func_238467_a_((MatrixStack)matrix, (int)(this.field_230708_k_ - this.borderRight - this.placeholderMenuWidth), (int)this.getEditorAreaY(), (int)(this.field_230708_k_ - this.borderRight), (int)(this.getEditorAreaY() + this.getEditorAreaHeight()), (int)this.editorAreaBackgroundColor.getRGB());
            MainWindow win = Minecraft.func_71410_x().func_228018_at_();
            double scale = win.func_198100_s();
            int sciBottom = this.field_230709_l_ - this.footerHeight;
            RenderSystem.enableScissor((int)((int)((double)(this.field_230708_k_ - this.borderRight - this.placeholderMenuWidth) * scale)), (int)((int)((double)win.func_198091_l() - (double)sciBottom * scale)), (int)((int)((double)this.placeholderMenuWidth * scale)), (int)((int)((double)this.getEditorAreaHeight() * scale)));
            ArrayList<PlaceholderMenuEntry> entries = new ArrayList<PlaceholderMenuEntry>();
            entries.addAll(this.placeholderMenuEntries);
            int index = 0;
            for (PlaceholderMenuEntry e : entries) {
                e.x = this.field_230708_k_ - this.borderRight - this.placeholderMenuWidth + this.getPlaceholderEntriesRenderOffsetX();
                e.y = this.getEditorAreaY() + this.placeholderMenuEntryHeight * index + this.getPlaceholderEntriesRenderOffsetY();
                e.render(matrix, mouseX, mouseY, partial);
                ++index;
            }
            RenderSystem.disableScissor();
            UIBase.renderBorder(matrix, this.field_230708_k_ - this.borderRight - this.placeholderMenuWidth - 1, this.headerHeight - 1, this.field_230708_k_ - this.borderRight, this.field_230709_l_ - this.footerHeight + 1, 1, this.editorAreaBorderColor, true, true, true, true);
            this.verticalScrollBarPlaceholderMenu.render(matrix);
            this.horizontalScrollBarPlaceholderMenu.render(matrix);
        }
        this.placeholderButton.func_230430_a_(matrix, mouseX, mouseY, partial);
    }

    public int getTotalPlaceholderEntriesHeight() {
        return this.placeholderMenuEntryHeight * this.placeholderMenuEntries.size();
    }

    public int getTotalPlaceholderEntriesWidth() {
        int i = this.placeholderMenuWidth;
        for (PlaceholderMenuEntry e : this.placeholderMenuEntries) {
            if (e.getWidth() <= i) continue;
            i = e.getWidth();
        }
        return i;
    }

    public int getPlaceholderEntriesRenderOffsetX() {
        int totalScrollWidth = Math.max(0, this.getTotalPlaceholderEntriesWidth() - this.placeholderMenuWidth);
        return -((int)((float)totalScrollWidth / 100.0f * (this.horizontalScrollBarPlaceholderMenu.getScroll() * 100.0f)));
    }

    public int getPlaceholderEntriesRenderOffsetY() {
        int totalScrollHeight = Math.max(0, this.getTotalPlaceholderEntriesHeight() - this.getEditorAreaHeight());
        return -((int)((float)totalScrollHeight / 100.0f * (this.verticalScrollBarPlaceholderMenu.getScroll() * 100.0f)));
    }

    public void updatePlaceholderEntries(String category, boolean clearList, boolean addBackButton) {
        List<Placeholder> otherCategory;
        Map<String, List<Placeholder>> categories;
        if (clearList) {
            this.placeholderMenuEntries.clear();
        }
        if (!(categories = this.getPlaceholdersOrderedByCategories()).isEmpty() && (otherCategory = categories.get(Locals.localize((String)"fancymenu.helper.ui.dynamicvariabletextfield.categories.other", (String[])new String[0]))) != null) {
            if (category == null) {
                for (Map.Entry<String, List<Placeholder>> m : categories.entrySet()) {
                    if (m.getValue() == otherCategory) continue;
                    PlaceholderMenuEntry entry = new PlaceholderMenuEntry(this, (ITextComponent)new StringTextComponent((String)m.getKey()), () -> this.updatePlaceholderEntries((String)m.getKey(), true, true));
                    entry.dotColor = this.placeholderEntryDotColorCategory;
                    entry.entryLabelColor = this.placeholderEntryLabelColor;
                    this.placeholderMenuEntries.add(entry);
                }
                this.updatePlaceholderEntries(Locals.localize((String)"fancymenu.helper.ui.dynamicvariabletextfield.categories.other", (String[])new String[0]), false, false);
            } else {
                List<Placeholder> placeholders;
                if (addBackButton) {
                    PlaceholderMenuEntry backToCategoriesEntry = new PlaceholderMenuEntry(this, (ITextComponent)new StringTextComponent(Locals.localize((String)"fancymenu.ui.text_editor.placeholders.back_to_categories", (String[])new String[0])), () -> this.updatePlaceholderEntries(null, true, true));
                    backToCategoriesEntry.dotColor = this.placeholderEntryDotColorCategory;
                    backToCategoriesEntry.entryLabelColor = this.placeholderEntryBackToCategoriesLabelColor;
                    this.placeholderMenuEntries.add(backToCategoriesEntry);
                }
                if ((placeholders = categories.get(category)) != null) {
                    for (Placeholder p : placeholders) {
                        PlaceholderMenuEntry entry = new PlaceholderMenuEntry(this, (ITextComponent)new StringTextComponent(p.getDisplayName()), () -> this.pasteText(p.getDefaultPlaceholderString().toString()));
                        List<String> desc = p.getDescription();
                        if (desc != null) {
                            entry.setDescription(desc.toArray(new String[0]));
                        }
                        entry.dotColor = this.placeholderEntryDotColorPlaceholder;
                        entry.entryLabelColor = this.placeholderEntryLabelColor;
                        this.placeholderMenuEntries.add(entry);
                    }
                }
            }
            for (PlaceholderMenuEntry e : this.placeholderMenuEntries) {
                e.backgroundColorIdle = this.placeholderEntryBackgroundColorIdle;
                e.backgroundColorHover = this.placeholderEntryBackgroundColorHover;
            }
            this.verticalScrollBarPlaceholderMenu.setScroll(0.0f);
            this.horizontalScrollBarPlaceholderMenu.setScroll(0.0f);
        }
    }

    protected Map<String, List<Placeholder>> getPlaceholdersOrderedByCategories() {
        LinkedHashMap<String, List<Placeholder>> categories = new LinkedHashMap<String, List<Placeholder>>();
        for (Placeholder p : PlaceholderRegistry.getPlaceholdersList()) {
            ArrayList<Placeholder> l;
            String cat = p.getCategory();
            if (cat == null) {
                cat = Locals.localize((String)"fancymenu.helper.ui.dynamicvariabletextfield.categories.other", (String[])new String[0]);
            }
            if ((l = (ArrayList<Placeholder>)categories.get(cat)) == null) {
                l = new ArrayList<Placeholder>();
                categories.put(cat, l);
            }
            l.add(p);
        }
        List otherCategory = (List)categories.get(Locals.localize((String)"fancymenu.helper.ui.dynamicvariabletextfield.categories.other", (String[])new String[0]));
        if (otherCategory != null) {
            categories.remove(Locals.localize((String)"fancymenu.helper.ui.dynamicvariabletextfield.categories.other", (String[])new String[0]));
            categories.put(Locals.localize((String)"fancymenu.helper.ui.dynamicvariabletextfield.categories.other", (String[])new String[0]), otherCategory);
        }
        return categories;
    }

    protected void renderLineNumberBackground(MatrixStack matrix, int width) {
        TextEditorScreen.func_238467_a_((MatrixStack)matrix, (int)this.getEditorAreaX(), (int)(this.getEditorAreaY() - 1), (int)(this.getEditorAreaX() - width - 1), (int)(this.getEditorAreaY() + this.getEditorAreaHeight() + 1), (int)this.sideBarColor.getRGB());
    }

    protected void renderLineNumber(MatrixStack matrix, TextEditorLine line) {
        String lineNumberString = "" + (line.lineIndex + 1);
        int lineNumberWidth = this.field_230712_o_.func_78256_a(lineNumberString);
        float f = this.getEditorAreaX() - 3 - lineNumberWidth;
        int n = line.getY() + line.func_238483_d_() / 2;
        this.field_230712_o_.getClass();
        this.field_230712_o_.func_238421_b_(matrix, lineNumberString, f, (float)(n - 9 / 2), line.func_230999_j_() ? this.lineNumberTextColorFocused.getRGB() : this.lineNumberTextColorNormal.getRGB());
    }

    protected void renderEditorAreaBackground(MatrixStack matrix) {
        TextEditorScreen.func_238467_a_((MatrixStack)matrix, (int)this.getEditorAreaX(), (int)this.getEditorAreaY(), (int)(this.getEditorAreaX() + this.getEditorAreaWidth()), (int)(this.getEditorAreaY() + this.getEditorAreaHeight()), (int)this.editorAreaBackgroundColor.getRGB());
    }

    protected void renderScreenBackground(MatrixStack matrix) {
        TextEditorScreen.func_238467_a_((MatrixStack)matrix, (int)0, (int)0, (int)this.field_230708_k_, (int)this.field_230709_l_, (int)this.screenBackgroundColor.getRGB());
    }

    protected void tickMouseHighlighting() {
        TextEditorLine focused;
        if (!MouseInput.isLeftMouseDown()) {
            this.startHighlightLine = null;
            for (TextEditorLine t : this.textFieldLines) {
                t.isInMouseHighlightingMode = false;
            }
            return;
        }
        if (this.isInMouseHighlightingMode()) {
            float f;
            int mX = MouseInput.getMouseX();
            int mY = MouseInput.getMouseY();
            float speedMult = 0.008f;
            if (mX < this.borderLeft) {
                f = Math.max(0.01f, (float)(this.borderLeft - mX) * speedMult);
                this.horizontalScrollBar.setScroll(this.horizontalScrollBar.getScroll() - f);
            } else if (mX > this.getEditorAreaX() + this.getEditorAreaWidth()) {
                f = Math.max(0.01f, (float)(mX - (this.getEditorAreaX() + this.getEditorAreaWidth())) * speedMult);
                this.horizontalScrollBar.setScroll(this.horizontalScrollBar.getScroll() + f);
            }
            if (mY < this.headerHeight) {
                f = Math.max(0.01f, (float)(this.headerHeight - mY) * speedMult);
                this.verticalScrollBar.setScroll(this.verticalScrollBar.getScroll() - f);
            } else if (mY > this.field_230709_l_ - this.footerHeight) {
                f = Math.max(0.01f, (float)(mY - (this.field_230709_l_ - this.footerHeight)) * speedMult);
                this.verticalScrollBar.setScroll(this.verticalScrollBar.getScroll() + f);
            }
        }
        if (!this.isMouseInsideEditorArea()) {
            return;
        }
        TextEditorLine first = this.startHighlightLine;
        TextEditorLine hovered = this.getHoveredLine();
        if (hovered != null && !hovered.func_230999_j_() && first != null) {
            boolean firstIsAfterHovered;
            int firstIndex = this.getLineIndex(first);
            int hoveredIndex = this.getLineIndex(hovered);
            boolean firstIsBeforeHovered = hoveredIndex > firstIndex;
            boolean bl = firstIsAfterHovered = hoveredIndex < firstIndex;
            if (first.isInMouseHighlightingMode) {
                if (firstIsAfterHovered) {
                    this.setFocusedLine(this.getLineIndex(hovered));
                    if (!hovered.isInMouseHighlightingMode) {
                        hovered.isInMouseHighlightingMode = true;
                        hovered.getAsAccessor().setShiftPressedFancyMenu(false);
                        hovered.func_146190_e(hovered.func_146179_b().length());
                    }
                } else if (firstIsBeforeHovered) {
                    this.setFocusedLine(this.getLineIndex(hovered));
                    if (!hovered.isInMouseHighlightingMode) {
                        hovered.isInMouseHighlightingMode = true;
                        hovered.getAsAccessor().setShiftPressedFancyMenu(false);
                        hovered.func_146190_e(0);
                    }
                } else if (first == hovered) {
                    this.setFocusedLine(this.getLineIndex(first));
                }
            }
            int startIndex = Math.min(hoveredIndex, firstIndex);
            int endIndex = Math.max(hoveredIndex, firstIndex);
            int index = 0;
            for (TextEditorLine t : this.textFieldLines) {
                if (t != hovered && t != first) {
                    if (index > startIndex && index < endIndex) {
                        if (firstIsAfterHovered) {
                            t.func_212422_f(0);
                            t.func_146199_i(t.func_146179_b().length());
                        } else if (firstIsBeforeHovered) {
                            t.func_212422_f(t.func_146179_b().length());
                            t.func_146199_i(0);
                        }
                    } else {
                        t.getAsAccessor().setShiftPressedFancyMenu(false);
                        t.func_146190_e(0);
                        t.isInMouseHighlightingMode = false;
                    }
                }
                ++index;
            }
            this.startHighlightLineIndex = startIndex;
            this.endHighlightLineIndex = endIndex;
            if (first != hovered) {
                first.getAsAccessor().setShiftPressedFancyMenu(true);
                if (firstIsAfterHovered) {
                    first.func_146190_e(0);
                } else if (firstIsBeforeHovered) {
                    first.func_146190_e(first.func_146179_b().length());
                }
                first.getAsAccessor().setShiftPressedFancyMenu(false);
            }
        }
        if ((focused = this.getFocusedLine()) != null && focused.isInMouseHighlightingMode) {
            if (this.startHighlightLineIndex == -1 && this.endHighlightLineIndex == -1) {
                this.endHighlightLineIndex = this.startHighlightLineIndex = this.getLineIndex(focused);
            }
            int i = MathHelper.func_76141_d((float)MouseInput.getMouseX()) - focused.getX();
            if (focused.getAsAccessor().getBorderedFancyMenu()) {
                i -= 4;
            }
            String s = this.field_230712_o_.func_238412_a_(focused.func_146179_b().substring(focused.getAsAccessor().getDisplayPosFancyMenu()), focused.func_146200_o());
            focused.getAsAccessor().setShiftPressedFancyMenu(true);
            focused.func_146190_e(this.field_230712_o_.func_238412_a_(s, i).length() + focused.getAsAccessor().getDisplayPosFancyMenu());
            focused.getAsAccessor().setShiftPressedFancyMenu(false);
            if (focused.getAsAccessor().getHighlightPosFancyMenu() == focused.func_146198_h() && this.startHighlightLineIndex == this.endHighlightLineIndex) {
                this.resetHighlighting();
            }
        }
    }

    public void updateLines(Consumer<TextEditorLine> doAfterEachLineUpdate) {
        try {
            int index = 0;
            for (TextEditorLine line : this.textFieldLines) {
                line.lineIndex = index;
                line.setY(this.headerHeight + this.lineHeight * index + this.getLineRenderOffsetY());
                line.func_212952_l(this.borderLeft + this.getLineRenderOffsetX());
                line.func_230991_b_(this.currentLineWidth);
                line.setHeight(this.lineHeight);
                line.getAsAccessor().setDisplayPosFancyMenu(0);
                if (doAfterEachLineUpdate != null) {
                    doAfterEachLineUpdate.accept(line);
                }
                ++index;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updateCurrentLineWidth() {
        int longestTextWidth = 0;
        for (TextEditorLine f : this.textFieldLines) {
            if (f.textWidth <= longestTextWidth) continue;
            longestTextWidth = f.textWidth;
        }
        this.currentLineWidth = longestTextWidth + 30;
    }

    public int getLineRenderOffsetX() {
        return -((int)((float)this.getTotalScrollWidth() / 100.0f * (this.horizontalScrollBar.getScroll() * 100.0f)));
    }

    public int getLineRenderOffsetY() {
        return -((int)((float)this.getTotalScrollHeight() / 100.0f * (this.verticalScrollBar.getScroll() * 100.0f)));
    }

    public int getTotalLineHeight() {
        return this.lineHeight * this.textFieldLines.size();
    }

    public TextEditorLine addLineAtIndex(int index) {
        TextEditorLine before;
        if (!this.multilineMode && this.getLineCount() > 0) {
            this.multilineNotSupportedNotificationDisplayStart = System.currentTimeMillis();
            return null;
        }
        TextEditorLine f = new TextEditorLine(Minecraft.func_71410_x().field_71466_p, 0, 0, 50, this.lineHeight, false, this.characterFilter, this);
        f.func_146203_f(Integer.MAX_VALUE);
        f.lineIndex = index;
        if (index > 0 && (before = this.getLine(index - 1)) != null) {
            f.setY(before.getY() + this.lineHeight);
        }
        this.textFieldLines.add(index, f);
        return f;
    }

    public TextEditorLine addLine() {
        return this.addLineAtIndex(this.getLineCount());
    }

    public void removeLineAtIndex(int index) {
        if (index < 1) {
            return;
        }
        if (index <= this.getLineCount() - 1) {
            this.textFieldLines.remove(index);
        }
    }

    public void removeLastLine() {
        this.removeLineAtIndex(this.getLineCount() - 1);
    }

    public int getLineCount() {
        return this.textFieldLines.size();
    }

    public TextEditorLine getLine(int index) {
        return this.textFieldLines.get(index);
    }

    public void setFocusedLine(int index) {
        if (index <= this.getLineCount() - 1) {
            for (TextEditorLine f : this.textFieldLines) {
                f.func_146195_b(false);
            }
            this.getLine(index).func_146195_b(true);
        }
    }

    public int getFocusedLineIndex() {
        int index = 0;
        for (TextEditorLine f : this.textFieldLines) {
            if (f.func_230999_j_()) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public TextEditorLine getFocusedLine() {
        int index = this.getFocusedLineIndex();
        if (index != -1) {
            return this.getLine(index);
        }
        return null;
    }

    public boolean isLineFocused() {
        return this.getFocusedLineIndex() > -1;
    }

    public TextEditorLine getLineAfter(TextEditorLine line) {
        int index = this.getLineIndex(line);
        if (index > -1 && index < this.getLineCount() - 1) {
            return this.getLine(index + 1);
        }
        return null;
    }

    public TextEditorLine getLineBefore(TextEditorLine line) {
        int index = this.getLineIndex(line);
        if (index > 0) {
            return this.getLine(index - 1);
        }
        return null;
    }

    public boolean isAtLeastOneLineInHighlightMode() {
        for (TextEditorLine t : this.textFieldLines) {
            if (!t.isInMouseHighlightingMode) continue;
            return true;
        }
        return false;
    }

    public List<TextEditorLine> getLinesBetweenIndexes(int startIndex, int endIndex) {
        startIndex = Math.min(Math.max(startIndex, 0), this.textFieldLines.size() - 1);
        endIndex = Math.min(Math.max(endIndex, 0), this.textFieldLines.size() - 1);
        ArrayList<TextEditorLine> l = new ArrayList<TextEditorLine>();
        l.addAll(this.textFieldLines.subList(startIndex, endIndex));
        if (!l.isEmpty()) {
            l.remove(0);
        }
        return l;
    }

    public TextEditorLine getHoveredLine() {
        for (TextEditorLine t : this.textFieldLines) {
            if (!t.func_230449_g_()) continue;
            return t;
        }
        return null;
    }

    public int getLineIndex(TextEditorLine inputBox) {
        return this.textFieldLines.indexOf((Object)inputBox);
    }

    public void goUpLine() {
        int current;
        if (this.isLineFocused() && (current = Math.max(0, this.getFocusedLineIndex())) > 0) {
            TextEditorLine currentLine = this.getLine(current);
            this.setFocusedLine(current - 1);
            if (currentLine != null) {
                this.getFocusedLine().func_146190_e(this.lastCursorPosSetByUser);
            }
        }
    }

    public void goDownLine(boolean isNewLine) {
        if (this.isLineFocused()) {
            int current = Math.max(0, this.getFocusedLineIndex());
            if (isNewLine) {
                this.addLineAtIndex(current + 1);
            }
            TextEditorLine currentLine = this.getLine(current);
            this.setFocusedLine(current + 1);
            if (currentLine != null) {
                TextEditorLine nextLine = this.getFocusedLine();
                if (isNewLine) {
                    String textBeforeCursor = currentLine.func_146179_b().substring(0, currentLine.func_146198_h());
                    String textAfterCursor = currentLine.func_146179_b().substring(currentLine.func_146198_h());
                    currentLine.func_146180_a(textBeforeCursor);
                    nextLine.func_146180_a(textAfterCursor);
                    nextLine.func_146190_e(0);
                    if (textBeforeCursor.startsWith(" ")) {
                        int spaces = 0;
                        for (char c : textBeforeCursor.toCharArray()) {
                            if (!String.valueOf(c).equals(" ")) break;
                            ++spaces;
                        }
                        nextLine.func_146180_a(textBeforeCursor.substring(0, spaces) + nextLine.func_146179_b());
                        nextLine.func_146190_e(spaces);
                    }
                } else {
                    nextLine.func_146190_e(this.lastCursorPosSetByUser);
                }
            }
        }
    }

    public List<TextEditorLine> getCopyOfLines() {
        ArrayList<TextEditorLine> l = new ArrayList<TextEditorLine>();
        for (TextEditorLine t : this.textFieldLines) {
            TextEditorLine n = new TextEditorLine(this.field_230712_o_, 0, 0, 0, 0, false, this.characterFilter, this);
            n.func_146180_a(t.func_146179_b());
            n.func_146195_b(t.func_230999_j_());
            n.func_146190_e(t.func_146198_h());
            l.add(n);
        }
        return l;
    }

    public boolean isTextHighlighted() {
        return this.startHighlightLineIndex != -1 && this.endHighlightLineIndex != -1;
    }

    public boolean isHighlightedTextHovered() {
        if (this.isTextHighlighted()) {
            ArrayList<TextEditorLine> highlightedLines = new ArrayList<TextEditorLine>();
            if (this.endHighlightLineIndex <= this.getLineCount() - 1) {
                highlightedLines.addAll(this.textFieldLines.subList(this.startHighlightLineIndex, this.endHighlightLineIndex + 1));
            }
            for (TextEditorLine t : highlightedLines) {
                if (!t.isHighlightedHovered()) continue;
                return true;
            }
        }
        return false;
    }

    public String getHighlightedText() {
        try {
            if (this.startHighlightLineIndex != -1 && this.endHighlightLineIndex != -1) {
                ArrayList<TextEditorLine> lines = new ArrayList<TextEditorLine>();
                lines.add(this.getLine(this.startHighlightLineIndex));
                if (this.startHighlightLineIndex != this.endHighlightLineIndex) {
                    lines.addAll(this.getLinesBetweenIndexes(this.startHighlightLineIndex, this.endHighlightLineIndex));
                    lines.add(this.getLine(this.endHighlightLineIndex));
                }
                StringBuilder s = new StringBuilder();
                boolean b = false;
                for (TextEditorLine t : lines) {
                    if (b) {
                        s.append("\n");
                    }
                    s.append(t.func_146207_c());
                    b = true;
                }
                String ret = s.toString();
                return ret;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "";
    }

    public String cutHighlightedText() {
        String highlighted = this.getHighlightedText();
        this.deleteHighlightedText();
        return highlighted;
    }

    public void deleteHighlightedText() {
        int linesRemoved = 0;
        try {
            if (this.startHighlightLineIndex != -1 && this.endHighlightLineIndex != -1) {
                if (this.startHighlightLineIndex == this.endHighlightLineIndex) {
                    this.getLine(this.startHighlightLineIndex).func_146191_b("");
                } else {
                    TextEditorLine start = this.getLine(this.startHighlightLineIndex);
                    start.func_146191_b("");
                    TextEditorLine end = this.getLine(this.endHighlightLineIndex);
                    end.func_146191_b("");
                    if (this.endHighlightLineIndex - this.startHighlightLineIndex > 1) {
                        for (TextEditorLine line : this.getLinesBetweenIndexes(this.startHighlightLineIndex, this.endHighlightLineIndex)) {
                            this.removeLineAtIndex(this.getLineIndex(line));
                            ++linesRemoved;
                        }
                    }
                    String oldStartValue = start.func_146179_b();
                    start.func_212422_f(start.func_146179_b().length());
                    start.func_146199_i(start.func_146198_h());
                    start.func_146191_b(end.func_146179_b());
                    start.func_212422_f(oldStartValue.length());
                    start.func_146199_i(start.func_146198_h());
                    this.removeLineAtIndex(this.getLineIndex(end));
                    ++linesRemoved;
                    this.setFocusedLine(this.startHighlightLineIndex);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.correctYScroll(-linesRemoved);
        this.resetHighlighting();
    }

    public void resetHighlighting() {
        this.startHighlightLineIndex = -1;
        this.endHighlightLineIndex = -1;
        for (TextEditorLine t : this.textFieldLines) {
            t.func_146199_i(t.func_146198_h());
        }
    }

    public boolean isInMouseHighlightingMode() {
        return MouseInput.isLeftMouseDown() && this.startHighlightLine != null;
    }

    public void pasteText(String text) {
        try {
            if (text != null && !text.equals("")) {
                int addedLinesCount = 0;
                if (this.isTextHighlighted()) {
                    this.deleteHighlightedText();
                }
                if (!this.isLineFocused()) {
                    this.setFocusedLine(this.getLineCount() - 1);
                    this.getFocusedLine().func_146202_e();
                }
                TextEditorLine focusedLine = this.getFocusedLine();
                String textBeforeCursor = "";
                String textAfterCursor = "";
                if (focusedLine.func_146179_b().length() > 0) {
                    textBeforeCursor = focusedLine.func_146179_b().substring(0, focusedLine.func_146198_h());
                    if (focusedLine.func_146198_h() < focusedLine.func_146179_b().length()) {
                        textAfterCursor = this.getFocusedLine().func_146179_b().substring(focusedLine.func_146198_h(), focusedLine.func_146179_b().length());
                    }
                }
                focusedLine.func_146180_a(textBeforeCursor);
                focusedLine.func_212422_f(textBeforeCursor.length());
                String[] lines = new String[]{text};
                if (text.contains("\n")) {
                    lines = text.split("\n", -1);
                }
                if (!this.multilineMode && lines.length > 1) {
                    lines = new String[]{lines[0]};
                    this.multilineNotSupportedNotificationDisplayStart = System.currentTimeMillis();
                }
                Array.set(lines, lines.length - 1, lines[lines.length - 1] + textAfterCursor);
                if (lines.length == 1) {
                    this.getFocusedLine().func_146191_b(lines[0]);
                } else if (lines.length > 1) {
                    int index = -1;
                    for (String s : lines) {
                        if (index == -1) {
                            index = this.getFocusedLineIndex();
                        } else {
                            this.addLineAtIndex(index);
                            ++addedLinesCount;
                        }
                        this.getLine(index).func_146191_b(s);
                        ++index;
                    }
                    this.setFocusedLine(index - 1);
                    this.getFocusedLine().func_212422_f(Math.max(0, this.getFocusedLine().func_146179_b().length() - textAfterCursor.length()));
                    this.getFocusedLine().func_146199_i(this.getFocusedLine().func_146198_h());
                }
                this.correctYScroll(addedLinesCount);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.resetHighlighting();
    }

    public void setText(String text) {
        TextEditorLine t = this.getLine(0);
        this.textFieldLines.clear();
        this.textFieldLines.add(t);
        this.setFocusedLine(0);
        t.func_146180_a("");
        t.func_146190_e(0);
        this.pasteText(text);
        this.setFocusedLine(0);
        t.func_146190_e(0);
        this.verticalScrollBar.setScroll(0.0f);
    }

    public String getText() {
        StringBuilder s = new StringBuilder();
        boolean b = false;
        for (TextEditorLine t : this.textFieldLines) {
            if (b) {
                s.append("\n");
            }
            s.append(t.func_146179_b());
            b = true;
        }
        return s.toString();
    }

    public String getTextBeforeCursor() {
        if (!this.isLineFocused()) {
            return null;
        }
        int focusedLineIndex = this.getFocusedLineIndex();
        ArrayList<TextEditorLine> lines = new ArrayList<TextEditorLine>();
        if (focusedLineIndex == 0) {
            lines.add(this.getLine(0));
        } else if (focusedLineIndex > 0) {
            lines.addAll(this.textFieldLines.subList(0, focusedLineIndex + 1));
        }
        TextEditorLine lastLine = (TextEditorLine)((Object)lines.get(lines.size() - 1));
        StringBuilder s = new StringBuilder();
        boolean b = false;
        for (TextEditorLine t : lines) {
            if (b) {
                s.append("\n");
            }
            if (t != lastLine) {
                s.append(t.func_146179_b());
            } else {
                s.append(t.func_146179_b().substring(0, t.func_146198_h()));
            }
            b = true;
        }
        return s.toString();
    }

    public String getTextAfterCursor() {
        if (!this.isLineFocused()) {
            return null;
        }
        int focusedLineIndex = this.getFocusedLineIndex();
        ArrayList<TextEditorLine> lines = new ArrayList<TextEditorLine>();
        if (focusedLineIndex == this.getLineCount() - 1) {
            lines.add(this.getLine(this.getLineCount() - 1));
        } else if (focusedLineIndex < this.getLineCount() - 1) {
            lines.addAll(this.textFieldLines.subList(focusedLineIndex, this.getLineCount()));
        }
        TextEditorLine firstLine = (TextEditorLine)((Object)lines.get(0));
        StringBuilder s = new StringBuilder();
        boolean b = false;
        for (TextEditorLine t : lines) {
            if (b) {
                s.append("\n");
            }
            if (t != firstLine) {
                s.append(t.func_146179_b());
            } else {
                s.append(t.func_146179_b().substring(t.func_146198_h(), t.func_146179_b().length()));
            }
            b = true;
        }
        return s.toString();
    }

    public boolean func_231042_a_(char character, int modifiers) {
        for (TextEditorLine l : this.textFieldLines) {
            l.func_231042_a_(character, modifiers);
        }
        return super.func_231042_a_(character, modifiers);
    }

    public boolean func_231046_a_(int keycode, int i1, int i2) {
        for (TextEditorLine l : this.textFieldLines) {
            l.func_231046_a_(keycode, i1, i2);
        }
        if (keycode == 257) {
            if (!this.isInMouseHighlightingMode() && this.multilineMode && this.isLineFocused()) {
                this.resetHighlighting();
                this.goDownLine(true);
                this.correctYScroll(1);
            }
            if (!this.multilineMode) {
                this.multilineNotSupportedNotificationDisplayStart = System.currentTimeMillis();
            }
            return true;
        }
        if (keycode == 265) {
            if (!this.isInMouseHighlightingMode()) {
                this.resetHighlighting();
                this.goUpLine();
                this.correctYScroll(0);
            }
            return true;
        }
        if (keycode == 264) {
            if (!this.isInMouseHighlightingMode()) {
                this.resetHighlighting();
                this.goDownLine(false);
                this.correctYScroll(0);
            }
            return true;
        }
        if (keycode == 259) {
            if (!this.isInMouseHighlightingMode()) {
                if (this.isTextHighlighted()) {
                    this.deleteHighlightedText();
                } else if (this.isLineFocused()) {
                    TextEditorLine focused = this.getFocusedLine();
                    focused.getAsAccessor().setShiftPressedFancyMenu(false);
                    focused.getAsAccessor().invokeDeleteTextFancyMenu(-1);
                    focused.getAsAccessor().setShiftPressedFancyMenu(Screen.func_231173_s_());
                }
                this.resetHighlighting();
            }
            return true;
        }
        if (Screen.func_231169_i_((int)keycode)) {
            Minecraft.func_71410_x().field_195559_v.func_197960_a(this.getHighlightedText());
            return true;
        }
        if (Screen.func_231168_h_((int)keycode)) {
            this.pasteText(Minecraft.func_71410_x().field_195559_v.func_197965_a());
            return true;
        }
        if (Screen.func_231170_j_((int)keycode)) {
            for (TextEditorLine t : this.textFieldLines) {
                t.func_146199_i(0);
                t.func_212422_f(t.func_146179_b().length());
            }
            this.setFocusedLine(this.getLineCount() - 1);
            this.startHighlightLineIndex = 0;
            this.endHighlightLineIndex = this.getLineCount() - 1;
            return true;
        }
        if (Screen.func_231166_g_((int)keycode)) {
            Minecraft.func_71410_x().field_195559_v.func_197960_a(this.cutHighlightedText());
            this.resetHighlighting();
            return true;
        }
        if (keycode == 262 || keycode == 263) {
            this.resetHighlighting();
            return true;
        }
        return super.func_231046_a_(keycode, i1, i2);
    }

    public boolean func_223281_a_(int i1, int i2, int i3) {
        for (TextEditorLine l : this.textFieldLines) {
            l.func_223281_a_(i1, i2, i3);
        }
        return super.func_223281_a_(i1, i2, i3);
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        if (!this.isMouseInteractingWithGrabbers()) {
            for (TextEditorLine l : this.textFieldLines) {
                l.func_231044_a_(mouseX, mouseY, button);
            }
            if (this.isMouseInsideEditorArea()) {
                if (button == 1) {
                    this.rightClickContextMenu.closeMenu();
                }
                if (button == 0 || button == 1) {
                    boolean isHighlightedHovered = this.isHighlightedTextHovered();
                    TextEditorLine hoveredLine = this.getHoveredLine();
                    if (!this.rightClickContextMenu.isOpen()) {
                        if (button == 0 || !isHighlightedHovered) {
                            this.resetHighlighting();
                        }
                        if (hoveredLine == null) {
                            TextEditorLine focus = this.getLine(this.getLineCount() - 1);
                            for (TextEditorLine t : this.textFieldLines) {
                                if (MouseInput.getMouseY() < t.field_230691_m_ || MouseInput.getMouseY() > t.field_230691_m_ + t.func_238483_d_()) continue;
                                focus = t;
                                break;
                            }
                            this.setFocusedLine(this.getLineIndex(focus));
                            this.getFocusedLine().func_146202_e();
                            this.correctYScroll(0);
                        } else if (button == 1 && !isHighlightedHovered) {
                            this.setFocusedLine(this.getLineIndex(hoveredLine));
                            String s = this.field_230712_o_.func_238412_a_(hoveredLine.func_146179_b().substring(hoveredLine.getAsAccessor().getDisplayPosFancyMenu()), hoveredLine.func_146200_o());
                            hoveredLine.func_146190_e(this.field_230712_o_.func_238412_a_(s, MouseInput.getMouseX() - hoveredLine.getX()).length() + hoveredLine.getAsAccessor().getDisplayPosFancyMenu());
                        }
                    }
                    if (button == 1) {
                        this.updateRightClickContextMenu();
                        UIBase.openScaledContextMenuAtMouse(this.rightClickContextMenu);
                    } else if (this.rightClickContextMenu.isOpen() && !this.rightClickContextMenu.isHovered()) {
                        this.rightClickContextMenu.closeMenu();
                        this.textFieldLines.forEach(line -> line.func_231044_a_(mouseX, mouseY, button));
                        this.func_231044_a_(mouseX, mouseY, button);
                    }
                }
            }
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public void func_231023_e_() {
        for (TextEditorLine l : this.textFieldLines) {
            l.func_146178_a();
        }
        super.func_231023_e_();
    }

    public void func_231175_as__() {
        if (this.parentScreen != null) {
            Minecraft.func_71410_x().func_147108_a(this.parentScreen);
        } else {
            super.func_231175_as__();
        }
        if (this.callback != null) {
            this.callback.accept(null);
        }
    }

    public boolean isMouseInteractingWithGrabbers() {
        return this.verticalScrollBar.isGrabberGrabbed() || this.verticalScrollBar.isGrabberHovered() || this.horizontalScrollBar.isGrabberGrabbed() || this.horizontalScrollBar.isGrabberHovered();
    }

    public boolean isMouseInteractingWithPlaceholderGrabbers() {
        return this.verticalScrollBarPlaceholderMenu.isGrabberGrabbed() || this.verticalScrollBarPlaceholderMenu.isGrabberHovered() || this.horizontalScrollBarPlaceholderMenu.isGrabberGrabbed() || this.horizontalScrollBarPlaceholderMenu.isGrabberHovered();
    }

    public int getEditBoxCursorX(TextFieldWidget editBox) {
        try {
            int l;
            IMixinTextFieldWidget b = (IMixinTextFieldWidget)editBox;
            String s = this.field_230712_o_.func_238412_a_(editBox.func_146179_b().substring(b.getDisplayPosFancyMenu()), editBox.func_146200_o());
            int j = editBox.func_146198_h() - b.getDisplayPosFancyMenu();
            boolean flag = j >= 0 && j <= s.length();
            boolean flag2 = editBox.func_146198_h() < editBox.func_146179_b().length() || editBox.func_146179_b().length() >= b.getMaxLengthFancyMenu();
            int j1 = l = b.getBorderedFancyMenu() ? editBox.field_230690_l_ + 4 : editBox.field_230690_l_;
            if (!s.isEmpty()) {
                String s1 = flag ? s.substring(0, j) : s;
                j1 += this.field_230712_o_.func_243245_a(b.getFormatterFancyMenu().apply(s1, b.getDisplayPosFancyMenu()));
            }
            int k1 = j1;
            if (!flag) {
                k1 = j > 0 ? l + editBox.func_230998_h_() : l;
            } else if (flag2) {
                k1 = j1 - 1;
                --j1;
            }
            return k1;
        }
        catch (Exception e) {
            e.printStackTrace();
            return 0;
        }
    }

    public void scrollToLine(int lineIndex, boolean bottom) {
        if (bottom) {
            this.scrollToLine(lineIndex, -Math.max(0, this.getEditorAreaHeight() - this.lineHeight));
        } else {
            this.scrollToLine(lineIndex, 0);
        }
    }

    public void scrollToLine(int lineIndex, int offset) {
        int totalLineHeight = this.getTotalScrollHeight();
        float f = (float)Math.max(0, (lineIndex + 1) * this.lineHeight - this.lineHeight) / (float)totalLineHeight;
        if (offset != 0) {
            f = offset > 0 ? (f += (float)offset / (float)totalLineHeight) : (f -= (float)Math.abs(offset) / (float)totalLineHeight);
        }
        this.verticalScrollBar.setScroll(f);
    }

    public int getTotalScrollHeight() {
        if (this.overriddenTotalScrollHeight != -1) {
            return this.overriddenTotalScrollHeight;
        }
        return this.getTotalLineHeight();
    }

    public int getTotalScrollWidth() {
        return this.currentLineWidth;
    }

    public void correctYScroll(int lineCountOffsetAfterRemovingAdding) {
        if (this.isInMouseHighlightingMode() || !this.isLineFocused()) {
            return;
        }
        int minY = this.getEditorAreaY();
        int maxY = this.getEditorAreaY() + this.getEditorAreaHeight();
        int currentLineY = this.getFocusedLine().getY();
        if (currentLineY < minY) {
            this.scrollToLine(this.getFocusedLineIndex(), false);
        } else if (currentLineY + this.lineHeight > maxY) {
            this.scrollToLine(this.getFocusedLineIndex(), true);
        } else if (lineCountOffsetAfterRemovingAdding != 0) {
            this.overriddenTotalScrollHeight = -1;
            int removedAddedLineCount = Math.abs(lineCountOffsetAfterRemovingAdding);
            if (lineCountOffsetAfterRemovingAdding > 0) {
                this.overriddenTotalScrollHeight = this.getTotalScrollHeight() - this.lineHeight * removedAddedLineCount;
            } else if (lineCountOffsetAfterRemovingAdding < 0) {
                this.overriddenTotalScrollHeight = this.getTotalScrollHeight() + this.lineHeight * removedAddedLineCount;
            }
            this.updateLines(null);
            this.overriddenTotalScrollHeight = -1;
            int diffToTop = Math.max(0, this.getFocusedLine().getY() - this.getEditorAreaY());
            this.scrollToLine(this.getFocusedLineIndex(), -diffToTop);
            this.correctYScroll(0);
        }
        if (this.getTotalLineHeight() <= this.getEditorAreaHeight()) {
            this.verticalScrollBar.setScroll(0.0f);
        }
    }

    public void correctXScroll(TextEditorLine line) {
        if (this.isInMouseHighlightingMode()) {
            return;
        }
        if (this.isLineFocused() && this.getFocusedLine() == line) {
            boolean textGotAdded;
            int oldX = line.field_230690_l_;
            this.updateCurrentLineWidth();
            this.updateLines(null);
            int newX = line.field_230690_l_;
            String oldValue = line.lastTickValue;
            String newValue = line.func_146179_b();
            int cursorWidth = 2;
            if (line.func_146198_h() >= newValue.length()) {
                cursorWidth = 6;
            }
            int editorAreaCenterX = this.getEditorAreaX() + this.getEditorAreaWidth() / 2;
            int cursorX = this.getEditBoxCursorX((TextFieldWidget)line);
            if (cursorX > editorAreaCenterX) {
                cursorX += cursorWidth + 5;
            } else if (cursorX < editorAreaCenterX) {
                cursorX -= cursorWidth + 5;
            }
            int maxToRight = this.getEditorAreaX() + this.getEditorAreaWidth();
            int maxToLeft = this.getEditorAreaX();
            float currentScrollX = this.horizontalScrollBar.getScroll();
            int currentLineW = this.getTotalScrollWidth();
            boolean textGotDeleted = oldValue.length() > newValue.length();
            boolean bl = textGotAdded = oldValue.length() < newValue.length();
            if (cursorX > maxToRight) {
                float f = (float)(cursorX - maxToRight) / (float)currentLineW;
                this.horizontalScrollBar.setScroll(currentScrollX + f);
            } else if (cursorX < maxToLeft) {
                float f = (float)(maxToLeft - cursorX) / (float)currentLineW;
                if (textGotDeleted) {
                    f = (float)(maxToRight - maxToLeft) / (float)currentLineW;
                }
                this.horizontalScrollBar.setScroll(currentScrollX - f);
            } else if (textGotDeleted && oldX < newX) {
                float f = (float)(newX - oldX) / (float)currentLineW;
                this.horizontalScrollBar.setScroll(currentScrollX + f);
            } else if (textGotAdded && oldX > newX) {
                float f = (float)(oldX - newX) / (float)currentLineW;
                this.horizontalScrollBar.setScroll(currentScrollX - f);
            }
            if (line.func_146198_h() == 0) {
                this.horizontalScrollBar.setScroll(0.0f);
            }
        }
    }

    public boolean isMouseInsideEditorArea() {
        int xStart = this.borderLeft;
        int yStart = this.headerHeight;
        int xEnd = this.getEditorAreaX() + this.getEditorAreaWidth();
        int yEnd = this.field_230709_l_ - this.footerHeight;
        int mX = MouseInput.getMouseX();
        int mY = MouseInput.getMouseY();
        return mX >= xStart && mX <= xEnd && mY >= yStart && mY <= yEnd;
    }

    public int getEditorAreaWidth() {
        int i = this.field_230708_k_ - this.borderRight - this.borderLeft;
        if (showPlaceholderMenu) {
            i = i - this.placeholderMenuWidth - 15;
        }
        return i;
    }

    public int getEditorAreaHeight() {
        return this.field_230709_l_ - this.footerHeight - this.headerHeight;
    }

    public int getEditorAreaX() {
        return this.borderLeft;
    }

    public int getEditorAreaY() {
        return this.headerHeight;
    }

    public static class PlaceholderMenuEntry
    extends UIBase {
        public TextEditorScreen parent;
        public final ITextComponent label;
        public Runnable clickAction;
        public int x;
        public int y;
        public final int labelWidth;
        public Color backgroundColorIdle = Color.GRAY;
        public Color backgroundColorHover = Color.LIGHT_GRAY;
        public Color dotColor = Color.BLUE;
        public Color entryLabelColor = Color.WHITE;
        public AdvancedButton buttonBase;
        public FontRenderer font;

        public PlaceholderMenuEntry(TextEditorScreen parent, ITextComponent label, Runnable clickAction) {
            this.font = Minecraft.func_71410_x().field_71466_p;
            this.parent = parent;
            this.label = label;
            this.clickAction = clickAction;
            this.labelWidth = this.font.func_238414_a_((ITextProperties)this.label);
            this.buttonBase = new AdvancedButton(0, 0, this.getWidth(), this.getHeight(), "", true, button -> this.clickAction.run()){

                public boolean func_230449_g_() {
                    if (parent.isMouseInteractingWithPlaceholderGrabbers()) {
                        return false;
                    }
                    return super.func_230449_g_();
                }

                public void func_230982_a_(double p_93371_, double p_93372_) {
                    if (parent.isMouseInteractingWithPlaceholderGrabbers()) {
                        return;
                    }
                    super.func_230982_a_(p_93371_, p_93372_);
                }

                public void func_230430_a_(MatrixStack p_93657_, int p_93658_, int p_93659_, float p_93660_) {
                    if (parent.isMouseInteractingWithPlaceholderGrabbers()) {
                        this.field_230692_n_ = false;
                    }
                    super.func_230430_a_(p_93657_, p_93658_, p_93659_, p_93660_);
                }
            };
        }

        public void render(MatrixStack matrix, int mouseX, int mouseY, float partial) {
            this.buttonBase.setBackgroundColor(this.backgroundColorIdle, this.backgroundColorHover, this.backgroundColorIdle, this.backgroundColorHover, 1);
            this.buttonBase.field_230690_l_ = this.x;
            this.buttonBase.field_230691_m_ = this.y;
            int yCenter = this.y + this.getHeight() / 2;
            this.buttonBase.func_230430_a_(matrix, mouseX, mouseY, partial);
            PlaceholderMenuEntry.renderListingDot(matrix, this.x + 5, yCenter - 2, this.dotColor);
            float f = this.x + 5 + 4 + 3;
            this.font.getClass();
            this.font.func_243248_b(matrix, this.label, f, (float)(yCenter - 9 / 2), this.entryLabelColor.getRGB());
        }

        public int getWidth() {
            return Math.max(this.parent.placeholderMenuWidth, 12 + this.labelWidth + 5);
        }

        public int getHeight() {
            return this.parent.placeholderMenuEntryHeight;
        }

        public boolean isHovered() {
            return this.buttonBase.func_230449_g_();
        }

        public void setDescription(String ... desc) {
            this.buttonBase.setDescription(desc);
        }
    }
}

