/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item.playerentity;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.fancymenu.menu.fancy.item.playerentity.DummyWorldFactory;
import de.keksuccino.fancymenu.menu.fancy.item.playerentity.PlayerEntityCache;
import de.keksuccino.fancymenu.menu.fancy.item.playerentity.SkinExternalTextureResourceLocation;
import de.keksuccino.fancymenu.menu.fancy.item.playerentity.SkinWebTextureResourceLocation;
import de.keksuccino.fancymenu.menu.placeholder.v2.PlaceholderParser;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import de.keksuccino.konkrete.resources.TextureHandler;
import de.keksuccino.konkrete.resources.WebTextureResourceLocation;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Scanner;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.AbstractClientPlayerEntity;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.LivingRenderer;
import net.minecraft.client.renderer.entity.ParrotRenderer;
import net.minecraft.client.renderer.entity.layers.BipedArmorLayer;
import net.minecraft.client.renderer.entity.layers.HeadLayer;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.client.renderer.entity.model.ParrotModel;
import net.minecraft.client.renderer.entity.model.PlayerModel;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.DefaultPlayerSkin;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Matrix4f;
import net.minecraft.util.math.vector.Quaternion;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3f;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.util.text.StringTextComponent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerEntityCustomizationItem
extends CustomizationItemBase {
    private static final Logger LOGGER = LogManager.getLogger();
    public MenuPlayerEntity entity;
    public int scale = 30;
    public String playerName = null;
    public boolean autoRotation = true;
    public float bodyRotationX = 0.0f;
    public float bodyRotationY = 0.0f;
    public float headRotationX = 0.0f;
    public float headRotationY = 0.0f;
    private static final ClientWorld DUMMY_CLIENT_WORLD = DummyWorldFactory.getDummyClientWorld();
    private static final BlockPos BLOCK_POS = new BlockPos(0, 0, 0);
    private static final MenuPlayerRenderer PLAYER_RENDERER = new MenuPlayerRenderer(false);
    private static final MenuPlayerRenderer SLIM_PLAYER_RENDERER = new MenuPlayerRenderer(true);

    public PlayerEntityCustomizationItem(PropertiesSection item) {
        super(item);
        String autoRot;
        String bodyrotY;
        String bodyrotX;
        String rotY;
        String rotX;
        String showName;
        String crouching;
        String parrot;
        String slim;
        String cape;
        WebTextureResourceLocation wt;
        String capeUrl;
        String skin;
        WebTextureResourceLocation wt2;
        String scaleString;
        if (!((Boolean)FancyMenu.config.getOrDefault("allow_level_registry_interactions", (Object)false)).booleanValue()) {
            LOGGER.warn("CRITICAL WARNING: Player Entity element constructed while level registry interactions were disabled! Please report this to the dev of FancyMenu!");
        }
        if ((scaleString = item.getEntryValue("scale")) != null && MathUtils.isDouble((String)scaleString)) {
            this.scale = (int)Double.parseDouble(scaleString);
        }
        this.playerName = item.getEntryValue("playername");
        if (this.playerName != null) {
            this.playerName = PlaceholderParser.replacePlaceholders(this.playerName);
        }
        this.entity = new MenuPlayerEntity(this.playerName);
        String skinUrl = item.getEntryValue("skinurl");
        if (skinUrl != null && (wt2 = TextureHandler.getWebResource((String)(skinUrl = StringUtils.convertFormatCodes((String)PlaceholderParser.replacePlaceholders(skinUrl), (String)"\u00a7", (String)"&")))) != null) {
            this.entity.skinLocation = wt2.getResourceLocation();
        }
        if ((skin = PlayerEntityCustomizationItem.fixBackslashPath(item.getEntryValue("skinpath"))) != null && this.entity.skinLocation == null) {
            ExternalTextureResourceLocation r;
            File f = new File(skin);
            if (!f.exists() || !f.getAbsolutePath().replace("\\", "/").startsWith(Minecraft.func_71410_x().field_71412_D.getAbsolutePath().replace("\\", "/"))) {
                skin = Minecraft.func_71410_x().field_71412_D.getAbsolutePath().replace("\\", "/") + "/" + skin;
                f = new File(skin);
            }
            if ((r = TextureHandler.getResource((String)skin)) != null) {
                if (r.getHeight() < 64) {
                    String sha1;
                    if (f.isFile() && (f.getPath().toLowerCase().endsWith(".jpg") || f.getPath().toLowerCase().endsWith(".jpeg") || f.getPath().toLowerCase().endsWith(".png")) && (sha1 = PlayerEntityCache.calculateSHA1(f)) != null) {
                        if (!PlayerEntityCache.isSkinCached(sha1)) {
                            SkinExternalTextureResourceLocation sr = new SkinExternalTextureResourceLocation(skin);
                            sr.loadTexture();
                            PlayerEntityCache.cacheSkin(sha1, sr.getResourceLocation());
                            this.entity.skinLocation = sr.getResourceLocation();
                        } else {
                            this.entity.skinLocation = PlayerEntityCache.getSkin(sha1);
                        }
                    }
                } else {
                    this.entity.skinLocation = r.getResourceLocation();
                }
            }
        }
        if ((capeUrl = item.getEntryValue("capeurl")) != null && (wt = TextureHandler.getWebResource((String)(capeUrl = StringUtils.convertFormatCodes((String)PlaceholderParser.replacePlaceholders(capeUrl), (String)"\u00a7", (String)"&")))) != null) {
            this.entity.capeLocation = wt.getResourceLocation();
        }
        if ((cape = PlayerEntityCustomizationItem.fixBackslashPath(item.getEntryValue("capepath"))) != null && this.entity.capeLocation == null) {
            ExternalTextureResourceLocation r;
            File f = new File(cape);
            if (!f.exists() || !f.getAbsolutePath().replace("\\", "/").startsWith(Minecraft.func_71410_x().field_71412_D.getAbsolutePath().replace("\\", "/"))) {
                cape = Minecraft.func_71410_x().field_71412_D.getAbsolutePath().replace("\\", "/") + "/" + cape;
            }
            if ((r = TextureHandler.getResource((String)cape)) != null) {
                this.entity.capeLocation = r.getResourceLocation();
            }
        }
        if ((slim = item.getEntryValue("slim")) != null && slim.replace(" ", "").equalsIgnoreCase("true")) {
            this.entity.setSlimSkin(true);
        }
        if ((parrot = item.getEntryValue("parrot")) != null && parrot.replace(" ", "").equalsIgnoreCase("true")) {
            this.entity.hasParrot = true;
        }
        if ((crouching = item.getEntryValue("crouching")) != null && crouching.replace(" ", "").equalsIgnoreCase("true")) {
            this.entity.crouching = true;
        }
        if ((showName = item.getEntryValue("showname")) != null && showName.replace(" ", "").equalsIgnoreCase("false")) {
            this.entity.showName = false;
        }
        if ((rotX = item.getEntryValue("headrotationx")) != null && MathUtils.isFloat((String)(rotX = rotX.replace(" ", "")))) {
            this.headRotationX = Float.parseFloat(rotX);
        }
        if ((rotY = item.getEntryValue("headrotationy")) != null && MathUtils.isFloat((String)(rotY = rotY.replace(" ", "")))) {
            this.headRotationY = Float.parseFloat(rotY);
        }
        if ((bodyrotX = item.getEntryValue("bodyrotationx")) != null && MathUtils.isFloat((String)(bodyrotX = bodyrotX.replace(" ", "")))) {
            this.bodyRotationX = Float.parseFloat(bodyrotX);
        }
        if ((bodyrotY = item.getEntryValue("bodyrotationy")) != null && MathUtils.isFloat((String)(bodyrotY = bodyrotY.replace(" ", "")))) {
            this.bodyRotationY = Float.parseFloat(bodyrotY);
        }
        if ((autoRot = item.getEntryValue("autorotation")) != null && autoRot.replace(" ", "").equalsIgnoreCase("false")) {
            this.autoRotation = false;
        }
        this.value = this.playerName != null ? this.playerName : "Player Entity";
        this.setWidth((int)(this.entity.func_213311_cf() * (float)this.scale));
        this.setHeight((int)(this.entity.func_213302_cg() * (float)this.scale));
    }

    @Override
    public void render(MatrixStack matrix, Screen menu) throws IOException {
        try {
            if (this.shouldRender() && this.entity != null) {
                this.value = this.playerName != null ? this.playerName : "Player Entity";
                this.setWidth((int)(this.entity.func_213311_cf() * (float)this.scale));
                this.setHeight((int)(this.entity.func_213302_cg() * (float)this.scale));
                int mX = MouseInput.getMouseX();
                int mY = MouseInput.getMouseY();
                PlayerEntityCustomizationItem.renderPlayerEntity(this.getPosX(menu), this.getPosY(menu), this.scale, mX, mY, this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void renderPlayerEntity(int posX, int posY, int scale, float mouseX, float mouseY, PlayerEntityCustomizationItem item) {
        Quaternion q;
        float entityHeight = item.entity.func_213302_cg() * (float)item.scale;
        float rotationX = (float)Math.atan((mouseX - (float)item.getPosX(Minecraft.func_71410_x().field_71462_r)) / 40.0f);
        float rotationY = (float)Math.atan((mouseY - ((float)item.getPosY(Minecraft.func_71410_x().field_71462_r) - entityHeight / 2.0f)) / 40.0f);
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)posX, (float)posY, (float)1050.0f);
        RenderSystem.scalef((float)1.0f, (float)1.0f, (float)-1.0f);
        MatrixStack matrix = new MatrixStack();
        matrix.func_227861_a_(0.0, 0.0, 1000.0);
        matrix.func_227862_a_((float)scale, (float)scale, (float)scale);
        if (!item.autoRotation) {
            q = Vector3f.field_229183_f_.func_229187_a_(180.0f);
            Quaternion q2 = Vector3f.field_229179_b_.func_229187_a_(item.bodyRotationY);
            q.func_195890_a(q2);
            matrix.func_227863_a_(q);
            item.entity.field_70761_aq = item.bodyRotationX;
            item.entity.field_70125_A = item.headRotationY;
            item.entity.field_70759_as = item.headRotationX;
        } else {
            q = Vector3f.field_229183_f_.func_229187_a_(180.0f);
            Quaternion q2 = Vector3f.field_229179_b_.func_229187_a_((float)Math.negateExact((long)(rotationY * 20.0f)));
            q.func_195890_a(q2);
            matrix.func_227863_a_(q);
            item.entity.field_70761_aq = Math.negateExact((long)(180.0f + rotationX * 20.0f));
            item.entity.field_70125_A = Math.negateExact((long)(-rotationY * 20.0f));
            item.entity.field_70759_as = Math.negateExact((long)(180.0f + rotationX * 40.0f));
        }
        IRenderTypeBuffer.Impl rb = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
        RenderSystem.runAsFancy(() -> item.renderEntityStatic(0.0, 0.0, 0.0, 0.0f, 1.0f, matrix, (IRenderTypeBuffer)rb, 0xF000F0));
        rb.func_228461_a_();
        RenderSystem.popMatrix();
    }

    public void renderEntityStatic(double xIn, double yIn, double zIn, float rotationYawIn, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
        try {
            Vector3d vector3d = this.entity.isSlimSkin() ? SLIM_PLAYER_RENDERER.getRenderOffset(this.entity, partialTicks) : PLAYER_RENDERER.getRenderOffset(this.entity, partialTicks);
            double d2 = xIn + vector3d.func_82615_a();
            double d3 = yIn + vector3d.func_82617_b();
            double d0 = zIn + vector3d.func_82616_c();
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_(d2, d3, d0);
            if (this.entity.isSlimSkin()) {
                SLIM_PLAYER_RENDERER.render(this.entity, rotationYawIn, partialTicks, matrixStackIn, bufferIn, packedLightIn);
            } else {
                PLAYER_RENDERER.render(this.entity, rotationYawIn, partialTicks, matrixStackIn, bufferIn, packedLightIn);
            }
            matrixStackIn.func_227861_a_(-vector3d.func_82615_a(), -vector3d.func_82617_b(), -vector3d.func_82616_c());
            matrixStackIn.func_227865_b_();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getSkinURL(String playerName) {
        String skinUrl = null;
        try {
            URL url = new URL("https://api.ashcon.app/mojang/v2/user/" + playerName);
            Scanner scanner = new Scanner(new InputStreamReader(url.openStream()));
            boolean b = false;
            boolean b2 = false;
            while (scanner.hasNextLine()) {
                String line = scanner.next();
                if (b) {
                    skinUrl = line.substring(1, line.length() - 2);
                    break;
                }
                if (line.contains("\"skin\":")) {
                    b2 = true;
                }
                if (line.contains("\"code\":")) break;
                if (!line.contains("\"url\":") || !b2) continue;
                b = true;
            }
            scanner.close();
        }
        catch (IOException url) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return skinUrl;
    }

    private static String getCapeURL(String playerName) {
        String capeUrl = null;
        try {
            URL url = new URL("https://api.ashcon.app/mojang/v2/user/" + playerName);
            Scanner scanner = new Scanner(new InputStreamReader(url.openStream()));
            boolean b = false;
            boolean b2 = false;
            while (scanner.hasNextLine()) {
                String line = scanner.next();
                if (b) {
                    capeUrl = line.substring(1, line.length() - 2);
                    break;
                }
                if (line.contains("\"cape\":")) {
                    b2 = true;
                }
                if (line.contains("\"code\":")) break;
                if (!line.contains("\"url\":") || !b2) continue;
                b = true;
            }
            scanner.close();
        }
        catch (IOException url) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return capeUrl;
    }

    private static boolean getIsSlimSkin(String playerName) {
        boolean slim = false;
        try {
            URL url = new URL("https://api.ashcon.app/mojang/v2/user/" + playerName);
            Scanner scanner = new Scanner(new InputStreamReader(url.openStream()));
            boolean b = false;
            boolean b2 = false;
            while (scanner.hasNextLine()) {
                String line = scanner.next();
                if (b) {
                    String slimString = line.substring(1, line.length() - 2);
                    if (!slimString.equalsIgnoreCase("true")) break;
                    slim = true;
                    break;
                }
                if (line.contains("\"textures\":")) {
                    b2 = true;
                }
                if (line.contains("\"code\":")) break;
                if (!line.contains("\"slim\":") || !b2) continue;
                b = true;
            }
            scanner.close();
        }
        catch (IOException url) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return slim;
    }

    public static class MenuPlayerParrotLayer
    extends LayerRenderer<MenuPlayerEntity, PlayerModel<MenuPlayerEntity>> {
        private final ParrotModel parrotModel = new ParrotModel();

        public MenuPlayerParrotLayer(IEntityRenderer<MenuPlayerEntity, PlayerModel<MenuPlayerEntity>> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, MenuPlayerEntity playerEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (playerEntity.hasParrot) {
                this.renderParrot(matrixStackIn, bufferIn, packedLightIn, playerEntity, limbSwing, limbSwingAmount, netHeadYaw, headPitch, 0);
            }
        }

        private void renderParrot(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, MenuPlayerEntity playerEntity, float limbSwing, float limbSwingAmount, float netHeadYaw, float headPitch, int parrotVariant) {
            matrixStackIn.func_227860_a_();
            matrixStackIn.func_227861_a_((double)-0.4f, playerEntity.func_213453_ef() ? (double)-1.3f : -1.5, 0.0);
            IVertexBuilder ivertexbuilder = bufferIn.getBuffer(this.parrotModel.func_228282_a_(ParrotRenderer.field_192862_a[parrotVariant]));
            this.parrotModel.func_228284_a_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_, limbSwing, limbSwingAmount, netHeadYaw, headPitch, playerEntity.field_70173_aa);
            matrixStackIn.func_227865_b_();
        }
    }

    public static class MenuPlayerCapeLayer
    extends LayerRenderer<MenuPlayerEntity, PlayerModel<MenuPlayerEntity>> {
        public MenuPlayerCapeLayer(IEntityRenderer<MenuPlayerEntity, PlayerModel<MenuPlayerEntity>> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn, MenuPlayerEntity playerEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (playerEntity.hasCape()) {
                matrixStackIn.func_227860_a_();
                matrixStackIn.func_227861_a_(0.0, 0.0, 0.125);
                double d0 = MathHelper.func_219803_d((double)partialTicks, (double)playerEntity.field_71091_bM, (double)playerEntity.field_71094_bP) - MathHelper.func_219803_d((double)partialTicks, (double)playerEntity.field_70169_q, (double)playerEntity.func_226277_ct_());
                double d1 = MathHelper.func_219803_d((double)partialTicks, (double)playerEntity.field_71096_bN, (double)playerEntity.field_71095_bQ) - MathHelper.func_219803_d((double)partialTicks, (double)playerEntity.field_70167_r, (double)playerEntity.func_226278_cu_());
                double d2 = MathHelper.func_219803_d((double)partialTicks, (double)playerEntity.field_71097_bO, (double)playerEntity.field_71085_bR) - MathHelper.func_219803_d((double)partialTicks, (double)playerEntity.field_70166_s, (double)playerEntity.func_226281_cx_());
                float f = playerEntity.field_70760_ar + (playerEntity.field_70761_aq - playerEntity.field_70760_ar);
                double d3 = MathHelper.func_76126_a((float)(f * ((float)Math.PI / 180)));
                double d4 = -MathHelper.func_76134_b((float)(f * ((float)Math.PI / 180)));
                float f1 = (float)d1 * 10.0f;
                f1 = MathHelper.func_76131_a((float)f1, (float)-6.0f, (float)32.0f);
                float f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
                f2 = MathHelper.func_76131_a((float)f2, (float)0.0f, (float)150.0f);
                float f4 = MathHelper.func_219799_g((float)partialTicks, (float)playerEntity.field_71107_bF, (float)playerEntity.field_71109_bG);
                f1 += MathHelper.func_76126_a((float)(MathHelper.func_219799_g((float)partialTicks, (float)playerEntity.field_70141_P, (float)playerEntity.field_70140_Q) * 6.0f)) * 32.0f * f4;
                if (playerEntity.func_213453_ef()) {
                    f1 += 25.0f;
                }
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(6.0f + f2 / 2.0f + f1));
                matrixStackIn.func_227863_a_(Vector3f.field_229183_f_.func_229187_a_(0.0f));
                matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_(180.0f));
                IVertexBuilder ivertexbuilder = bufferIn.getBuffer(RenderType.func_228634_a_((ResourceLocation)playerEntity.getCape()));
                ((PlayerModel)this.func_215332_c()).func_228289_b_(matrixStackIn, ivertexbuilder, packedLightIn, OverlayTexture.field_229196_a_);
                matrixStackIn.func_227865_b_();
            }
        }
    }

    public static class MenuPlayerEntity
    extends AbstractClientPlayerEntity {
        public volatile ResourceLocation skinLocation;
        public volatile ResourceLocation capeLocation;
        private volatile boolean capeChecked = false;
        private volatile boolean capeGettingChecked = false;
        private volatile boolean skinChecked = false;
        private volatile boolean skinGettingChecked = false;
        private volatile boolean slimSkin = false;
        private volatile boolean slimSkinChecked = false;
        private volatile boolean slimSkinGettingChecked = false;
        public boolean hasParrot = false;
        public boolean crouching = false;
        public boolean showName = true;
        public volatile String playerName;
        private volatile Runnable getSkinCallback;
        private volatile Runnable getCapeCallback;

        public MenuPlayerEntity(String playerName) {
            super(DUMMY_CLIENT_WORLD, new GameProfile(PlayerEntity.func_175147_b((String)MenuPlayerEntity.getRawPlayerName(playerName)), MenuPlayerEntity.getRawPlayerName(playerName)));
            if (playerName != null) {
                this.playerName = playerName;
            }
        }

        private static String getRawPlayerName(String playerName) {
            if (playerName == null) {
                return "steve";
            }
            return playerName;
        }

        public Vector3d func_213303_ch() {
            return new Vector3d(-100000.0, -100000.0, -100000.0);
        }

        public double func_70068_e(Entity entityIn) {
            return 0.0;
        }

        public boolean func_175149_v() {
            return false;
        }

        public boolean func_184812_l_() {
            return false;
        }

        public boolean func_213453_ef() {
            return this.crouching;
        }

        public ITextComponent func_145748_c_() {
            if (this.playerName != null) {
                return new StringTextComponent(this.playerName);
            }
            return null;
        }

        public void setSlimSkin(boolean slim) {
            this.slimSkin = slim;
            this.slimSkinChecked = true;
        }

        public boolean isSlimSkin() {
            if (this.playerName != null && !this.slimSkinChecked) {
                if (!PlayerEntityCache.isSlimSkinInfoCached(this.playerName)) {
                    if (!this.slimSkinGettingChecked) {
                        this.slimSkinGettingChecked = true;
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    boolean b = PlayerEntityCustomizationItem.getIsSlimSkin(playerName);
                                    if (!slimSkinChecked) {
                                        slimSkin = b;
                                        PlayerEntityCache.cacheIsSlimSkin(playerName, b);
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                slimSkinChecked = true;
                                slimSkinGettingChecked = false;
                            }
                        }).start();
                    }
                } else {
                    this.slimSkin = PlayerEntityCache.getIsSlimSkin(this.playerName);
                    this.slimSkinChecked = true;
                }
            }
            return this.slimSkin;
        }

        public boolean hasNonDefaultSkin() {
            return this.skinLocation != DefaultPlayerSkin.func_177335_a();
        }

        public boolean hasCape() {
            return this.getCape() != null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public ResourceLocation getSkin() {
            if (this.getSkinCallback != null) {
                this.getSkinCallback.run();
                this.getSkinCallback = null;
            }
            if (this.playerName != null) {
                if (this.skinLocation != null) return this.skinLocation;
                if (!this.skinChecked) {
                    if (!PlayerEntityCache.isSkinCached(this.playerName)) {
                        if (this.skinGettingChecked) return DefaultPlayerSkin.func_177335_a();
                        this.skinGettingChecked = true;
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    final String skinUrl = PlayerEntityCustomizationItem.getSkinURL(playerName);
                                    if (skinLocation == null) {
                                        if (skinUrl == null) {
                                            skinLocation = DefaultPlayerSkin.func_177335_a();
                                            slimSkin = false;
                                            slimSkinChecked = true;
                                        } else if (getSkinCallback == null) {
                                            getSkinCallback = new Runnable(){

                                                @Override
                                                public void run() {
                                                    WebTextureResourceLocation wt = TextureHandler.getWebResource((String)skinUrl);
                                                    if (skinLocation == null) {
                                                        if (wt != null) {
                                                            if (wt.getHeight() < 64) {
                                                                wt = new SkinWebTextureResourceLocation(skinUrl);
                                                                wt.loadTexture();
                                                            }
                                                            skinLocation = wt.getResourceLocation();
                                                            PlayerEntityCache.cacheSkin(playerName, wt.getResourceLocation());
                                                        } else {
                                                            skinLocation = DefaultPlayerSkin.func_177335_a();
                                                            slimSkin = false;
                                                            slimSkinChecked = true;
                                                        }
                                                    }
                                                }
                                            };
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                skinChecked = true;
                                skinGettingChecked = false;
                            }
                        }).start();
                        return this.skinLocation;
                    } else {
                        this.skinLocation = PlayerEntityCache.getSkin(this.playerName);
                        this.skinChecked = true;
                    }
                    return this.skinLocation;
                } else {
                    this.skinLocation = DefaultPlayerSkin.func_177335_a();
                    this.slimSkin = false;
                    this.slimSkinChecked = true;
                }
                return this.skinLocation;
            } else {
                if (this.skinLocation != null) return this.skinLocation;
                this.skinLocation = DefaultPlayerSkin.func_177335_a();
                this.slimSkin = false;
                this.slimSkinChecked = true;
            }
            return this.skinLocation;
        }

        public ResourceLocation getCape() {
            if (this.getCapeCallback != null) {
                this.getCapeCallback.run();
                this.getCapeCallback = null;
            }
            if (this.playerName != null && this.capeLocation == null && !this.capeChecked) {
                if (!PlayerEntityCache.isCapeCached(this.playerName)) {
                    if (!this.capeGettingChecked) {
                        this.capeGettingChecked = true;
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    final String capeUrl = PlayerEntityCustomizationItem.getCapeURL(playerName);
                                    if (!capeChecked && capeUrl != null && getCapeCallback == null) {
                                        getCapeCallback = new Runnable(){

                                            @Override
                                            public void run() {
                                                WebTextureResourceLocation wt = TextureHandler.getWebResource((String)capeUrl);
                                                if (wt != null) {
                                                    capeLocation = wt.getResourceLocation();
                                                    PlayerEntityCache.cacheCape(playerName, wt.getResourceLocation());
                                                }
                                            }
                                        };
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                capeGettingChecked = false;
                                capeChecked = true;
                            }
                        }).start();
                    }
                } else {
                    this.capeLocation = PlayerEntityCache.getCape(this.playerName);
                    this.capeChecked = true;
                }
            }
            return this.capeLocation;
        }
    }

    public static class MenuPlayerRenderer
    extends LivingRenderer<MenuPlayerEntity, PlayerModel<MenuPlayerEntity>> {
        public MenuPlayerRenderer(boolean useSmallArms) {
            super(Minecraft.func_71410_x().func_175598_ae(), (EntityModel)new PlayerModel(0.0f, useSmallArms), 0.5f);
            this.func_177094_a((LayerRenderer)new BipedArmorLayer((IEntityRenderer)this, new BipedModel(0.5f), new BipedModel(1.0f)));
            this.func_177094_a(new MenuPlayerCapeLayer((IEntityRenderer<MenuPlayerEntity, PlayerModel<MenuPlayerEntity>>)this));
            this.func_177094_a((LayerRenderer)new HeadLayer((IEntityRenderer)this));
            this.func_177094_a(new MenuPlayerParrotLayer((IEntityRenderer<MenuPlayerEntity, PlayerModel<MenuPlayerEntity>>)this));
        }

        public void render(MenuPlayerEntity entityIn, float entityYaw, float partialTicks, MatrixStack matrixStackIn, IRenderTypeBuffer bufferIn, int packedLightIn) {
            this.setModelVisibilities(entityIn);
            super.func_225623_a_((LivingEntity)entityIn, entityYaw, partialTicks, matrixStackIn, bufferIn, packedLightIn);
        }

        public Vector3d getRenderOffset(MenuPlayerEntity entityIn, float partialTicks) {
            return entityIn.func_213453_ef() ? new Vector3d(0.0, -0.125, 0.0) : super.func_225627_b_((Entity)entityIn, partialTicks);
        }

        private void setModelVisibilities(MenuPlayerEntity clientPlayer) {
            PlayerModel playermodel = (PlayerModel)this.func_217764_d();
            playermodel.func_178719_a(true);
            playermodel.field_178720_f.field_78806_j = true;
            playermodel.field_178730_v.field_78806_j = true;
            playermodel.field_178733_c.field_78806_j = true;
            playermodel.field_178731_d.field_78806_j = true;
            playermodel.field_178734_a.field_78806_j = true;
            playermodel.field_178732_b.field_78806_j = true;
            playermodel.field_228270_o_ = clientPlayer.func_213453_ef();
        }

        public ResourceLocation getTextureLocation(MenuPlayerEntity entity) {
            ResourceLocation l = entity.getSkin();
            if (l != null) {
                return l;
            }
            return DefaultPlayerSkin.func_177335_a();
        }

        protected boolean shouldShowName(MenuPlayerEntity entity) {
            return entity.showName && entity.func_145748_c_() != null;
        }

        protected void renderNameTag(MenuPlayerEntity playerEntity, ITextComponent displayNameIn, MatrixStack matrix, IRenderTypeBuffer bufferIn, int packedLightIn) {
            if (playerEntity.showName) {
                boolean flag = !playerEntity.func_226273_bm_();
                float f = playerEntity.func_213302_cg() + 0.5f;
                matrix.func_227860_a_();
                matrix.func_227861_a_(0.0, (double)f, 0.0);
                matrix.func_227863_a_(new Quaternion(0.0f, 0.0f, 0.0f, 0.0f));
                matrix.func_227862_a_(-0.025f, -0.025f, 0.025f);
                Matrix4f matrix4f = matrix.func_227866_c_().func_227870_a_();
                float f1 = Minecraft.func_71410_x().field_71474_y.func_216840_a(0.25f);
                int j = (int)(f1 * 255.0f) << 24;
                FontRenderer fontrenderer = this.func_76983_a();
                float f2 = -fontrenderer.func_238414_a_((ITextProperties)displayNameIn) / 2;
                fontrenderer.func_243247_a(displayNameIn, f2, 0.0f, 0x20FFFFFF, false, matrix4f, bufferIn, flag, j, packedLightIn);
                if (flag) {
                    fontrenderer.func_243247_a(displayNameIn, f2, 0.0f, -1, false, matrix4f, bufferIn, false, 0, packedLightIn);
                }
                matrix.func_227865_b_();
            }
        }

        protected void scale(MenuPlayerEntity entitylivingbaseIn, MatrixStack matrixStackIn, float partialTickTime) {
            matrixStackIn.func_227862_a_(0.9375f, 0.9375f, 0.9375f);
        }

        protected void setupRotations(MenuPlayerEntity entityLiving, MatrixStack matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
            float f = entityLiving.func_205015_b(partialTicks);
            if (entityLiving.func_184613_cA()) {
                super.func_225621_a_((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
                float f1 = (float)entityLiving.func_184599_cB() + partialTicks;
                float f2 = MathHelper.func_76131_a((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
                if (!entityLiving.func_204805_cN()) {
                    matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f2 * (-90.0f - entityLiving.field_70125_A)));
                }
                Vector3d vector3d = entityLiving.func_70676_i(partialTicks);
                Vector3d vector3d1 = entityLiving.func_213322_ci();
                double d0 = Entity.func_213296_b((Vector3d)vector3d1);
                double d1 = Entity.func_213296_b((Vector3d)vector3d);
                if (d0 > 0.0 && d1 > 0.0) {
                    double d2 = (vector3d1.field_72450_a * vector3d.field_72450_a + vector3d1.field_72449_c * vector3d.field_72449_c) / Math.sqrt(d0 * d1);
                    double d3 = vector3d1.field_72450_a * vector3d.field_72449_c - vector3d1.field_72449_c * vector3d.field_72450_a;
                    matrixStackIn.func_227863_a_(Vector3f.field_229181_d_.func_229193_c_((float)(Math.signum(d3) * Math.acos(d2))));
                }
            } else if (f > 0.0f) {
                super.func_225621_a_((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
                float f3 = entityLiving.func_70090_H() ? -90.0f - entityLiving.field_70125_A : -90.0f;
                float f4 = MathHelper.func_219799_g((float)f, (float)0.0f, (float)f3);
                matrixStackIn.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(f4));
                if (entityLiving.func_213314_bj()) {
                    matrixStackIn.func_227861_a_(0.0, -1.0, (double)0.3f);
                }
            } else {
                super.func_225621_a_((LivingEntity)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
            }
        }
    }
}

