/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.loadingrequirement.v2.internal;

import de.keksuccino.fancymenu.menu.loadingrequirement.v2.internal.LoadingRequirementContainer;
import de.keksuccino.fancymenu.menu.loadingrequirement.v2.internal.LoadingRequirementInstance;
import de.keksuccino.konkrete.properties.PropertiesSection;
import java.util.ArrayList;
import java.util.List;

public class LoadingRequirementGroup {
    public LoadingRequirementContainer parent;
    public String identifier;
    public GroupMode mode;
    protected final List<LoadingRequirementInstance> instances = new ArrayList<LoadingRequirementInstance>();

    public LoadingRequirementGroup(String identifier, GroupMode mode, LoadingRequirementContainer parent) {
        this.parent = parent;
        this.identifier = identifier;
        this.mode = mode;
    }

    public boolean requirementsMet() {
        for (LoadingRequirementInstance i : this.instances) {
            boolean met = i.requirementMet();
            if (met && this.mode == GroupMode.OR) {
                return true;
            }
            if (met || this.mode != GroupMode.AND) continue;
            return false;
        }
        return this.mode != GroupMode.OR;
    }

    public void addInstance(LoadingRequirementInstance instance) {
        if (!this.instances.contains(instance)) {
            this.instances.add(instance);
        }
        instance.group = this;
    }

    public LoadingRequirementInstance removeInstance(LoadingRequirementInstance instance) {
        instance.group = null;
        return this.instances.remove(instance) ? instance : null;
    }

    public List<LoadingRequirementInstance> getInstances() {
        return new ArrayList<LoadingRequirementInstance>(this.instances);
    }

    public static PropertiesSection serializeRequirementGroup(LoadingRequirementGroup group) {
        PropertiesSection sec = new PropertiesSection("requirement_group");
        String key = "[loading_requirement_group:" + group.identifier + "]";
        String value = "[group_mode:" + group.mode.name + "]";
        sec.addEntry(key, value);
        for (LoadingRequirementInstance i : group.instances) {
            i.group = group;
            List<String> l = LoadingRequirementInstance.serializeRequirementInstance(i);
            sec.addEntry(l.get(0), l.get(1));
        }
        return sec;
    }

    public static LoadingRequirementGroup deserializeRequirementGroup(String key, String value, LoadingRequirementContainer parent) {
        if (key.startsWith("[loading_requirement_group:")) {
            String modeString;
            GroupMode mode;
            String groupId = key.split("\\[loading_requirement_group:", 2)[1].split("\\]", 2)[0];
            if (value.startsWith("[group_mode:") && (mode = GroupMode.getByName(modeString = value.split("\\[group_mode:", 2)[1].split("\\]", 2)[0])) != null) {
                return new LoadingRequirementGroup(groupId, mode, parent);
            }
        }
        return null;
    }

    public static enum GroupMode {
        AND("and"),
        OR("or");

        public final String name;

        private GroupMode(String name) {
            this.name = name;
        }

        public static GroupMode getByName(String name) {
            for (GroupMode m : GroupMode.values()) {
                if (!m.name.equals(name)) continue;
                return m;
            }
            return null;
        }
    }
}

