/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.placeholder.v2.placeholders.advanced;

import de.keksuccino.fancymenu.menu.placeholder.v2.DeserializedPlaceholderString;
import de.keksuccino.fancymenu.menu.placeholder.v2.Placeholder;
import de.keksuccino.fancymenu.menu.placeholder.v2.PlaceholderParser;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.localization.Locals;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Nonnull;

public class StringifyPlaceholder
extends Placeholder {
    public StringifyPlaceholder() {
        super("stringify");
    }

    @Override
    public String getReplacementFor(DeserializedPlaceholderString dps) {
        String text = dps.values.get("text");
        if (text != null) {
            text = PlaceholderParser.replacePlaceholders(text);
            return text.replace("\"", "\\\"").replace("{", "\\{").replace("}", "\\}");
        }
        return null;
    }

    @Override
    public List<String> getValueNames() {
        ArrayList<String> l = new ArrayList<String>();
        l.add("text");
        return l;
    }

    @Override
    public String getDisplayName() {
        return Locals.localize((String)"fancymenu.helper.placeholder.stringify", (String[])new String[0]);
    }

    @Override
    public List<String> getDescription() {
        return Arrays.asList(StringUtils.splitLines((String)Locals.localize((String)"fancymenu.helper.placeholder.stringify.desc", (String[])new String[0]), (String)"%n%"));
    }

    @Override
    public String getCategory() {
        return Locals.localize((String)"fancymenu.helper.ui.dynamicvariabletextfield.categories.advanced", (String[])new String[0]);
    }

    @Override
    @Nonnull
    public DeserializedPlaceholderString getDefaultPlaceholderString() {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put("text", "text to stringify");
        return DeserializedPlaceholderString.build(this.getIdentifier(), m);
    }
}

