/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.abstractions.sources;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import org.zeith.hammerlib.abstractions.sources.EntitySourceType;
import org.zeith.hammerlib.abstractions.sources.IObjectSourceType;
import org.zeith.hammerlib.abstractions.sources.TileSourceType;
import org.zeith.hammerlib.core.RegistriesHL;
import org.zeith.hammerlib.util.java.Cast;

public interface IObjectSource<T> {
    public CompoundNBT writeSource();

    public IObjectSourceType getType();

    public Class<T> getBaseType();

    public T get(World var1);

    default public <R> Optional<R> get(Class<R> base, World level) {
        return Cast.optionally(this.get(level), base);
    }

    public static Supplier<EntitySourceType.EntitySource> ofEntity(@Nonnull Entity entity) {
        return () -> new EntitySourceType.EntitySource(entity.func_145782_y());
    }

    public static Supplier<TileSourceType.TileSource> ofTile(@Nonnull TileEntity tile) {
        return () -> new TileSourceType.TileSource(tile.func_174877_v());
    }

    public static CompoundNBT writeSource(IObjectSource<?> src) {
        CompoundNBT tag = new CompoundNBT();
        tag.func_218657_a("Src", (INBT)src.writeSource());
        tag.func_74778_a("Type", Objects.toString(src.getType().getRegistryKey()));
        return tag;
    }

    public static Optional<IObjectSource<?>> readSource(@Nullable CompoundNBT tag) {
        if (tag == null) {
            return Optional.empty();
        }
        IObjectSourceType type = (IObjectSourceType)RegistriesHL.animationSources().getValue(new ResourceLocation(tag.func_74779_i("Type")));
        if (type == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(type.readSource(tag.func_74775_l("Src")));
    }
}

