/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.abstractions.sources;

import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import org.zeith.hammerlib.abstractions.sources.IObjectSource;
import org.zeith.hammerlib.abstractions.sources.IObjectSourceType;
import org.zeith.hammerlib.core.init.SourceTypesHL;
import org.zeith.hammerlib.util.java.Cast;

public class TileSourceType
extends IObjectSourceType {
    public IObjectSource<TileEntity> readSource(CompoundNBT tag) {
        return new TileSource(tag);
    }

    public static class TileSource
    implements IObjectSource<TileEntity> {
        public final BlockPos pos;

        public TileSource(BlockPos pos) {
            this.pos = pos;
        }

        public TileSource(CompoundNBT tag) {
            this.pos = new BlockPos(tag.func_74762_e("x"), tag.func_74762_e("y"), tag.func_74762_e("z"));
        }

        @Override
        public CompoundNBT writeSource() {
            CompoundNBT tag = new CompoundNBT();
            tag.func_74768_a("x", this.pos.func_177958_n());
            tag.func_74768_a("y", this.pos.func_177956_o());
            tag.func_74768_a("z", this.pos.func_177952_p());
            return tag;
        }

        @Override
        public IObjectSourceType getType() {
            return SourceTypesHL.TILE_TYPE;
        }

        @Override
        public Class<TileEntity> getBaseType() {
            return TileEntity.class;
        }

        @Override
        public TileEntity get(World world) {
            return Cast.cast(world.func_175625_s(this.pos), TileEntity.class);
        }
    }
}

