/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.event.LanguageReloadEvent;
import org.zeith.hammerlib.util.SidedLocal;

public class LanguageHelper {
    private static final Function<String, LangMap> MAP_FACTORY = LangMap::new;
    private static final SidedLocal<String> PREV_LANGS = new SidedLocal();
    public static final Map<String, LangMap> LANGS = new HashMap<String, LangMap>();

    public static LangMap getMap(String lang) {
        return LANGS.computeIfAbsent(lang.toLowerCase(), MAP_FACTORY);
    }

    public static void reloadLanguage() {
        String lng = HammerLib.PROXY.getLanguage();
        ArrayList<String> langs = new ArrayList<String>();
        langs.add("en_us");
        if (!langs.contains(lng)) {
            langs.add(lng);
        }
        PREV_LANGS.set(lng);
        LangMap exist = LANGS.get(lng);
        if (exist == null) {
            exist = MAP_FACTORY.apply(lng);
            for (String lang : langs) {
                MinecraftForge.EVENT_BUS.post((Event)new LanguageReloadEvent(exist, lang));
            }
            if (!exist.isEmpty()) {
                LANGS.put(lng, exist);
            }
        } else {
            for (String lang : langs) {
                MinecraftForge.EVENT_BUS.post((Event)new LanguageReloadEvent(exist, lang));
            }
        }
    }

    public static void update() {
        LangMap map;
        String lng = HammerLib.PROXY.getLanguage();
        if (!PREV_LANGS.equalsTo(lng)) {
            LanguageHelper.reloadLanguage();
        }
        if (LANGS.containsKey(lng) && (map = LANGS.get(lng)).isDirty()) {
            HammerLib.PROXY.applyLang(map);
            map.setDirty(false);
        }
    }

    public static String getLanguage(PlayerEntity player) {
        return HammerLib.PROXY.getLanguage(player);
    }

    public static class LangMap
    extends HashMap<String, String> {
        final String lang;
        boolean dirty;

        public LangMap(String lng) {
            this.lang = lng;
        }

        public void translate(String key, String value) {
            this.put(key, value);
            this.dirty = true;
        }

        public boolean isDirty() {
            return this.dirty;
        }

        public void setDirty(boolean dirty) {
            this.dirty = dirty;
        }

        public void apply(Map<String, String> langs) {
            langs.putAll(this);
        }
    }
}

