/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.crafting.impl;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidStack;
import org.zeith.hammerlib.api.crafting.IBaseIngredient;
import org.zeith.hammerlib.api.crafting.ICraftingResult;
import org.zeith.hammerlib.api.crafting.INameableRecipe;
import org.zeith.hammerlib.api.crafting.impl.EnergyIngredient;
import org.zeith.hammerlib.api.crafting.impl.FluidStackIngredient;
import org.zeith.hammerlib.api.crafting.impl.FluidStackResult;
import org.zeith.hammerlib.api.crafting.impl.ForgeEnergyResult;
import org.zeith.hammerlib.api.crafting.impl.ItemStackResult;
import org.zeith.hammerlib.api.crafting.impl.MCIngredient;
import org.zeith.hammerlib.api.energy.EnergyUnit;
import org.zeith.hammerlib.core.RecipeHelper;
import org.zeith.hammerlib.util.charging.fe.FECharge;

public class BaseNameableRecipe
implements INameableRecipe {
    public final ResourceLocation id;
    public final ICraftingResult<?> output;
    public final NonNullList<IBaseIngredient> ingredients;

    public BaseNameableRecipe(ResourceLocation id, ICraftingResult<?> output, NonNullList<IBaseIngredient> ingredients) {
        this.id = id;
        this.output = output;
        this.ingredients = ingredients;
    }

    @Override
    public ResourceLocation getRecipeName() {
        return this.id;
    }

    @Override
    public NonNullList<IBaseIngredient> getIngredients() {
        return this.ingredients;
    }

    @Override
    public ICraftingResult<?> getResult() {
        return this.output;
    }

    public static Builder builder(ResourceLocation id) {
        return new Builder(id);
    }

    public static class Builder {
        private final ResourceLocation id;
        private final NonNullList<Ingredient> inputItems = NonNullList.func_191196_a();
        private final NonNullList<FluidStack> inputFluid = NonNullList.func_191196_a();
        private ICraftingResult<?> output;
        private double RF;

        public Builder(ResourceLocation id) {
            if (id == null) {
                throw new IllegalArgumentException("Recipe id must not be null!");
            }
            this.id = id;
        }

        public Builder addInput(Ingredient ing) {
            this.inputItems.add((Object)ing);
            return this;
        }

        public Builder addInput(ITag.INamedTag<Item> tag) {
            this.inputItems.add((Object)RecipeHelper.fromTag(tag));
            return this;
        }

        public Builder addInput(FluidStack stack) {
            this.inputFluid.add((Object)stack);
            return this;
        }

        public Builder setEnergy(double amount, EnergyUnit unit) {
            this.RF = unit.getInFE(amount);
            return this;
        }

        public Builder addEnergy(double amount, EnergyUnit unit) {
            this.RF += unit.getInFE(amount);
            return this;
        }

        public Builder withOutput(ItemStack stack) {
            this.output = new ItemStackResult(stack);
            return this;
        }

        public Builder withOutput(FluidStack stack) {
            this.output = new FluidStackResult(stack);
            return this;
        }

        public Builder withOutput(int FE) {
            this.output = new ForgeEnergyResult(new FECharge(FE));
            return this;
        }

        public Builder withOutput(ICraftingResult<?> stack) {
            this.output = stack;
            return this;
        }

        public double getEnergy(EnergyUnit unit) {
            return unit.getFromFE(this.RF);
        }

        public BaseNameableRecipe build() {
            NonNullList ings = NonNullList.func_191196_a();
            if (this.RF > 0.0) {
                ings.add((Object)new EnergyIngredient(this.RF, EnergyUnit.RF));
            }
            for (FluidStack stack : this.inputFluid) {
                ings.add((Object)new FluidStackIngredient(stack));
            }
            for (Ingredient ing : this.inputItems) {
                ings.add((Object)new MCIngredient(ing));
            }
            return new BaseNameableRecipe(this.id, this.output, (NonNullList<IBaseIngredient>)ings);
        }
    }
}

