/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.energy;

import java.util.HashMap;
import java.util.Map;

public class EnergyUnit {
    public static final EnergyUnit RF = EnergyUnit.getUnit("rf", 1.0);
    public static final EnergyUnit FE = EnergyUnit.getUnit("fe", 1.0);
    public static final EnergyUnit TESLA = EnergyUnit.getUnit("tesla", 1.0);
    public static final EnergyUnit EU = EnergyUnit.getUnit("eu", 4.0);
    public static final EnergyUnit EMC = EnergyUnit.getUnit("emc", 125.0);
    private static final Map<String, EnergyUnit> UNITS = new HashMap<String, EnergyUnit>();
    public final double toFE;

    public static EnergyUnit getUnit(String id, double toFE) {
        if (UNITS.containsKey(id)) {
            return UNITS.get(id);
        }
        return new EnergyUnit(id, toFE);
    }

    public EnergyUnit(String id, double toFE) {
        UNITS.put(id, this);
        this.toFE = toFE;
    }

    public double getInFE(double x) {
        return x * this.toFE;
    }

    public double getFromFE(double fe) {
        return fe / this.toFE;
    }

    public double convertTo(double x, EnergyUnit targetUnit) {
        return targetUnit.getFromFE(this.getInFE(x));
    }

    public double convertFrom(double x, EnergyUnit sourceUnit) {
        return sourceUnit.convertTo(x, this);
    }
}

