/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.inv;

import java.nio.ByteBuffer;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.IContainerListener;
import org.jetbrains.annotations.Nullable;
import org.zeith.hammerlib.mixins.ContainerAccessor;
import org.zeith.hammerlib.net.packets.SendPropertiesPacket;
import org.zeith.hammerlib.net.properties.PropertyDispatcher;
import org.zeith.hammerlib.util.java.Cast;

public class ComplexProgressManager
extends PropertyDispatcher {
    static final ThreadLocal<ByteBuffer> buffers2 = ThreadLocal.withInitial(() -> ByteBuffer.allocate(2));
    static final ThreadLocal<ByteBuffer> buffers4 = ThreadLocal.withInitial(() -> ByteBuffer.allocate(4));
    static final ThreadLocal<ByteBuffer> buffers8 = ThreadLocal.withInitial(() -> ByteBuffer.allocate(8));
    byte[] buffer;
    byte[] previousBuffer;
    final int startIndex;

    public ComplexProgressManager(int size, int startIndex) {
        super(Cast.constant(null), () -> {});
        this.buffer = new byte[size];
        this.previousBuffer = new byte[size];
        this.startIndex = startIndex;
    }

    public void detectAndSendChanges(Container owner) {
        this.detectAndSendChanges(owner, ((ContainerAccessor)owner).getContainerListeners());
    }

    public void detectAndSendChanges(Container owner, List<IContainerListener> listeners) {
        this.detectAndSendChanges((Integer i, Byte s) -> {
            for (IContainerListener j : listeners) {
                j.func_71112_a(owner, i.intValue(), (int)s.byteValue());
            }
        });
    }

    public void detectAndSendChanges(BiConsumer<Integer, Byte> propertySender) {
        for (int i = 0; i < this.buffer.length; ++i) {
            if (this.buffer[i] == this.previousBuffer[i]) continue;
            propertySender.accept(this.startIndex + i, this.buffer[i]);
            this.previousBuffer[i] = this.buffer[i];
        }
    }

    public void updateChange(int id, int data) {
        if ((id -= this.startIndex) >= this.buffer.length) {
            this.growBuffer(id + 1);
        }
        if (id >= 0) {
            this.buffer[id] = (byte)data;
        }
    }

    public void putBoolean(int bytePos, boolean value) {
        this.putByte(bytePos, (byte)(value ? 1 : 0));
    }

    public boolean getBoolean(int bytePos) {
        return this.buffer[bytePos] > 0;
    }

    public void putByte(int bytePos, byte value) {
        this.buffer[bytePos] = value;
    }

    public byte getByte(int bytePos) {
        return this.buffer[bytePos];
    }

    public void putShort(int bytePos, short value) {
        ByteBuffer buf = buffers2.get();
        buf.position(0);
        buf.putShort(value);
        buf.flip();
        buf.get(this.buffer, bytePos, 2);
    }

    public short getShort(int bytePos) {
        ByteBuffer buf = buffers2.get();
        buf.position(0);
        buf.put(this.buffer, bytePos, 2);
        buf.flip();
        return buf.getShort();
    }

    public void putInt(int bytePos, int value) {
        ByteBuffer buf = buffers4.get();
        buf.position(0);
        buf.putInt(value);
        buf.flip();
        buf.get(this.buffer, bytePos, 4);
    }

    public int getInt(int bytePos) {
        ByteBuffer buf = buffers4.get();
        buf.position(0);
        buf.put(this.buffer, bytePos, 4);
        buf.flip();
        return buf.getInt();
    }

    public void putFloat(int bytePos, float value) {
        ByteBuffer buf = buffers4.get();
        buf.position(0);
        buf.putFloat(value);
        buf.flip();
        buf.get(this.buffer, bytePos, 4);
    }

    public float getFloat(int bytePos) {
        ByteBuffer buf = buffers4.get();
        buf.position(0);
        buf.put(this.buffer, bytePos, 4);
        buf.flip();
        return buf.getFloat();
    }

    public void putLong(int bytePos, long value) {
        ByteBuffer buf = buffers8.get();
        buf.position(0);
        buf.putLong(value);
        buf.flip();
        buf.get(this.buffer, bytePos, 8);
    }

    public long getLong(int bytePos) {
        ByteBuffer buf = buffers8.get();
        buf.position(0);
        buf.put(this.buffer, bytePos, 8);
        buf.flip();
        return buf.getLong();
    }

    public void putDouble(int bytePos, double value) {
        ByteBuffer buf = buffers8.get();
        buf.position(0);
        buf.putDouble(value);
        buf.flip();
        buf.get(this.buffer, bytePos, 8);
    }

    public double getDouble(int bytePos) {
        ByteBuffer buf = buffers8.get();
        buf.position(0);
        buf.put(this.buffer, bytePos, 8);
        buf.flip();
        return buf.getDouble();
    }

    private void growBuffer(int targetSize) {
        byte[] newArray;
        if (this.buffer.length < targetSize) {
            newArray = new byte[targetSize];
            System.arraycopy(this.buffer, 0, newArray, 0, this.buffer.length);
            this.buffer = newArray;
        }
        if (this.previousBuffer.length < targetSize) {
            newArray = new byte[targetSize];
            System.arraycopy(this.previousBuffer, 0, newArray, 0, this.previousBuffer.length);
            this.previousBuffer = newArray;
        }
    }

    public void putBytes(int bytePos, byte[] array) {
        if (bytePos + array.length > this.buffer.length) {
            this.growBuffer(bytePos + array.length);
        }
        System.arraycopy(array, 0, this.buffer, bytePos, array.length);
    }

    public void putBytes(int bytePos, byte[] array, int off, int len) {
        if (bytePos + len > this.buffer.length) {
            this.growBuffer(bytePos + array.length);
        }
        System.arraycopy(array, off, this.buffer, bytePos, len);
    }

    public byte[] getBytes(int bytePos, int length) {
        if (bytePos == 0 && length == this.buffer.length) {
            return this.buffer;
        }
        byte[] nb = new byte[Math.min(length, this.buffer.length - bytePos)];
        System.arraycopy(this.buffer, bytePos, nb, 0, nb.length);
        return nb;
    }

    public int getSize() {
        return this.buffer.length;
    }

    public byte[] getBytes() {
        return this.buffer;
    }

    @Override
    @Nullable
    public SendPropertiesPacket detectAndGenerateChanges(boolean cleanse) {
        return null;
    }

    @Override
    @Nullable
    public SendPropertiesPacket createGlobalUpdate() {
        return null;
    }
}

