/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.io;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.nio.charset.StandardCharsets;
import java.util.List;
import net.minecraft.nbt.ByteArrayNBT;
import net.minecraft.nbt.ByteNBT;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.DoubleNBT;
import net.minecraft.nbt.FloatNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.IntNBT;
import net.minecraft.nbt.LongNBT;
import net.minecraft.nbt.ShortNBT;
import net.minecraftforge.common.util.INBTSerializable;
import net.minecraftforge.fml.unsafe.UnsafeHacks;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.Type;
import org.zeith.hammerlib.api.io.NBTSerializable;
import org.zeith.hammerlib.api.io.NBTSerializer;
import org.zeith.hammerlib.api.io.serializers.BooleanSerializer;
import org.zeith.hammerlib.api.io.serializers.EnumNBTSerializer;
import org.zeith.hammerlib.api.io.serializers.INBTSerializer;
import org.zeith.hammerlib.api.io.serializers.NumberSerializer;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.ReflectionUtil;
import org.zeith.hammerlib.util.mcf.ScanDataHelper;

public class NBTSerializationHelper {
    public static final Logger LOG = LogManager.getLogger((String)"HammerLib");
    private static final BiMap<Class<?>, INBTSerializer<?>> SERIALIZER_MAP = HashBiMap.create();
    private static final BiMap<Class<?>, INBTSerializer<?>> ENUM_SERIALIZER_MAP = HashBiMap.create();

    public static <T extends Enum<T>> INBTSerializer<T> forEnum(Class<T> type) {
        return (INBTSerializer)Cast.cast(ENUM_SERIALIZER_MAP.computeIfAbsent(type, t -> new EnumNBTSerializer(type)));
    }

    public static <T> void registerSerializer(Class<T> type, INBTSerializer<T> serializer) {
        SERIALIZER_MAP.putIfAbsent(type, serializer);
    }

    public static void construct() {
        NBTSerializationHelper.registerSerializer(Boolean.class, new BooleanSerializer());
        NBTSerializationHelper.registerSerializer(Byte.class, new NumberSerializer<Byte, ByteNBT>(1, ByteNBT::func_229671_a_, ByteNBT::func_150290_f));
        NBTSerializationHelper.registerSerializer(Short.class, new NumberSerializer<Short, ShortNBT>(2, ShortNBT::func_229701_a_, ShortNBT::func_150289_e));
        NBTSerializationHelper.registerSerializer(Float.class, new NumberSerializer<Float, FloatNBT>(5, FloatNBT::func_229689_a_, FloatNBT::func_150288_h));
        NBTSerializationHelper.registerSerializer(Double.class, new NumberSerializer<Double, DoubleNBT>(6, DoubleNBT::func_229684_a_, DoubleNBT::func_150286_g));
        NBTSerializationHelper.registerSerializer(Integer.class, new NumberSerializer<Integer, IntNBT>(3, IntNBT::func_229692_a_, IntNBT::func_150287_d));
        NBTSerializationHelper.registerSerializer(Long.class, new NumberSerializer<Long, LongNBT>(4, LongNBT::func_229698_a_, LongNBT::func_150291_c));
        NBTSerializationHelper.registerSerializer(Boolean.TYPE, new BooleanSerializer());
        NBTSerializationHelper.registerSerializer(Byte.TYPE, new NumberSerializer<Byte, ByteNBT>(1, ByteNBT::func_229671_a_, ByteNBT::func_150290_f));
        NBTSerializationHelper.registerSerializer(Short.TYPE, new NumberSerializer<Short, ShortNBT>(2, ShortNBT::func_229701_a_, ShortNBT::func_150289_e));
        NBTSerializationHelper.registerSerializer(Float.TYPE, new NumberSerializer<Float, FloatNBT>(5, FloatNBT::func_229689_a_, FloatNBT::func_150288_h));
        NBTSerializationHelper.registerSerializer(Double.TYPE, new NumberSerializer<Double, DoubleNBT>(6, DoubleNBT::func_229684_a_, DoubleNBT::func_150286_g));
        NBTSerializationHelper.registerSerializer(Integer.TYPE, new NumberSerializer<Integer, IntNBT>(3, IntNBT::func_229692_a_, IntNBT::func_150287_d));
        NBTSerializationHelper.registerSerializer(Long.TYPE, new NumberSerializer<Long, LongNBT>(4, LongNBT::func_229698_a_, LongNBT::func_150291_c));
        NBTSerializationHelper.registerSerializer(BigInteger.class, new NumberSerializer<BigInteger, ByteArrayNBT>(7, b -> new ByteArrayNBT(b.toByteArray()), nbt -> new BigInteger(nbt.func_150292_c())));
        NBTSerializationHelper.registerSerializer(BigDecimal.class, new NumberSerializer<BigDecimal, ByteArrayNBT>(7, b -> new ByteArrayNBT(b.toString().getBytes(StandardCharsets.UTF_8)), nbt -> new BigDecimal(new String(nbt.func_150292_c(), StandardCharsets.UTF_8))));
        ScanDataHelper.lookupAnnotatedObjects(NBTSerializer.class).forEach(data -> data.getProperty("value").map(List.class::cast).ifPresent(ts -> {
            List types = ts;
            INBTSerializer ser = (INBTSerializer)Cast.cast(UnsafeHacks.newInstance(data.getOwnerClass()));
            for (Type type : types) {
                Class<?> c = ReflectionUtil.fetchClassAny(type);
                if (c != null) {
                    SERIALIZER_MAP.putIfAbsent(c, (Object)ser);
                    LOG.debug("Registered NBT serializer for type " + c + ": " + ser);
                    continue;
                }
                LOG.error("Unable to find class " + type.getInternalName() + "!");
            }
        }));
    }

    public static void serializeField(Class<?> type, Object instance, CompoundNBT nbt, String key) {
        INBTSerializer serializer = type.isEnum() ? NBTSerializationHelper.forEnum((Class)Cast.cast(type)) : (INBTSerializer)SERIALIZER_MAP.get(type);
        if (serializer != null) {
            serializer.serialize(nbt, key, Cast.cast(instance));
        } else if (type.isArray()) {
            if (instance != null) {
                CompoundNBT lst = new CompoundNBT();
                Class<?> compType = type.getComponentType();
                int length = Array.getLength(instance);
                for (int i = 0; i < length; ++i) {
                    Object component = Array.get(instance, i);
                    NBTSerializationHelper.serializeField(compType, component, lst, Integer.toString(i));
                }
                nbt.func_218657_a(key, (INBT)lst);
            }
        } else {
            LOG.warn("Don't know how to serialize " + type + " " + key + " in " + type);
        }
    }

    public static Object deserializeField(Class<?> type, CompoundNBT nbt, String key) {
        INBTSerializer serializer = type.isEnum() ? NBTSerializationHelper.forEnum((Class)Cast.cast(type)) : (INBTSerializer)SERIALIZER_MAP.get(type);
        if (serializer != null) {
            return serializer.deserialize(nbt, key);
        }
        if (type.isArray()) {
            if (nbt.func_150297_b(key, 10)) {
                CompoundNBT lst = nbt.func_74775_l(key);
                Class<?> compType = type.getComponentType();
                int length = lst.func_186856_d();
                Object instance = Array.newInstance(compType, length);
                for (int i = 0; i < length; ++i) {
                    Array.set(instance, i, NBTSerializationHelper.deserializeField(compType, lst, Integer.toString(i)));
                }
                return instance;
            }
            return null;
        }
        LOG.warn("Don't know how to deserialize " + type + " " + key + " in " + type);
        return null;
    }

    public static CompoundNBT serialize(Object instance) {
        Class<?> type = instance.getClass();
        CompoundNBT nbt = new CompoundNBT();
        for (Field field : ReflectionUtil.getFieldsUpTo(type, null)) {
            field.setAccessible(true);
            NBTSerializable nbts = field.getAnnotation(NBTSerializable.class);
            if (nbts == null) continue;
            String name = nbts.value();
            if (name.trim().isEmpty()) {
                name = field.getName();
            }
            try {
                if (Modifier.isFinal(field.getModifiers())) {
                    if (INBTSerializable.class.isAssignableFrom(field.getType())) {
                        INBTSerializable s = (INBTSerializable)field.get(instance);
                        if (s == null) continue;
                        nbt.func_218657_a(name, s.serializeNBT());
                        continue;
                    }
                    LOG.warn("Don't know how to serialize " + field + " in " + type);
                    continue;
                }
                NBTSerializationHelper.serializeField(field.getType(), field.get(instance), nbt, name);
            }
            catch (ReflectiveOperationException e) {
                LOG.error("Failed to serialize field " + field + " in " + type);
            }
        }
        return nbt;
    }

    public static void deserialize(Object instance, CompoundNBT nbt) {
        Class<?> type = instance.getClass();
        for (Field field : ReflectionUtil.getFieldsUpTo(type, null)) {
            field.setAccessible(true);
            NBTSerializable nbts = field.getAnnotation(NBTSerializable.class);
            if (nbts == null) continue;
            String name = nbts.value();
            if (name.trim().isEmpty()) {
                name = field.getName();
            }
            try {
                if (Modifier.isFinal(field.getModifiers())) {
                    if (INBTSerializable.class.isAssignableFrom(field.getType())) {
                        INBTSerializable s = (INBTSerializable)field.get(instance);
                        if (s == null) continue;
                        s.deserializeNBT(nbt.func_74781_a(name));
                        continue;
                    }
                    LOG.warn("Don't know how to deserialize " + field + " in " + type);
                    continue;
                }
                Object val = NBTSerializationHelper.deserializeField(field.getType(), nbt, name);
                if (val == null && field.getType().isPrimitive()) continue;
                field.set(instance, val);
            }
            catch (Throwable e) {
                LOG.error("Failed to deserialize field " + field + " in " + type);
            }
        }
    }
}

