/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.api.io.serializers;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.NBTDynamicOps;
import org.jetbrains.annotations.NotNull;
import org.zeith.hammerlib.api.io.serializers.INBTSerializer;

public class BaseCodecSerializer<T>
implements INBTSerializer<T> {
    protected final Codec<T> codec;
    protected final Supplier<T> defaultValue;

    public BaseCodecSerializer(Codec<T> codec, Supplier<T> defaultValue) {
        this.codec = codec;
        this.defaultValue = defaultValue;
    }

    @Override
    public void serialize(CompoundNBT nbt, String key, @NotNull T value) {
        this.codec.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, value).result().ifPresent(tag -> nbt.func_218657_a(key, tag));
    }

    @Override
    public T deserialize(CompoundNBT nbt, String key) {
        INBT tag = nbt.func_74781_a(key);
        if (tag != null) {
            return (T)this.codec.decode((DynamicOps)NBTDynamicOps.field_210820_a, (Object)tag).result().map(Pair::getFirst).orElseGet(this.defaultValue);
        }
        return this.defaultValue.get();
    }
}

