/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core;

import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.item.crafting.RecipeManager;
import net.minecraft.resources.IFutureReloadListener;
import net.minecraft.resources.IReloadableResourceManager;
import net.minecraft.tags.ITag;
import net.minecraft.tags.TagCollectionManager;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.api.crafting.AbstractRecipeRegistry;
import org.zeith.hammerlib.api.items.IIngredientProvider;
import org.zeith.hammerlib.core.adapter.OreDictionaryAdapter;
import org.zeith.hammerlib.event.ParseIngredientEvent;
import org.zeith.hammerlib.event.recipe.RegisterRecipesEvent;
import org.zeith.hammerlib.proxy.HLConstants;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.mcf.RunnableReloader;

public class RecipeHelper {
    public static void registerCustomRecipes(Predicate<ResourceLocation> idInUse, Consumer<IRecipe<?>> addRecipe, boolean silent, Consumer<Set<ResourceLocation>> removeRecipes) {
        RegisterRecipesEvent rre = new RegisterRecipesEvent(idInUse);
        MinecraftForge.EVENT_BUS.post((Event)rre);
        rre.cleanup();
        if (!silent) {
            HLConstants.LOG.info("Reloading HammerLib recipes...");
        }
        AtomicLong count = new AtomicLong();
        rre.getRecipes().forEach(recipe -> {
            addRecipe.accept((IRecipe<?>)recipe);
            count.incrementAndGet();
        });
        removeRecipes.accept(rre.removedRecipes());
        if (!silent) {
            HLConstants.LOG.info("HammerLib injected {} recipes into recipe map. Removed {} recipes from the game.", (Object)count.longValue(), (Object)rre.removedRecipes().size());
        }
        List<AbstractRecipeRegistry<?, ?, ?>> registries = AbstractRecipeRegistry.getAllRegistries();
        if (!silent) {
            HLConstants.LOG.info("Reloading {} custom registries.", (Object)registries.size());
        }
        registries.forEach(AbstractRecipeRegistry::reload);
        if (!silent) {
            HLConstants.LOG.info("{} custom registries reloaded, added {} total recipes.", (Object)registries.size(), (Object)registries.stream().mapToInt(AbstractRecipeRegistry::getRecipeCount).sum());
        }
    }

    public static void reload(RecipeManager mgr, IReloadableResourceManager rel) {
        rel.func_219534_a((IFutureReloadListener)RunnableReloader.of(() -> {
            Internal.mutableManager(mgr);
            HashSet removeRecipes = new HashSet();
            ArrayList recipeList = new ArrayList();
            RecipeHelper.registerCustomRecipes(id -> mgr.func_215367_a(id).isPresent(), recipeList::add, false, removeRecipes::addAll);
            Internal.addRecipes(mgr, recipeList, removeRecipes);
        }));
    }

    public static Ingredient fromComponent(Object comp) {
        Ingredient ingr = Ingredient.field_193370_a;
        if (comp instanceof IItemProvider) {
            ingr = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{(IItemProvider)comp});
        } else if (comp instanceof IIngredientProvider) {
            ingr = ((IIngredientProvider)comp).asIngredient();
        } else if (comp instanceof ItemStack) {
            ingr = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{((ItemStack)comp).func_77946_l()});
        } else if (comp instanceof ITag.INamedTag) {
            ITag itag = TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(((ITag.INamedTag)comp).func_230234_a_());
            ingr = Ingredient.func_209357_a(Stream.of(new Ingredient.TagList(itag)));
        } else if (comp instanceof String || comp instanceof ResourceLocation) {
            String st = comp.toString();
            ingr = Ingredient.merge((Collection)OreDictionaryAdapter.get(st).stream().map(obj -> {
                if (obj != null) {
                    ResourceLocation odConv = Cast.cast(obj, ResourceLocation.class);
                    ResourceLocation tag = odConv != null ? odConv : new ResourceLocation(st.contains(":") ? st : "forge:" + st);
                    ITag itag = TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(tag);
                    return Ingredient.func_209357_a(Stream.of(new Ingredient.TagList(itag)));
                }
                return RecipeHelper.fromComponent(obj);
            }).filter(Objects::nonNull).collect(Collectors.toList()));
        } else if (comp instanceof ItemStack[]) {
            ItemStack[] items = (ItemStack[])((ItemStack[])comp).clone();
            for (int l = 0; l < items.length; ++l) {
                items[l] = items[l].func_77946_l();
            }
            ingr = Ingredient.func_193369_a((ItemStack[])items);
        } else if (comp instanceof Ingredient) {
            ingr = (Ingredient)comp;
        } else if (comp != null) {
            ParseIngredientEvent<Object> event = new ParseIngredientEvent<Object>(comp);
            MinecraftForge.EVENT_BUS.post(event);
            if (event.hasIngredient()) {
                ingr = event.getIngredient();
            }
        }
        return ingr;
    }

    public static Ingredient fromTag(ITag.INamedTag<Item> tag) {
        ITag itag = TagCollectionManager.func_242178_a().func_241836_b().func_199910_a(tag.func_230234_a_());
        return Ingredient.func_209357_a(Stream.of(new Ingredient.TagList(itag)));
    }

    public static enum MapMode {
        IMMUTABLE(ImmutableMap.Builder.class),
        MAP(Map.class),
        UNKNOWN(null);

        final Class<?> type;

        private MapMode(Class<?> type) {
            this.type = type;
        }

        public Consumer<IRecipe<?>> addRecipe(Map<IRecipeType<?>, ?> map) {
            if (this == IMMUTABLE) {
                Map imap = (Map)Cast.cast(map);
                return recipe -> {
                    ImmutableMap.Builder builder = imap.computeIfAbsent(recipe.func_222127_g(), type -> ImmutableMap.builder());
                    builder.put((Object)recipe.func_199560_c(), recipe);
                };
            }
            if (this == MAP) {
                Map mmap = (Map)Cast.cast(map);
                return recipe -> {
                    Map builder = mmap.computeIfAbsent(recipe.func_222127_g(), type -> new Object2ObjectLinkedOpenHashMap());
                    builder.put(recipe.func_199560_c(), recipe);
                };
            }
            return recipe -> HammerLib.LOG.warn("Unable to add recipe " + recipe.func_199560_c() + " due to the uncertainty of the recipe map!");
        }
    }

    private static class Internal {
        private Internal() {
        }

        private static void addRecipes(RecipeManager mgr, List<IRecipe<?>> recipes, Set<ResourceLocation> removeRecipes) {
            recipes.forEach(r -> {
                Map map = mgr.field_199522_d.computeIfAbsent(r.func_222127_g(), t -> new HashMap());
                map.putIfAbsent(r.func_199560_c(), r);
            });
            for (Map value : mgr.field_199522_d.values()) {
                value.keySet().removeAll(removeRecipes);
            }
            HammerLib.LOG.info("Registered {} additional recipes.", (Object)recipes.size());
        }

        private static void mutableManager(RecipeManager mgr) {
            mgr.field_199522_d = new HashMap(mgr.field_199522_d);
            for (IRecipeType type : mgr.field_199522_d.keySet()) {
                mgr.field_199522_d.put(type, new HashMap((Map)mgr.field_199522_d.get(type)));
            }
        }
    }
}

