/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.adapter;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import net.minecraft.block.Block;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.logging.log4j.LogManager;
import org.zeith.hammerlib.annotations.OnlyIf;
import org.zeith.hammerlib.annotations.RegistryName;
import org.zeith.hammerlib.annotations.Setup;
import org.zeith.hammerlib.annotations.SimplyRegister;
import org.zeith.hammerlib.annotations.client.ClientSetup;
import org.zeith.hammerlib.api.blocks.ICustomBlockItem;
import org.zeith.hammerlib.api.blocks.IItemGroupBlock;
import org.zeith.hammerlib.api.blocks.IItemPropertySupplier;
import org.zeith.hammerlib.api.blocks.INoItemBlock;
import org.zeith.hammerlib.api.fml.ICustomRegistrar;
import org.zeith.hammerlib.api.fml.IRegisterListener;
import org.zeith.hammerlib.core.adapter.OnlyIfAdapter;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.ReflectionUtil;

public class RegistryAdapter {
    private static final Map<Class<?>, List<Tuple<Block, ResourceLocation>>> blocks = new ConcurrentHashMap();

    public static <T extends IForgeRegistryEntry<T>> BiConsumer<ResourceLocation, T> createRegisterer(IForgeRegistry<T> registry, String prefix) {
        return (name, entry) -> {
            name = new ResourceLocation(name.func_110624_b(), prefix + name.func_110623_a());
            IRegisterListener l = Cast.cast(entry, IRegisterListener.class);
            if (l != null) {
                l.onPreRegistered();
            }
            registry.register((IForgeRegistryEntry)entry.setRegistryName(name));
            if (l != null) {
                l.onPostRegistered();
            }
        };
    }

    public static <T extends IForgeRegistryEntry<T>> int register(RegistryEvent.Register<T> event, Class<?> source, String modid, String prefix) {
        IForgeRegistry registry = event.getRegistry();
        Class superType = registry.getRegistrySuperType();
        if (superType == null) {
            return 0;
        }
        List blockList = blocks.computeIfAbsent(source, s -> new ArrayList());
        BiConsumer<ResourceLocation, IForgeRegistryEntry> grabber = RegistryAdapter.createRegisterer(registry, prefix).andThen((key, handler) -> {
            if (handler instanceof Block) {
                blockList.add(new Tuple((Object)((Block)handler), key));
            }
        });
        if (Item.class.equals((Object)superType)) {
            for (Tuple e : blockList) {
                BlockItem item;
                Block blk = (Block)e.func_76341_a();
                if (blk instanceof INoItemBlock) continue;
                IItemPropertySupplier gen = Cast.cast(blk, IItemPropertySupplier.class);
                if (blk instanceof ICustomBlockItem) {
                    item = ((ICustomBlockItem)blk).createBlockItem();
                } else {
                    Item.Properties props;
                    Item.Properties properties = props = gen != null ? gen.createItemProperties(new Item.Properties()) : new Item.Properties();
                    if (blk instanceof IItemGroupBlock) {
                        props = props.func_200916_a(((IItemGroupBlock)blk).getItemGroup());
                    }
                    item = new BlockItem(blk, props);
                }
                grabber.accept((ResourceLocation)e.func_76340_b(), (IForgeRegistryEntry)Cast.cast(item));
            }
        }
        int prevSize = registry.getValues().size();
        Arrays.stream(source.getDeclaredFields()).filter(f -> ICustomRegistrar.class.isAssignableFrom(f.getType())).forEach(field -> {
            if (Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers())) {
                try {
                    field.setAccessible(true);
                    RegistryName name = field.getAnnotation(RegistryName.class);
                    ResourceLocation rl = new ResourceLocation(modid, prefix + name.value());
                    Object val = field.get(null);
                    OnlyIf onlyIf = field.getAnnotation(OnlyIf.class);
                    if (OnlyIfAdapter.checkCondition(onlyIf, source.toString(), superType != null ? superType.getSimpleName() : field.getType().getSimpleName(), val) && val instanceof ICustomRegistrar) {
                        ((ICustomRegistrar)val).performRegister(event, rl);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    LogManager.getLogger((String)(modid + "/" + source.getSimpleName())).error("Failed to register field {}", (Object)field.getName(), (Object)e);
                }
            }
        });
        Arrays.stream(source.getDeclaredMethods()).filter(m -> m.getAnnotation(SimplyRegister.class) != null && m.getParameterCount() == 1 && BiConsumer.class.isAssignableFrom(m.getParameterTypes()[0]) && ReflectionUtil.doesParameterTypeArgsMatch(m.getParameters()[0], ResourceLocation.class, superType)).forEach(method -> {
            String prefix2 = Optional.ofNullable(method.getAnnotation(SimplyRegister.class)).map(SimplyRegister::prefix).orElse("");
            if (Modifier.isStatic(method.getModifiers())) {
                try {
                    method.setAccessible(true);
                    BiConsumer<ResourceLocation, IForgeRegistryEntry> grabber2 = (id, obj) -> {
                        id = new ResourceLocation(id.func_110624_b(), prefix2 + id.func_110623_a());
                        grabber.accept((ResourceLocation)id, (IForgeRegistryEntry)obj);
                    };
                    method.invoke(null, grabber2);
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    e.printStackTrace();
                }
            }
        });
        Arrays.stream(source.getDeclaredFields()).filter(f -> superType.isAssignableFrom(f.getType()) && !ICustomRegistrar.class.isAssignableFrom(f.getType())).forEach(field -> {
            if (Modifier.isStatic(field.getModifiers()) && Modifier.isFinal(field.getModifiers())) {
                try {
                    field.setAccessible(true);
                    RegistryName name = field.getAnnotation(RegistryName.class);
                    IForgeRegistryEntry t = (IForgeRegistryEntry)superType.cast(field.get(null));
                    ResourceLocation rl = new ResourceLocation(modid, name.value());
                    grabber.accept(rl, t);
                }
                catch (IllegalAccessException | IllegalArgumentException e) {
                    e.printStackTrace();
                }
            }
        });
        return registry.getValues().size() - prevSize;
    }

    public static void setup(FMLCommonSetupEvent event, Class<?> source, String memberName) {
        String methodName = memberName.substring(0, memberName.indexOf(40));
        Arrays.stream(source.getDeclaredMethods()).filter(m -> m.getAnnotation(Setup.class) != null && m.getName().equals(methodName)).forEach(method -> {
            if (Modifier.isStatic(method.getModifiers())) {
                try {
                    OnlyIf onlyIf = method.getAnnotation(OnlyIf.class);
                    if (!OnlyIfAdapter.checkCondition(onlyIf, source.toString(), "Setup", null)) {
                        return;
                    }
                    method.setAccessible(true);
                    if (method.getParameterCount() == 0) {
                        method.invoke(null, new Object[0]);
                    } else if (method.getParameterCount() == 1 && method.getParameterTypes()[0] == FMLCommonSetupEvent.class) {
                        method.invoke(null, event);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    RuntimeException re = null;
                    if (e instanceof InvocationTargetException && e.getCause() instanceof RuntimeException) {
                        re = (RuntimeException)e.getCause();
                    }
                    if (e instanceof RuntimeException) {
                        re = (RuntimeException)e;
                    }
                    if (re != null) {
                        throw re;
                    }
                    e.printStackTrace();
                }
            }
        });
    }

    public static void clientSetup(FMLClientSetupEvent event, Class<?> source, String memberName) {
        String methodName = memberName.substring(0, memberName.indexOf(40));
        Arrays.stream(source.getDeclaredMethods()).filter(m -> m.getAnnotation(ClientSetup.class) != null && m.getName().equals(methodName)).forEach(method -> {
            if (Modifier.isStatic(method.getModifiers())) {
                try {
                    OnlyIf onlyIf = method.getAnnotation(OnlyIf.class);
                    if (!OnlyIfAdapter.checkCondition(onlyIf, source.toString(), "ClientSetup", null)) {
                        return;
                    }
                    method.setAccessible(true);
                    if (method.getParameterCount() == 0) {
                        method.invoke(null, new Object[0]);
                    } else if (method.getParameterCount() == 1 && method.getParameterTypes()[0] == FMLClientSetupEvent.class) {
                        method.invoke(null, event);
                    }
                }
                catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                    RuntimeException re = null;
                    if (e instanceof InvocationTargetException && e.getCause() instanceof RuntimeException) {
                        re = (RuntimeException)e.getCause();
                    }
                    if (e instanceof RuntimeException) {
                        re = (RuntimeException)e;
                    }
                    if (re != null) {
                        throw re;
                    }
                    e.printStackTrace();
                }
            }
        });
    }
}

