/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.core.test.machine;

import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import org.zeith.api.wrench.IWrenchable;
import org.zeith.hammerlib.annotations.OnlyIf;
import org.zeith.hammerlib.annotations.RegistryName;
import org.zeith.hammerlib.annotations.SimplyRegister;
import org.zeith.hammerlib.annotations.TileRenderer;
import org.zeith.hammerlib.api.crafting.ICraftingExecutor;
import org.zeith.hammerlib.api.forge.TileAPI;
import org.zeith.hammerlib.api.inv.SimpleInventory;
import org.zeith.hammerlib.api.io.NBTSerializable;
import org.zeith.hammerlib.api.tiles.IContainerTile;
import org.zeith.hammerlib.core.test.TestPreferences;
import org.zeith.hammerlib.core.test.machine.BlockTestMachine;
import org.zeith.hammerlib.core.test.machine.ContainerTestMachine;
import org.zeith.hammerlib.core.test.machine.RecipeTestMachine;
import org.zeith.hammerlib.core.test.machine.TESRTestMachine;
import org.zeith.hammerlib.net.properties.PropertyInt;
import org.zeith.hammerlib.net.properties.PropertyResourceLocation;
import org.zeith.hammerlib.tiles.TileSyncableTickable;
import org.zeith.hammerlib.util.java.DirectStorage;

@SimplyRegister
public class TileTestMachine
extends TileSyncableTickable
implements IContainerTile,
ICraftingExecutor,
IWrenchable {
    @OnlyIf(owner=TestPreferences.class, member="enableTestMachine")
    @RegistryName(value="test_machine")
    @TileRenderer(value=TESRTestMachine.class)
    public static final TileEntityType<TileTestMachine> TEST_MACHINE = TileAPI.createType(TileTestMachine.class, new Block[]{BlockTestMachine.TEST_MACHINE});
    @NBTSerializable
    private int _progress;
    @NBTSerializable
    private int _maxProgress = 200;
    @NBTSerializable
    public final SimpleInventory inventory = new SimpleInventory(3);
    @NBTSerializable
    private ResourceLocation _activeRecipeId;
    public final PropertyInt progress = new PropertyInt(DirectStorage.create(i -> {
        this._progress = i;
    }, () -> this._progress));
    public final PropertyInt maxProgress = new PropertyInt(DirectStorage.create(i -> {
        this._maxProgress = i;
    }, () -> this._maxProgress));
    public final PropertyResourceLocation activeRecipeId = new PropertyResourceLocation(DirectStorage.create(r -> {
        this._activeRecipeId = r;
    }, () -> this._activeRecipeId));

    public TileTestMachine() {
        super(TEST_MACHINE);
        this.inventory.isStackValid = (i, s) -> i != 2;
        this.dispatcher.registerProperty("progress", this.progress);
        this.dispatcher.registerProperty("max_progress", this.maxProgress);
        this.dispatcher.registerProperty("ar_id", this.activeRecipeId);
    }

    @Override
    public void update() {
        if (this.isOnServer()) {
            RecipeTestMachine recipe;
            RecipeTestMachine r = this.getActiveRecipe();
            if (this.isValidRecipe(r)) {
                int p = this.progress.getInt() + 1;
                if (p >= r.getTime()) {
                    ItemStack result = r.getRecipeOutput(this);
                    if (this.output(result)) {
                        this.inventory.func_70301_a(0).func_190918_g(r.in1.getCount());
                        this.inventory.func_70301_a(1).func_190918_g(r.in2.getCount());
                        if (!this.isValidRecipe(r)) {
                            this.activeRecipeId.set(null);
                            r = null;
                            this.setEnabledState(false);
                        }
                        this.progress.setInt(0);
                    }
                } else {
                    this.progress.setInt(p);
                }
            } else {
                if (this._progress > 0) {
                    this.progress.setInt(this._progress - 1);
                    if (this.progress.getInt() <= 0) {
                        this.setEnabledState(false);
                    }
                }
                this.activeRecipeId.set(null);
                r = null;
            }
            if (r == null && this.atTickRate(10) && (recipe = (RecipeTestMachine)RecipeTestMachine.REGISTRY.getRecipes().stream().filter(this::isValidRecipe).findFirst().orElse(null)) != null) {
                if (recipe.time != this.maxProgress.getInt()) {
                    this.progress.setInt(0);
                }
                this.maxProgress.setInt(recipe.time);
                this.activeRecipeId.set(recipe.getRecipeName());
                this.setEnabledState(true);
            }
        }
    }

    public void setEnabledState(boolean enabled) {
        BlockState s = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (s.func_177230_c() == BlockTestMachine.TEST_MACHINE) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)s.func_206870_a((Property)BlockStateProperties.field_208180_g, (Comparable)Boolean.valueOf(enabled)));
        }
    }

    public RecipeTestMachine getActiveRecipe() {
        return RecipeTestMachine.REGISTRY.getRecipe(this._activeRecipeId);
    }

    private boolean output(ItemStack stack) {
        if (this.canStore(stack)) {
            ItemStack s = this.inventory.func_70301_a(2);
            if (s.func_190926_b()) {
                this.inventory.func_70299_a(2, stack);
            } else {
                this.inventory.func_70301_a(2).func_190917_f(stack.func_190916_E());
            }
            return true;
        }
        return false;
    }

    private boolean isValidRecipe(RecipeTestMachine recipe) {
        return recipe != null && recipe.in1.asIngredient().test(this.inventory.func_70301_a(0)) && this.inventory.func_70301_a(0).func_190916_E() >= recipe.in1.getCount() && recipe.in2.asIngredient().test(this.inventory.func_70301_a(1)) && this.inventory.func_70301_a(1).func_190916_E() >= recipe.in2.getCount() && this.canStore(recipe.getRecipeOutput(this));
    }

    private boolean canStore(ItemStack result) {
        ItemStack stack = this.inventory.func_70301_a(2);
        if (stack.func_190926_b()) {
            return true;
        }
        if (!ItemStack.func_179545_c((ItemStack)result, (ItemStack)stack)) {
            return false;
        }
        return stack.func_190916_E() + result.func_190916_E() <= Math.min(this.inventory.func_70297_j_(), result.func_77976_d());
    }

    @Override
    public Container openContainer(PlayerEntity player, int windowId) {
        return new ContainerTestMachine(player, windowId, this);
    }

    @Override
    public boolean onWrenchUsed(ItemUseContext context) {
        Direction facing;
        Direction origin;
        BlockState state;
        Direction d = context.func_196000_l();
        if (context.func_195999_j().func_225608_bj_()) {
            d = d.func_176734_d();
        }
        if ((state = this.field_145850_b.func_180495_p(this.field_174879_c)).func_177230_c() == BlockTestMachine.TEST_MACHINE && (origin = (facing = (Direction)state.func_177229_b((Property)BlockStateProperties.field_208157_J))) != (facing = d == Direction.UP ? facing.func_176746_e() : (d == Direction.DOWN ? facing.func_176735_f() : d))) {
            this.field_145850_b.func_175656_a(this.field_174879_c, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208157_J, (Comparable)facing));
        }
        return true;
    }
}

