/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.event.listeners;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLEnvironment;
import org.zeith.hammerlib.api.LanguageHelper;
import org.zeith.hammerlib.api.tiles.ISyncableTile;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.Network;
import org.zeith.hammerlib.net.packets.SyncTileEntityPacket;
import org.zeith.hammerlib.net.properties.IBasePropertyHolder;
import org.zeith.hammerlib.net.properties.IPropertyTile;
import org.zeith.hammerlib.util.mcf.LogicalSidePredictor;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class ServerListener {
    public static final List<TileEntity> NEED_SYNC = new ArrayList<TileEntity>();
    public static final List<TileEntity> NEED_PROP_SYNC = new ArrayList<TileEntity>();
    public static final List<IBasePropertyHolder> NEED_PROP_SYNC_GENERIC = new ArrayList<IBasePropertyHolder>();

    @SubscribeEvent
    public static void serverTick(TickEvent.ServerTickEvent e) {
        if (e.phase == TickEvent.Phase.START && FMLEnvironment.dist == Dist.DEDICATED_SERVER) {
            LanguageHelper.update();
        }
        if (e.phase == TickEvent.Phase.END) {
            TileEntity tile;
            HashSet<BlockPos> processed = new HashSet<BlockPos>();
            while (!NEED_SYNC.isEmpty()) {
                tile = NEED_SYNC.remove(0);
                if (!processed.add(tile.func_174877_v())) continue;
                if (tile instanceof ISyncableTile) {
                    ((ISyncableTile)tile).syncNow();
                    continue;
                }
                Network.sendToTracking((IPacket)new SyncTileEntityPacket(tile), tile);
            }
            processed.clear();
            while (!NEED_PROP_SYNC.isEmpty()) {
                tile = NEED_PROP_SYNC.remove(0);
                if (!processed.add(tile.func_174877_v()) || !(tile instanceof IPropertyTile)) continue;
                ((IPropertyTile)tile).syncPropertiesNow();
            }
            while (!NEED_PROP_SYNC_GENERIC.isEmpty()) {
                IBasePropertyHolder data = NEED_PROP_SYNC_GENERIC.remove(0);
                if (data == null) continue;
                data.syncPropertiesNow();
            }
        }
    }

    public static void syncProperties(TileEntity tileEntity) {
        if (LogicalSidePredictor.getCurrentLogicalSide() == LogicalSide.SERVER && tileEntity instanceof IPropertyTile) {
            NEED_PROP_SYNC.add(tileEntity);
        }
    }

    public static void syncProperties(IBasePropertyHolder ent) {
        if (LogicalSidePredictor.getCurrentLogicalSide() == LogicalSide.SERVER) {
            NEED_PROP_SYNC_GENERIC.add(ent);
        }
    }

    public static void syncTileEntity(TileEntity tileEntity) {
        if (tileEntity != null && tileEntity.func_145831_w() instanceof ServerWorld) {
            NEED_SYNC.add(tileEntity);
        }
    }
}

