/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.event.recipe;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.item.Item;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.IRecipeType;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.ApiStatus;
import org.zeith.hammerlib.api.recipes.RecipeBuilderExtension;
import org.zeith.hammerlib.core.adapter.recipe.BlastingRecipeBuilder;
import org.zeith.hammerlib.core.adapter.recipe.CampfireRecipeBuilder;
import org.zeith.hammerlib.core.adapter.recipe.ShapedRecipeBuilder;
import org.zeith.hammerlib.core.adapter.recipe.ShapelessRecipeBuilder;
import org.zeith.hammerlib.core.adapter.recipe.SmeltingRecipeBuilder;
import org.zeith.hammerlib.core.adapter.recipe.SmokingRecipeBuilder;
import org.zeith.hammerlib.core.adapter.recipe.StoneCuttingRecipeBuilder;
import org.zeith.hammerlib.util.mcf.RecipeRegistrationContext;

public class RegisterRecipesEvent
extends Event {
    private final List<IRecipe<?>> recipes = Lists.newArrayList();
    private final Set<ResourceLocation> removeRecipes = Sets.newHashSet();
    protected final Predicate<ResourceLocation> idInUse;
    private final Map<String, RecipeRegistrationContext> contextMap = Maps.newHashMap();
    private final Map<Class<?>, RecipeBuilderExtension> extensions = RecipeBuilderExtension.attach(this);

    public RegisterRecipesEvent(Predicate<ResourceLocation> idInUse) {
        this.idInUse = idInUse;
    }

    public void add(IRecipe<?> recipe) {
        if (recipe != null && this.enableRecipe(recipe.func_222127_g(), recipe.func_199560_c())) {
            this.recipes.add(recipe);
        }
    }

    public StoneCuttingRecipeBuilder stoneCutting() {
        return new StoneCuttingRecipeBuilder(this);
    }

    public SmokingRecipeBuilder smoking() {
        return new SmokingRecipeBuilder(this);
    }

    public BlastingRecipeBuilder blasting() {
        return new BlastingRecipeBuilder(this);
    }

    public CampfireRecipeBuilder campfire() {
        return new CampfireRecipeBuilder(this);
    }

    public SmeltingRecipeBuilder smelting() {
        return new SmeltingRecipeBuilder(this);
    }

    public ShapedRecipeBuilder shaped() {
        return new ShapedRecipeBuilder(this);
    }

    public ShapelessRecipeBuilder shapeless() {
        return new ShapelessRecipeBuilder(this);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isRecipeIdTaken(ResourceLocation id) {
        if (this.idInUse.test(id)) return true;
        if (!this.recipes.stream().map(IRecipe::func_199560_c).anyMatch(arg_0 -> ((ResourceLocation)id).equals(arg_0))) return false;
        return true;
    }

    public ResourceLocation nextId(Item item) {
        ResourceLocation tf;
        if (item == null || item == Items.field_190931_a) {
            return null;
        }
        ResourceLocation rl = item.getRegistryName();
        if (!this.isRecipeIdTaken(rl)) {
            return rl;
        }
        int lastIdx = 1;
        while (this.isRecipeIdTaken(tf = new ResourceLocation(rl.func_110624_b(), rl.func_110623_a() + "_" + lastIdx++))) {
        }
        return tf;
    }

    public Set<ResourceLocation> removedRecipes() {
        return Collections.unmodifiableSet(this.removeRecipes);
    }

    public RegisterRecipesEvent removeRecipe(ResourceLocation id) {
        this.removeRecipes.add(id);
        return this;
    }

    public Stream<IRecipe<?>> getRecipes() {
        return this.recipes.stream();
    }

    public boolean enableRecipe(IRecipeType<?> type, ResourceLocation recipeId) {
        return this.getContext(recipeId.func_110624_b()).enableRecipe(type, recipeId);
    }

    public boolean enableRecipe(IRecipe<?> recipe) {
        return this.enableRecipe(recipe.func_222127_g(), recipe.func_199560_c());
    }

    public RecipeRegistrationContext getContext(String modid) {
        return this.contextMap.computeIfAbsent(modid, RecipeRegistrationContext::load);
    }

    @ApiStatus.Internal
    public void cleanup() {
        for (RecipeRegistrationContext value : this.contextMap.values()) {
            value.save();
        }
        this.contextMap.clear();
    }
}

