/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.packets;

import io.netty.buffer.Unpooled;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.network.PacketBuffer;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.zeith.hammerlib.abstractions.sources.IObjectSource;
import org.zeith.hammerlib.net.IPacket;
import org.zeith.hammerlib.net.MainThreaded;
import org.zeith.hammerlib.net.PacketContext;
import org.zeith.hammerlib.net.properties.IBasePropertyHolder;

@MainThreaded
public class SendPropertiesPacket
implements IPacket {
    IObjectSource<?> source;
    byte[] data;

    public SendPropertiesPacket(IObjectSource<?> source, byte[] data) {
        this.source = source;
        this.data = data;
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.func_150786_a(IObjectSource.writeSource(this.source));
        buf.writeShort(this.data.length);
        buf.writeBytes(this.data);
    }

    @Override
    public void read(PacketBuffer buf) {
        this.source = IObjectSource.readSource(buf.func_150793_b()).orElse(null);
        this.data = new byte[buf.readShort()];
        buf.readBytes(this.data);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void clientExecute(PacketContext ctx) {
        IBasePropertyHolder tile;
        ClientWorld cw = Minecraft.func_71410_x().field_71441_e;
        if (cw != null && this.source != null && (tile = (IBasePropertyHolder)this.source.get(IBasePropertyHolder.class, (World)cw).orElse(null)) != null) {
            PacketBuffer buf = new PacketBuffer(Unpooled.wrappedBuffer((byte[])this.data));
            tile.getProperties().decodeChanges(buf);
        }
    }
}

