/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.properties;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTDynamicOps;
import net.minecraft.network.PacketBuffer;
import org.zeith.hammerlib.net.properties.PropertyBase;
import org.zeith.hammerlib.util.java.Cast;
import org.zeith.hammerlib.util.java.DirectStorage;

public class PropertyBaseCodec<T>
extends PropertyBase<T> {
    protected final Codec<T> codec;
    protected final Supplier<T> defaultValue;

    public PropertyBaseCodec(Codec<T> codec, Supplier<T> defaultValue, Class<T> type, DirectStorage<T> value) {
        super(type, value);
        this.codec = codec;
        this.defaultValue = defaultValue;
    }

    public PropertyBaseCodec(Codec<T> codec, Supplier<T> defaultValue, Class<T> type) {
        super(type);
        this.codec = codec;
        this.defaultValue = defaultValue;
    }

    @Override
    public void write(PacketBuffer buf) {
        Object value = this.value.get();
        Optional res = value == null ? Optional.empty() : this.codec.encodeStart((DynamicOps)NBTDynamicOps.field_210820_a, value).result().flatMap(tag -> Cast.optionally(tag, CompoundNBT.class));
        buf.writeBoolean(res.isPresent());
        if (res.isPresent()) {
            buf.func_150786_a((CompoundNBT)res.orElseThrow(NoSuchElementException::new));
        }
    }

    @Override
    public void read(PacketBuffer buf) {
        if (buf.readBoolean()) {
            this.value.set(this.codec.decode((DynamicOps)NBTDynamicOps.field_210820_a, (Object)buf.func_150793_b()).result().map(Pair::getFirst).orElseGet(this.defaultValue));
        } else {
            this.value.set(this.defaultValue.get());
        }
    }
}

