/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.net.properties;

import java.util.Objects;
import net.minecraft.network.PacketBuffer;
import org.zeith.hammerlib.net.properties.IProperty;
import org.zeith.hammerlib.net.properties.PropertyDispatcher;
import org.zeith.hammerlib.util.java.DirectStorage;

public class PropertyFloat
implements IProperty<Float> {
    final DirectStorage<Float> value;
    boolean changed;
    PropertyDispatcher dispatcher;

    public PropertyFloat(DirectStorage<Float> value) {
        this.value = value;
    }

    public PropertyFloat() {
        this(DirectStorage.allocate(Float.valueOf(0.0f)));
    }

    @Override
    public Class<Float> getType() {
        return Float.class;
    }

    @Override
    public Float set(Float value) {
        Float pv = this.value.get();
        if (!Objects.equals(pv, value)) {
            this.value.set(value);
            this.markChanged(true);
        }
        return pv;
    }

    @Override
    public void markChanged(boolean changed) {
        this.changed = changed;
        if (changed) {
            this.notifyDispatcherOfChange();
        }
    }

    @Override
    public boolean hasChanged() {
        return this.changed;
    }

    @Override
    public void write(PacketBuffer buf) {
        buf.writeFloat(this.value.get().floatValue());
    }

    @Override
    public void read(PacketBuffer buf) {
        this.value.set(Float.valueOf(buf.readFloat()));
    }

    @Override
    public Float get() {
        return this.value.get();
    }

    @Override
    public PropertyDispatcher getDispatcher() {
        return this.dispatcher;
    }

    @Override
    public void setDispatcher(PropertyDispatcher dispatcher) {
        this.dispatcher = dispatcher;
    }
}

