/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util;

import java.util.List;
import java.util.Random;
import net.minecraft.util.Rotation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.vector.Vector3d;

public class AABBUtils {
    public static boolean almostEqual(double a, double b) {
        return a - b > -1.0E-4 && a - b < 1.0E-4;
    }

    public static Vector3d randomPosWithin(AxisAlignedBB aabb, Random rng) {
        double x = aabb.field_72340_a + (aabb.field_72336_d - aabb.field_72340_a) * rng.nextDouble();
        double y = aabb.field_72338_b + (aabb.field_72337_e - aabb.field_72338_b) * rng.nextDouble();
        double z = aabb.field_72339_c + (aabb.field_72334_f - aabb.field_72339_c) * rng.nextDouble();
        return new Vector3d(x, y, z);
    }

    public static AxisAlignedBB rotate(AxisAlignedBB aabb, Rotation rotationIn) {
        switch (rotationIn) {
            default: {
                return aabb;
            }
            case CLOCKWISE_90: {
                return new AxisAlignedBB(-aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c, -aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
            }
            case CLOCKWISE_180: {
                return new AxisAlignedBB(-aabb.field_72340_a, aabb.field_72338_b, -aabb.field_72339_c, -aabb.field_72336_d, aabb.field_72337_e, -aabb.field_72334_f);
            }
            case COUNTERCLOCKWISE_90: 
        }
        return new AxisAlignedBB(aabb.field_72340_a, aabb.field_72338_b, -aabb.field_72339_c, aabb.field_72336_d, aabb.field_72337_e, -aabb.field_72334_f);
    }

    public static AxisAlignedBB normalize(AxisAlignedBB aabb) {
        return aabb.func_72317_d(-aabb.field_72340_a, -aabb.field_72338_b, -aabb.field_72339_c);
    }

    public static AxisAlignedBB partial(AxisAlignedBB prev, AxisAlignedBB cur, float partialTicks) {
        double x1 = prev.field_72340_a + (cur.field_72340_a - prev.field_72340_a) * (double)partialTicks;
        double y1 = prev.field_72338_b + (cur.field_72338_b - prev.field_72338_b) * (double)partialTicks;
        double z1 = prev.field_72339_c + (cur.field_72339_c - prev.field_72339_c) * (double)partialTicks;
        double x2 = prev.field_72336_d + (cur.field_72336_d - prev.field_72336_d) * (double)partialTicks;
        double y2 = prev.field_72337_e + (cur.field_72337_e - prev.field_72337_e) * (double)partialTicks;
        double z2 = prev.field_72334_f + (cur.field_72334_f - prev.field_72334_f) * (double)partialTicks;
        return new AxisAlignedBB(x1, y1, z1, x2, y2, z2);
    }

    public static AxisAlignedBB extrudeGravity(AxisAlignedBB aabb, float ySpeed) {
        float ay = Math.abs(ySpeed);
        return aabb.func_72314_b((double)(-ay) * (aabb.field_72336_d - aabb.field_72340_a) / 2.0, (double)ay * (aabb.field_72337_e - aabb.field_72338_b) / 2.0, (double)(-ay) * (aabb.field_72334_f - aabb.field_72339_c) / 2.0).func_72317_d(0.0, (double)(-ySpeed) * (aabb.field_72337_e - aabb.field_72338_b) / 2.0, 0.0);
    }

    public static void cut(AxisAlignedBB box, AxisAlignedBB knife, List<AxisAlignedBB> intoList) {
        boolean ea2;
        boolean ea1;
        if (!box.func_72326_a(knife)) {
            intoList.add(box);
            return;
        }
        AxisAlignedBB inter = box.func_191500_a(knife);
        if (!AABBUtils.almostEqual(box.field_72338_b, inter.field_72338_b)) {
            intoList.add(new AxisAlignedBB(box.field_72340_a, box.field_72338_b, box.field_72339_c, box.field_72336_d, inter.field_72338_b, box.field_72334_f));
        }
        if (!AABBUtils.almostEqual(box.field_72337_e, inter.field_72337_e)) {
            intoList.add(new AxisAlignedBB(box.field_72340_a, inter.field_72337_e, box.field_72339_c, box.field_72336_d, box.field_72337_e, box.field_72334_f));
        }
        if (ea1 = !AABBUtils.almostEqual(box.field_72336_d, inter.field_72336_d)) {
            intoList.add(new AxisAlignedBB(inter.field_72336_d, inter.field_72338_b, box.field_72339_c, box.field_72336_d, inter.field_72337_e, inter.field_72334_f));
        }
        if (ea2 = !AABBUtils.almostEqual(box.field_72334_f, inter.field_72334_f)) {
            intoList.add(new AxisAlignedBB(box.field_72340_a, inter.field_72338_b, inter.field_72334_f, inter.field_72336_d, inter.field_72337_e, box.field_72334_f));
        }
        if (ea1 && ea2) {
            intoList.add(new AxisAlignedBB(inter.field_72336_d, inter.field_72338_b, inter.field_72334_f, box.field_72336_d, inter.field_72337_e, box.field_72334_f));
        }
        if (ea1 = !AABBUtils.almostEqual(box.field_72339_c, inter.field_72339_c)) {
            intoList.add(new AxisAlignedBB(inter.field_72340_a, inter.field_72338_b, box.field_72339_c, inter.field_72336_d, inter.field_72337_e, inter.field_72339_c));
        }
        if (ea2 = !AABBUtils.almostEqual(box.field_72340_a, inter.field_72340_a)) {
            intoList.add(new AxisAlignedBB(box.field_72340_a, inter.field_72338_b, inter.field_72339_c, inter.field_72340_a, inter.field_72337_e, inter.field_72334_f));
        }
        if (ea1 || ea2) {
            intoList.add(new AxisAlignedBB(box.field_72340_a, inter.field_72338_b, box.field_72339_c, inter.field_72340_a, inter.field_72337_e, inter.field_72339_c));
        }
    }

    public static Vector3d getCenter(AxisAlignedBB aabb) {
        return new Vector3d(aabb.field_72340_a + (aabb.field_72336_d - aabb.field_72340_a) * 0.5, aabb.field_72338_b + (aabb.field_72337_e - aabb.field_72338_b) * 0.5, aabb.field_72339_c + (aabb.field_72334_f - aabb.field_72339_c) * 0.5);
    }
}

