/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util;

import java.net.URL;
import java.util.function.Supplier;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import org.apache.logging.log4j.Logger;
import org.zeith.hammerlib.client.adapter.ChatMessageAdapter;
import org.zeith.hammerlib.core.adapter.ModSourceAdapter;

public class CommonMessages {
    public static final Supplier<ITextComponent> CRAFTING_MATERIAL = () -> new TranslationTextComponent("info.hammerlib.material").func_240699_a_(TextFormatting.GRAY);

    public static CheckResult printMessageOnIllegalRedistribution(Class<?> modClass, Logger log, String modName, String downloadUrl) {
        ModSourceAdapter.ModSource illegalSourceNotice = ModSourceAdapter.getModSource(modClass).filter(ModSourceAdapter.ModSource::wasDownloadedIllegally).orElse(null);
        if (illegalSourceNotice != null) {
            log.fatal("====================================================");
            log.fatal("== WARNING: " + modName + " was downloaded from " + illegalSourceNotice.referrerDomain() + ", which has been marked as illegal site over at stopmodreposts.org.");
            log.fatal("== Please download the mod from " + downloadUrl);
            log.fatal("====================================================");
            IFormattableTextComponent illegalUri = new StringTextComponent(illegalSourceNotice.referrerDomain()).func_240700_a_(s -> s.func_240712_a_(TextFormatting.RED));
            IFormattableTextComponent smrUri = new StringTextComponent("stopmodreposts.org").func_240700_a_(s -> s.func_240712_a_(TextFormatting.BLUE).func_244282_c(Boolean.valueOf(true)).func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, "https://stopmodreposts.org/")).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent("Click to open webpage."))));
            String host = downloadUrl;
            try {
                host = new URL(downloadUrl).getAuthority();
            }
            catch (Exception exception) {
                // empty catch block
            }
            IFormattableTextComponent curseforgeUri = new StringTextComponent(host).func_240700_a_(s -> s.func_240712_a_(TextFormatting.BLUE).func_244282_c(Boolean.valueOf(true)).func_240715_a_(new ClickEvent(ClickEvent.Action.OPEN_URL, downloadUrl)).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent("Click to open webpage."))));
            ChatMessageAdapter.sendOnFirstWorldLoad((ITextComponent)new StringTextComponent("WARNING: " + modName + " was downloaded from ").func_230529_a_((ITextComponent)illegalUri).func_240702_b_(", which has been marked as illegal site over at ").func_230529_a_((ITextComponent)smrUri).func_240702_b_(". Please download the mod from ").func_230529_a_((ITextComponent)curseforgeUri).func_240702_b_("."));
            return CheckResult.VIOLATION_FOUND;
        }
        return CheckResult.OK;
    }

    public static enum CheckResult {
        OK,
        VIOLATION_FOUND;

    }
}

