/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.cfg;

import java.io.BufferedWriter;
import java.io.IOException;
import java.util.Arrays;
import org.zeith.hammerlib.util.cfg.ConfigFile;
import org.zeith.hammerlib.util.cfg.IConfigEntry;
import org.zeith.hammerlib.util.cfg.ReaderHelper;

public abstract class ConfigEntrySerializer<T extends IConfigEntry> {
    public final String type;

    public ConfigEntrySerializer(String type) {
        if (ConfigFile.serializers.get(type) != null) {
            throw new IllegalArgumentException("Duplicate config serializer for key '" + type + "'!");
        }
        ConfigFile.serializers.put(type, this);
        this.type = type;
    }

    public abstract T read(ConfigFile var1, ReaderHelper var2, int var3) throws IOException;

    public abstract void write(ConfigFile var1, BufferedWriter var2, T var3, int var4) throws IOException;

    protected void writeComment(BufferedWriter writer, String comment, int indents) throws IOException {
        String[] commentLines;
        for (String ln : commentLines = comment.split("\n")) {
            this.writeIndents(writer, indents);
            writer.write("# " + ln + "\n");
        }
    }

    protected void writeIndents(BufferedWriter writer, int indents) throws IOException {
        char[] write = new char[indents];
        Arrays.fill(write, ' ');
        writer.write(write);
    }
}

