/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.configured;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Optional;
import org.zeith.hammerlib.util.configured.ConfiguredLib;
import org.zeith.hammerlib.util.configured.io.IoNewLiner;
import org.zeith.hammerlib.util.configured.io.buf.IByteBuf;
import org.zeith.hammerlib.util.configured.types.ConfigCategory;
import org.zeith.hammerlib.util.configured.types.ConfigObject;

public class ConfigFile
extends ConfigObject<ConfigFile> {
    protected File file;
    private String version = "1.0.0";
    protected boolean hasChanged;

    public ConfigFile(File file) {
        this.terminalCharacter = (character, depth) -> character <= 0 && depth == 0;
        this.file = file;
    }

    public ConfigFile(IByteBuf buf) {
        this.terminalCharacter = (character, depth) -> character <= 0 && depth == 0;
        this.fromBuffer(buf);
    }

    public ConfigCategory setupCategory(String name) {
        return this.getElement(ConfiguredLib.CATEGORY, name);
    }

    @Override
    protected void onChanged() {
        this.hasChanged = true;
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public ConfigFile resetChangedMarker() {
        this.hasChanged = false;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    @Override
    public boolean read(BufferedReader reader, int depth, String readerStack) throws IOException {
        int c;
        if (depth != 0) {
            throw new IOException("Invalid depth for config file (" + depth + ")");
        }
        if (reader.read() != 91 || reader.read() != 67 || reader.read() != 70 || reader.read() != 71 || reader.read() != 61) {
            return false;
        }
        StringBuilder sb = new StringBuilder();
        while ((c = reader.read()) >= 0 && c != 93) {
            sb.append((char)c);
        }
        if (c != 93) {
            return false;
        }
        this.version = sb.toString();
        boolean r = super.read(reader, 0, this.file.getName());
        this.hasChanged = false;
        return r;
    }

    @Override
    public void write(BufferedWriter writer, IoNewLiner newLiner) throws IOException {
        writer.write("[CFG=1.0.0]");
        newLiner.newLine();
        newLiner.newLine();
        super.write(writer, newLiner);
        this.hasChanged = false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Optional<Exception> load() {
        if (!this.file.isFile()) return Optional.of(new FileNotFoundException(this.file.getName()));
        try (BufferedReader in = new BufferedReader(new InputStreamReader(Files.newInputStream(this.file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            this.read(in, 0, "");
            Optional<Exception> optional = Optional.empty();
            return optional;
        }
        catch (Exception e) {
            return Optional.of(e);
        }
    }

    public void save() {
        if (this.file == null) {
            return;
        }
        try (BufferedWriter out = new BufferedWriter(new OutputStreamWriter(Files.newOutputStream(this.file.toPath(), new OpenOption[0]), StandardCharsets.UTF_8));){
            this.write(out, depth -> out.write(System.lineSeparator() + ConfigFile.repeat("\t", depth)));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String repeat(String sequence, int times) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < times; ++i) {
            sb.append(sequence);
        }
        return sb.toString();
    }

    @Override
    public void toBuffer(IByteBuf buf) {
        buf.writeString(this.version);
        super.toBuffer(buf);
    }

    @Override
    public void fromBuffer(IByteBuf buf) {
        this.version = buf.readString();
        super.fromBuffer(buf);
    }

    public String toString() {
        return "ConfigFile{file=" + this.file + ", version='" + this.version + '\'' + ", elements=" + this.elements + '}';
    }
}

