/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.configured.data;

import java.math.BigInteger;
import java.util.function.Predicate;
import org.zeith.hammerlib.util.configured.struct.RangeInt;
import org.zeith.hammerlib.util.configured.struct.RangeLong;

public class IntValueRange
implements Predicate<Number> {
    protected final BigInteger min;
    protected final BigInteger max;
    protected final boolean minInclusive;
    protected final boolean maxInclusive;
    protected final boolean eq;

    public IntValueRange(BigInteger min, BigInteger max, boolean minInclusive, boolean maxInclusive) {
        this.min = min;
        this.max = max;
        this.minInclusive = minInclusive;
        this.maxInclusive = maxInclusive;
        if (max != null && max.compareTo(min) < 0) {
            throw new IllegalArgumentException("The min value of a range is greater than max value. Why?");
        }
        boolean e = max != null && max.compareTo(min) == 0;
        boolean bl = this.eq = e && (minInclusive || maxInclusive);
        if (e && !this.test(min)) {
            throw new IllegalArgumentException("The min value of a range is equal to max value, but is not included. Why?");
        }
    }

    public static IntValueRange rangeClosed(BigInteger minInclusive, BigInteger maxInclusive) {
        return new IntValueRange(minInclusive, maxInclusive, true, true);
    }

    public static IntValueRange range(BigInteger minInclusive, BigInteger maxExclusive) {
        return new IntValueRange(minInclusive, maxExclusive, true, false);
    }

    public static IntValueRange min(BigInteger minExclusive) {
        return new IntValueRange(minExclusive, null, false, false);
    }

    public static IntValueRange minClosed(BigInteger minInclusive) {
        return new IntValueRange(minInclusive, null, true, false);
    }

    public static IntValueRange max(BigInteger maxExclusive) {
        return new IntValueRange(null, maxExclusive, false, false);
    }

    public static IntValueRange maxClosed(BigInteger maxInclusive) {
        return new IntValueRange(null, maxInclusive, false, true);
    }

    public static IntValueRange rangeClosed(long minInclusive, long maxInclusive) {
        return IntValueRange.rangeClosed(BigInteger.valueOf(minInclusive), BigInteger.valueOf(maxInclusive));
    }

    public static IntValueRange range(long minInclusive, long maxExclusive) {
        return IntValueRange.range(BigInteger.valueOf(minInclusive), BigInteger.valueOf(maxExclusive));
    }

    public static IntValueRange min(long minExclusive) {
        return IntValueRange.min(BigInteger.valueOf(minExclusive));
    }

    public static IntValueRange minClosed(long minInclusive) {
        return IntValueRange.minClosed(BigInteger.valueOf(minInclusive));
    }

    public static IntValueRange max(long maxExclusive) {
        return IntValueRange.max(BigInteger.valueOf(maxExclusive));
    }

    public static IntValueRange maxClosed(long maxInclusive) {
        return IntValueRange.maxClosed(BigInteger.valueOf(maxInclusive));
    }

    public static IntValueRange fromIntRange(RangeInt r) {
        if (r.min() == Integer.MIN_VALUE) {
            return IntValueRange.maxClosed(r.max());
        }
        if (r.max() == Integer.MAX_VALUE) {
            return IntValueRange.minClosed(r.min());
        }
        return IntValueRange.rangeClosed(r.min(), r.max());
    }

    public static IntValueRange fromLongRange(RangeLong r) {
        if (r.min() == Long.MIN_VALUE) {
            return IntValueRange.maxClosed(r.max());
        }
        if (r.max() == Long.MAX_VALUE) {
            return IntValueRange.minClosed(r.min());
        }
        return IntValueRange.rangeClosed(r.min(), r.max());
    }

    public BigInteger enclose(BigInteger origin) {
        if (origin == null) {
            return null;
        }
        if (this.min != null) {
            origin = origin.max(this.minInclusive ? this.min : this.min.add(BigInteger.ONE));
        }
        if (this.max != null) {
            origin = origin.min(this.maxInclusive ? this.max : this.max.subtract(BigInteger.ONE));
        }
        return origin;
    }

    @Override
    public boolean test(Number number) {
        BigInteger big = number instanceof BigInteger ? (BigInteger)number : BigInteger.valueOf(number.longValue());
        if (this.eq && big.equals(this.min)) {
            return true;
        }
        if (this.min != null && big.compareTo(this.min) < (this.minInclusive ? 0 : 1)) {
            return false;
        }
        return this.max == null || big.compareTo(this.max) <= (this.maxInclusive ? 0 : 1);
    }

    public String toString() {
        return (this.minInclusive && this.min != null ? "[" : "(") + (this.min != null ? this.min : "-") + "; " + (this.max != null ? this.max : "+") + (this.maxInclusive && this.max != null ? "]" : ")");
    }
}

