/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.configured.struct.mappers;

import java.math.BigDecimal;
import java.util.Optional;
import java.util.function.Function;
import org.zeith.hammerlib.util.configured.ConfigToken;
import org.zeith.hammerlib.util.configured.ConfiguredLib;
import org.zeith.hammerlib.util.configured.data.DecimalValueRange;
import org.zeith.hammerlib.util.configured.struct.RangeDouble;
import org.zeith.hammerlib.util.configured.struct.RangeFloat;
import org.zeith.hammerlib.util.configured.struct.mappers.ITokenMapper;
import org.zeith.hammerlib.util.configured.struct.reflection.IField;
import org.zeith.hammerlib.util.configured.types.ConfigDecimal;

public class DecimalMapper<N extends Number>
implements ITokenMapper<ConfigDecimal, N> {
    protected final Class<N> type;
    protected final Function<BigDecimal, N> converter;

    public DecimalMapper(Class<N> type, Function<BigDecimal, N> converter) {
        this.type = type;
        this.converter = converter;
    }

    @Override
    public Class<N> getType() {
        return this.type;
    }

    @Override
    public ConfigToken<ConfigDecimal> getToken() {
        return ConfiguredLib.DECIMAL;
    }

    @Override
    public N apply(ConfigDecimal element) {
        return (N)((Number)Optional.ofNullable(element.getValue()).map(this.converter).orElse(null));
    }

    @Override
    public void defaultValue(ConfigDecimal element, IField<?> ownerField, N defaultValue) {
        Optional.ofNullable(ownerField).map(f -> f.annotation(RangeFloat.class).map(DecimalValueRange::fromFloatRange).orElseGet(() -> f.annotation(RangeDouble.class).map(DecimalValueRange::fromDoubleRange).orElse(null))).ifPresent(element::withRange);
        if (defaultValue != null) {
            if (defaultValue instanceof BigDecimal) {
                element.withDefault((BigDecimal)defaultValue);
            } else {
                element.withDefault(BigDecimal.valueOf(((Number)defaultValue).doubleValue()));
            }
        }
    }
}

