/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.configured.types;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.zeith.hammerlib.util.configured.ConfigToken;
import org.zeith.hammerlib.util.configured.ConfiguredLib;
import org.zeith.hammerlib.util.configured.io.IoNewLiner;
import org.zeith.hammerlib.util.configured.io.StringReader;
import org.zeith.hammerlib.util.configured.io.buf.IByteBuf;
import org.zeith.hammerlib.util.configured.types.ConfigElement;

public class ConfigArray<E extends ConfigElement<E>>
extends ConfigElement<ConfigArray<E>> {
    protected final ConfigToken<E> elementToken;
    protected final List<E> elements = new ArrayList();
    protected boolean hasRead;

    public ConfigArray(Runnable onChanged, ConfigToken<ConfigArray<E>> token, ConfigToken<E> elementToken, String name) {
        super(onChanged, token, name);
        this.elementToken = elementToken;
        this.nameTerminator = c -> c == 61;
    }

    @Override
    public String getComment() {
        if (!this.elements.isEmpty()) {
            return ((ConfigElement)this.elements.get(0)).getComment();
        }
        return super.getComment();
    }

    @Override
    public ConfigArray<E> withComment(String comment) {
        for (ConfigElement element : this.elements) {
            element.withComment(comment);
        }
        return (ConfigArray)super.withComment(comment);
    }

    public ConfigToken<E> getElementToken() {
        return this.elementToken;
    }

    public E createElement() {
        E e = this.elementToken.create(this.onChanged, "[" + this.elements.size() + "]");
        if (this.comment != null) {
            ((ConfigElement)e).withComment(this.comment);
        }
        this.elements.add(e);
        return e;
    }

    @Override
    public List<?> getValue() {
        return this.elements.stream().map(ConfigElement::getValue).collect(Collectors.toList());
    }

    public List<E> getElements() {
        return this.elements;
    }

    public void clear() {
        this.elements.clear();
    }

    public boolean hasRead() {
        return this.hasRead;
    }

    @Override
    public boolean read(BufferedReader reader, int depth, String readerStack) throws IOException {
        reader.mark(1);
        if (reader.read() != 91) {
            return false;
        }
        this.hasRead = true;
        this.clear();
        while (true) {
            reader.mark(32);
            int c = StringReader.skipWhitespaces(reader);
            if (c >= 0) {
                char ch = (char)c;
                if (ch == ']') {
                    return true;
                }
                if (c == 44 && !this.elements.isEmpty()) continue;
            } else {
                return false;
            }
            reader.reset();
            E data = this.elementToken.create(this.onChanged, "[" + this.elements.size() + "]");
            if (!((ConfigElement)data).read(reader, depth + 1, readerStack + "->" + this.name)) continue;
            if (this.comment != null) {
                ((ConfigElement)data).withComment(this.comment);
            }
            this.elements.add(data);
        }
    }

    @Override
    public void write(BufferedWriter writer, IoNewLiner newLiner) throws IOException {
        writer.write(91);
        if (this.elements.isEmpty()) {
            writer.write(93);
            return;
        }
        if (this.elements.size() > 1) {
            newLiner.newLine();
        }
        IoNewLiner pushed = newLiner.push();
        for (int i = 0; i < this.elements.size(); ++i) {
            ConfigElement com = (ConfigElement)this.elements.get(i);
            com.write(writer, pushed);
            if (i + 1 >= this.elements.size()) continue;
            writer.write(44);
            newLiner.newLine();
        }
        if (this.elements.size() > 1) {
            newLiner.newLine(-1);
        }
        writer.write(93);
    }

    @Override
    public void toBuffer(IByteBuf buf) {
        buf.writeShort(this.elements.size());
        buf.writeString(this.elementToken.getPrefix());
        for (ConfigElement e : this.elements) {
            e.toBuffer(buf);
        }
    }

    @Override
    public void fromBuffer(IByteBuf buf) {
        this.clear();
        int size = buf.readShort();
        ConfigToken<?> type = ConfiguredLib.getByPrefix(buf.readString());
        for (int i = 0; i < size; ++i) {
            Object inst = type.create(this.onChanged, "[" + i + "]");
            ((ConfigElement)inst).fromBuffer(buf);
            if (!this.elementToken.is((ConfigElement<?>)inst)) continue;
            this.elements.add(inst);
        }
    }

    public String toString() {
        return "ConfigArray{components=" + this.elements + ", name='" + this.name + '\'' + ", comment='" + this.getEscapedComment() + '\'' + '}';
    }
}

