/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.configured.types;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import org.zeith.hammerlib.util.configured.ConfigToken;
import org.zeith.hammerlib.util.configured.ConfiguredLib;
import org.zeith.hammerlib.util.configured.io.IoNewLiner;
import org.zeith.hammerlib.util.configured.io.StringReader;
import org.zeith.hammerlib.util.configured.io.buf.IByteBuf;
import org.zeith.hammerlib.util.configured.types.ConfigElement;
import org.zeith.hammerlib.util.java.tuples.Tuple2;
import org.zeith.hammerlib.util.java.tuples.Tuples;

public class ConfigObject<T extends ConfigObject<T>>
extends ConfigElement<T> {
    protected final Map<String, ConfigElement<?>> elements = new HashMap();
    protected BiPredicate<Integer, Integer> terminalCharacter = (character, depth) -> false;

    public ConfigObject(Runnable onChanged, ConfigToken<T> token, String name) {
        super(onChanged, token, name);
    }

    public ConfigObject() {
        super(null, null, "root");
        this.onChanged = this::onChanged;
    }

    @Override
    public Map<String, ?> getValue() {
        return this.elements.entrySet().stream().map(e -> Tuples.immutable(e.getKey(), ((ConfigElement)e.getValue()).getValue())).filter(t -> t.b() != null).collect(Collectors.toMap(Tuple2::a, Tuple2::b));
    }

    protected void onChanged() {
    }

    public <E extends ConfigElement<E>> E getElement(ConfigToken<E> token, String name) {
        if (this.elements.containsKey(name) && !token.is(this.elements.get(name))) {
            this.elements.remove(name);
        }
        return (E)this.elements.computeIfAbsent(name, n -> token.create(this.onChanged, (String)n));
    }

    @Override
    public boolean read(BufferedReader reader, int depth, String readerStack) throws IOException {
        this.elements.clear();
        while (true) {
            reader.mark(1);
            int c = StringReader.skipWhitespaces(reader);
            if (c >= 0 && this.terminalCharacter.test(c, depth)) {
                return true;
            }
            if (c < 0) {
                return depth == 1;
            }
            reader.reset();
            Optional<String> comm = this.readComment(reader, depth);
            String tokenId = StringReader.readUntilWhitespace(reader);
            ConfigToken<?> token = ConfiguredLib.getByPrefix(tokenId);
            if (token != null) {
                String name;
                Object data = token.create(this.onChanged, this.name);
                ((ConfigElement)data).name = name = StringReader.readName(reader, ((ConfigElement)data).nameTerminator.or(r -> Character.isWhitespace((char)r) || r == 34));
                comm.ifPresent(c0 -> {
                    data.comment = c0;
                });
                reader.reset();
                char ch = (char)reader.read();
                if (ch == '=' && ((ConfigElement)data).read(reader, depth + 1, readerStack + "->" + name)) {
                    this.elements.put(name, (ConfigElement<?>)data);
                    continue;
                }
                return false;
            }
            reader.reset();
            reader.skip(tokenId.length());
        }
    }

    @Override
    public void write(BufferedWriter writer, IoNewLiner newLiner) throws IOException {
        int added = 0;
        for (String name : this.elements.keySet().stream().sorted().collect(Collectors.toList())) {
            ConfigElement<?> val = this.elements.get(name);
            String com = Optional.ofNullable(val.getComment()).filter(s -> !s.isEmpty()).orElse(null);
            if (com != null) {
                boolean multiline = com.contains("\n");
                writer.write("/*");
                if (multiline) {
                    newLiner.newLine();
                    writer.write(9);
                } else {
                    writer.write(32);
                }
                char[] ca = com.toCharArray();
                for (int i = 0; i < ca.length; ++i) {
                    char c2 = ca[i];
                    if (c2 == '\\') {
                        writer.write(92);
                    }
                    if (c2 == '*' && i + 1 < ca.length && ca[i + 1] == '/') {
                        writer.write(92);
                    }
                    if (c2 == '\n') {
                        newLiner.newLine();
                        writer.write(9);
                        continue;
                    }
                    writer.write(c2);
                }
                if (multiline) {
                    newLiner.newLine();
                } else {
                    writer.write(32);
                }
                writer.write("*/");
                newLiner.newLine();
            }
            writer.write(val.getToken().getPrefix() + " ");
            StringReader.writeName(writer, name, c -> Character.isWhitespace((char)c));
            writer.write(61);
            val.write(writer, newLiner.push());
            if (++added >= this.elements.size()) continue;
            newLiner.newLine();
            newLiner.newLine();
        }
    }

    @Override
    public void toBuffer(IByteBuf buf) {
        buf.writeShort(this.elements.size());
        for (Map.Entry<String, ConfigElement<?>> e : this.elements.entrySet()) {
            buf.writeString(e.getKey());
            buf.writeString(e.getValue().getToken().getPrefix());
            e.getValue().toBuffer(buf);
        }
    }

    @Override
    public void fromBuffer(IByteBuf buf) {
        this.elements.clear();
        int size = buf.readShort();
        for (int i = 0; i < size; ++i) {
            String name = buf.readString();
            String token = buf.readString();
            Object e = ConfiguredLib.getByPrefix(token).create(this.onChanged, name);
            ((ConfigElement)e).fromBuffer(buf);
            this.elements.put(name, (ConfigElement<?>)e);
        }
    }
}

