/*
 * Decompiled with CFR 0.152.
 */
package org.zeith.hammerlib.util.mcf;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.nio.BufferUnderflowException;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import net.minecraft.network.PacketBuffer;
import org.zeith.hammerlib.HammerLib;
import org.zeith.hammerlib.util.java.consumers.Consumer2;

public class ByteBufTransposer {
    public static final byte[] EMPTY = new byte[0];

    public static <T> T read(byte[] data, Function<PacketBuffer, T> reader) {
        PacketBuffer buf = new PacketBuffer(Unpooled.wrappedBuffer((byte[])data));
        try {
            return reader.apply(buf);
        }
        catch (ArrayIndexOutOfBoundsException | BufferUnderflowException e) {
            HammerLib.LOG.error("Failed to ByteBufTransposer.read:", (Throwable)e);
            return null;
        }
    }

    public static <T> byte[] transpose(T value, BiConsumer<T, PacketBuffer> writer) {
        return ByteBufTransposer.transpose(buf -> writer.accept(value, (PacketBuffer)buf));
    }

    public static <T> byte[] transpose(T value, Consumer2<PacketBuffer, T> writer) {
        return ByteBufTransposer.transpose(buf -> writer.accept((PacketBuffer)buf, value));
    }

    public static byte[] transpose(Consumer<PacketBuffer> writer) {
        return ByteBufTransposer.begin().accept(writer).transpose();
    }

    public static Builder begin() {
        return new Builder();
    }

    public static class Builder {
        protected final ByteBuf bb = Unpooled.buffer();
        protected final PacketBuffer buf = new PacketBuffer(this.bb);

        public PacketBuffer buffer() {
            return this.buf;
        }

        public Builder accept(Consumer<PacketBuffer> writer) {
            writer.accept(this.buf);
            return this;
        }

        public byte[] transpose() {
            int size = this.bb.writerIndex();
            if (size > 0) {
                this.bb.readerIndex(0);
                byte[] data = new byte[size];
                this.bb.readBytes(data);
                return data;
            }
            return EMPTY;
        }
    }
}

